/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMAccessSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthException;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptorAdapter;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;

public class SiteAccessInterceptor
extends GenericRestInterceptorAdapter {
    private static final String INDEX_PAGE = "/";
    private static final String AUTH_ATTRIBUTE = SiteAccessInterceptor.class.getName() + ".authSessionToken";

    public void before(RestContext context, Map<String, Object> data) throws Exception {
        EntityReference siteRef = (EntityReference)data.get(IBusIbecorpContextKeys.SITE.name());
        try {
            String referer;
            SMSite site = (SMSite)EntityStorage.get().resolve(siteRef).getEntity();
            SMAccessSettings settings = CommonHelper.getAccessSettings((EntityReference<SMSite>)siteRef);
            if (!settings.isAccessEnabled()) {
                throw Xeption.forDeveloper((String)String.format("Access is disabled by setting of site [%s]", site.getDomain()), (Object[])new Object[0]);
            }
            if (settings.isIframeMode() && !(referer = context.getRequest().getHeader("referer").substring(7)).equals("") && !referer.startsWith(site.getDomain()) && !referer.startsWith(settings.getParentDomain())) {
                Xeption.forDeveloper((String)String.format("Access is disabled by iframe mode. Parent domain [%s], site [%s]", settings.getParentDomain(), site.getDomain()), (Object[])new Object[0]);
            }
            if (!settings.isWebAnonymousEnabled()) {
                String[] credentials;
                HttpSession session = context.getRequest().getSession();
                if (context.getRequest().getParameter("filterLogout") != null) {
                    session.invalidate();
                    context.getResponse().sendRedirect(INDEX_PAGE);
                    return;
                }
                String authenticated = (String)session.getAttribute(AUTH_ATTRIBUTE);
                if (authenticated != null && authenticated.equals(context.getRequest().getServerName())) {
                    return;
                }
                String username = null;
                String password = null;
                String header = context.getRequest().getHeader("Authorization");
                if (header != null && (credentials = this.parseHeader(header)) != null) {
                    username = credentials[0];
                    password = credentials[1];
                }
                if (username == null) {
                    username = context.getRequest().getParameter("filterUsername");
                    password = context.getRequest().getParameter("filterPassword");
                }
                if (username != null && password != null && username.equals(settings.getWebLogin()) && password.equals(settings.getWebPassword())) {
                    session.setAttribute(AUTH_ATTRIBUTE, (Object)context.getRequest().getServerName());
                    return;
                }
                context.getResponse().setHeader("WWW-Authenticate", "Basic realm=\"Anonymous access disabled\"");
                context.getResponse().setStatus(401);
                context.setStatus(401);
                throw new AuthException();
            }
        }
        catch (Exception e) {
            if (!(e instanceof AuthException)) {
                context.setStatus(403);
            }
            throw e;
        }
    }

    private String[] parseHeader(String authorization) {
        String decoded;
        int separator;
        String basic;
        StringTokenizer st = new StringTokenizer(authorization);
        if (st.hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (separator = (decoded = new String(Base64.decodeBase64((byte[])st.nextToken().getBytes()))).indexOf(":")) != -1) {
            String username = decoded.substring(0, separator);
            String password = decoded.substring(separator + 1);
            return new String[]{username, password};
        }
        return null;
    }
}

