/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.GeocoderApiTokenType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MultiLingualImageData;
import com.gridnine.xtrip.common.model.ibecorp.sm.MultiLingualText;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep1Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep4Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMVisualSettings;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.system.model.RegionalType;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.TextPatternHelperEngine;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.CustomerRulesRail;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.FirstStepSettings;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.FourthStepSettings;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.GeneralSettings;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.GeocoderApiToken;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.PassengerTypeDocuments;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.SalesOfficeDetails;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.SecondStepSettings;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.ThirdStepSettings;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.site.VisualSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;

public class SiteConverterHelper {
    private static final List<DictionaryReference<PassengerType>> BASE_PASSENGER_TYPES = Arrays.asList(DictHelper.getAdultPassengerType(), DictHelper.getChildPassengerType(), ((PassengerType)Objects.requireNonNull(DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.CHILD_RF))).toReference(), DictHelper.getInfantPassengerType(), ((PassengerType)Objects.requireNonNull(DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.INFANT_WITH_SITE))).toReference(), ((PassengerType)Objects.requireNonNull(DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR))).toReference(), ((PassengerType)Objects.requireNonNull(DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH))).toReference());

    private SiteConverterHelper() {
    }

    public static String getLocalizedText(MultiLingualText text) {
        if (text == null) {
            return null;
        }
        Locale locale = LocaleHelper.getCurrentLocale();
        if ("ru".equals(locale.getLanguage())) {
            if (text.getRu() == null) {
                return null;
            }
            return text.isIsHtml() ? text.getRu().replaceAll("contenteditable=\"true\"", "") : text.getRu().replaceAll("(\r\n|\n)", "<br />");
        }
        if ("en".equals(locale.getLanguage())) {
            if (text.getEn() == null) {
                return null;
            }
            return text.isIsHtml() ? text.getEn().replaceAll("contenteditable=\"true\"", "") : text.getEn().replaceAll("(\r\n|\n)", "<br />");
        }
        if ("bg".equals(locale.getLanguage())) {
            if (text.getBg() == null) {
                return null;
            }
            return text.isIsHtml() ? text.getBg().replaceAll("contenteditable=\"true\"", "") : text.getBg().replaceAll("(\r\n|\n)", "<br />");
        }
        if ("uk".equals(locale.getLanguage())) {
            if (text.getUk() == null) {
                return null;
            }
            return text.isIsHtml() ? text.getUk().replaceAll("contenteditable=\"true\"", "") : text.getUk().replaceAll("(\r\n|\n)", "<br />");
        }
        if ("hy".equals(locale.getLanguage())) {
            if (text.getHy() == null) {
                return null;
            }
            return text.isIsHtml() ? text.getHy().replaceAll("contenteditable=\"true\"", "") : text.getHy().replaceAll("(\r\n|\n)", "<br />");
        }
        if ("az".equals(locale.getLanguage())) {
            if (text.getAz() == null) {
                return null;
            }
            return text.isIsHtml() ? text.getAz().replaceAll("contenteditable=\"true\"", "") : text.getAz().replaceAll("(\r\n|\n)", "<br />");
        }
        if ("ka".equals(locale.getLanguage())) {
            if (text.getKa() == null) {
                return null;
            }
            return text.isIsHtml() ? text.getKa().replaceAll("contenteditable=\"true\"", "") : text.getKa().replaceAll("(\r\n|\n)", "<br />");
        }
        if ("kk".equals(locale.getLanguage())) {
            if (text.getKz() == null) {
                return null;
            }
            return text.isIsHtml() ? text.getKz().replaceAll("contenteditable=\"true\"", "") : text.getKz().replaceAll("(\r\n|\n)", "<br />");
        }
        return null;
    }

    public static String getLocalizedText(Map<String, String> locolizedText) {
        Locale locale = LocaleHelper.getCurrentLocale();
        return locolizedText.get(locale.getLanguage());
    }

    @Deprecated
    private static MultiLingualText getRandomMessage(List<MultiLingualText> multiLingualTexts) {
        if (!multiLingualTexts.isEmpty()) {
            int number = 0;
            if (multiLingualTexts.size() > 1) {
                number = new Random().nextInt(multiLingualTexts.size() - 1);
            }
            return multiLingualTexts.get(number);
        }
        return null;
    }

    public static List<DictionaryReference<PassengerType>> getBasePassengerTypes() {
        return Collections.unmodifiableList(BASE_PASSENGER_TYPES);
    }

    private static SalesOfficeDetails convertSalesOfficeDetails2Rest(com.gridnine.xtrip.common.model.ibecorp.sm.SalesOfficeDetails salesOfficeDetails) {
        SalesOfficeDetails result = new SalesOfficeDetails();
        result.setUid(salesOfficeDetails.getUid());
        result.setCity(salesOfficeDetails.getAddress().getCity());
        result.setCountry(salesOfficeDetails.getAddress().getCountry());
        result.setAddress((String)CommonConverterHelper.findByLocale(salesOfficeDetails.getAddress().getAddress().getValues(), LocaleHelper.getCurrentLocale()));
        return result;
    }

    public static GeneralSettings convertGeneralSettings2Rest(SMGeneralSettings generalSettings, boolean convertSensitiveData) {
        GeneralSettings result = new GeneralSettings();
        result.setCurrency((DictionaryReference)Objects.requireNonNull(DictHelper.getCurrencyInfoByAnyCode((String)DictHelper.getEquivCurrency())).toReference());
        result.setDefaultCitizenship(generalSettings.getDefaultCountry());
        result.setDefaultLocale((String)Optional.ofNullable(generalSettings.getDefaultLocale()).map(Locale::getLanguage).orElse(null));
        result.getAdditionalLocales().addAll(generalSettings.getAdditionalLocales().stream().map(Locale::getLanguage).collect(Collectors.toList()));
        result.setPersonalAccountEnabled(generalSettings.isPersonalCabinetEnabled());
        result.setHideUnavailableServices(generalSettings.isHideUnavailableServices());
        if (convertSensitiveData) {
            result.setGoogleMapsApiKey(generalSettings.getGoogleMapsApiKey());
            if (Objects.nonNull(generalSettings.getGeocoderApiToken()) || generalSettings.getGeocoderApiTokenType() == GeocoderApiTokenType.IWAY) {
                GeocoderApiToken geocoderApiToken = new GeocoderApiToken();
                if (generalSettings.getGeocoderApiTokenType() != GeocoderApiTokenType.IWAY) {
                    geocoderApiToken.setToken(generalSettings.getGeocoderApiToken());
                }
                geocoderApiToken.setType(Optional.ofNullable(generalSettings.getGeocoderApiTokenType()).orElse(GeocoderApiTokenType.YANDEX));
                result.setGeocoderApiToken(geocoderApiToken);
            }
        }
        return result;
    }

    public static FirstStepSettings convertFirstStepSettings2Rest(SMStep1Settings firstStepSettings, SalesContext salesContext) throws Exception {
        FirstStepSettings result = new FirstStepSettings();
        result.setSearchMatrixFlightsEnabled(firstStepSettings.isFlexDatesSearchEnabled());
        result.setDisplayMultiTicketOption(firstStepSettings.isMultiTicketOptionEnabled());
        result.setMultistopEnabled(firstStepSettings.isMultistopsEnabled());
        result.setDefaultDepartureLocation(firstStepSettings.getDefaultDepartureLocation());
        result.setDefaultRailDepartureLocation(firstStepSettings.getDefaultRailDepartureLocation());
        result.setDefaultHotelDepartureLocation(SiteConverterHelper.buildHotelGeoLocationReference((DictionaryReference<GeoLocation>)firstStepSettings.getDefaultHotelDepartureLocation()));
        result.setDefaultDepartureDateDelta(firstStepSettings.getDefaultDepartureDateDelta().intValue());
        result.setDirectFilterOptionEnabled(firstStepSettings.isDirectOnlySearchEnabled());
        result.setDisplayChildsAgeSelector(firstStepSettings.isDisplayChildAgeSelector());
        result.setDisplayExtraChildPassengerTypes(firstStepSettings.isDisplayExtraChildPassengerTypes());
        result.setDisplayExcludeBaglessFares(firstStepSettings.isDisplayExcludeBaglessFares());
        result.getAvailablePassengersTypes().addAll(BASE_PASSENGER_TYPES);
        if (!firstStepSettings.isAddPassengerTypeSenior()) {
            result.getAvailablePassengersTypes().remove(((PassengerType)Objects.requireNonNull(DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR))).toReference());
        }
        if (!firstStepSettings.isAddPassengerTypeYouth()) {
            result.getAvailablePassengersTypes().remove(((PassengerType)Objects.requireNonNull(DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH))).toReference());
        }
        if (!firstStepSettings.isAddPassengerTypeChildRF()) {
            result.getAvailablePassengersTypes().remove(((PassengerType)Objects.requireNonNull(DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.CHILD_RF))).toReference());
        }
        return result;
    }

    private static DictionaryReference<GeoLocation> buildHotelGeoLocationReference(DictionaryReference<GeoLocation> locRef) {
        return SiteConverterHelper.buildHotelGeoLocationReference((MiscUtil.Pair<GeoLocation, String>)new MiscUtil.Pair((Object)DictionaryCache.get().resolveReference(locRef), null), LocaleHelper.getCurrentLocale());
    }

    public static DictionaryReference<GeoLocation> buildHotelGeoLocationReference(MiscUtil.Pair<GeoLocation, String> loc, Locale locale) {
        Country country;
        if (loc == null) {
            return null;
        }
        GeoLocation geoLocation = (GeoLocation)loc.getFirst();
        if (geoLocation == null) {
            return null;
        }
        String code = (String)geoLocation.getCodeVariants().get(CodeSystem.HOTEL_AGGREGATOR.name());
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        String cityName = geoLocation.toString(locale);
        String aggCityName = (String)loc.getSecond();
        if (TextUtil.nonBlank((String)aggCityName) && !aggCityName.equals(cityName)) {
            cityName = cityName + " (" + aggCityName + ")";
        }
        String countryName = (country = (Country)DictHelper.resolve((DictionaryReference)geoLocation.getCountry())) != null ? country.toString(locale) : null;
        String caption = TextUtil.isBlank((String)countryName) ? cityName : String.join((CharSequence)", ", cityName, countryName);
        return new GeoLocationReference(code, caption);
    }

    public static SecondStepSettings convertSecondStepSettings2Rest(SMStep2Settings smStep2Settings) {
        SecondStepSettings result = new SecondStepSettings();
        result.setPriceDisplayStyle(smStep2Settings.getPriceDisplayStyle());
        result.setFilterExchangeableEnabled(smStep2Settings.isFilterExchangeable());
        result.setFilterRefundableEnabled(smStep2Settings.isFilterRefundable());
        result.setFilterHotelMeal(smStep2Settings.isFilterHotelMeal());
        result.setFilterHotelRefundable(smStep2Settings.isFilterHotelRefundable());
        result.setFilterHotelSubProvider(smStep2Settings.isFilterHotelSubProvider());
        result.setFilterHotelAvailability(smStep2Settings.isFilterHotelAvailability());
        result.setFilterHotelTripartiteContract(smStep2Settings.isFilterHotelTripartiteContract());
        result.setFilterHotelSpecialRates(smStep2Settings.isFilterHotelSpecialRates());
        return result;
    }

    public static VisualSettings convertVisualSettings2Rest(SMVisualSettings smVisualSettings, SalesContext saleContext) {
        VisualSettings result = new VisualSettings();
        TextPatternHelperEngine textPattern = new TextPatternHelperEngine(saleContext);
        result.setSiteTitle(SiteConverterHelper.getLocalizedText(smVisualSettings.getSiteTitle()));
        result.setMetaDescription(smVisualSettings.getMetaDescription());
        result.setBottomBlockPresent(smVisualSettings.isBottomBlockPresent());
        result.setBottomBlock(textPattern.replacePatterns(SiteConverterHelper.getLocalizedText(smVisualSettings.getBottomBlock())));
        result.setTopBlockPresent(smVisualSettings.isTopBlockPresent());
        result.setTopBlock(textPattern.replacePatterns(SiteConverterHelper.getLocalizedText(smVisualSettings.getTopBlock())));
        result.setLeftBlockPresent(smVisualSettings.isLeftBlockPresent());
        result.setLeftBlock(textPattern.replacePatterns(SiteConverterHelper.getLocalizedText(smVisualSettings.getLeftBlock())));
        result.setRightBlockPresent(smVisualSettings.isRightBlockPresent());
        result.setRightBlock(textPattern.replacePatterns(SiteConverterHelper.getLocalizedText(smVisualSettings.getRightBlock())));
        result.setRegionalTypeKZ(SystemHelper.containsInRegionalSettings((RegionalType)RegionalType.KZ));
        result.setLogo(SiteConverterHelper.getConverterToBase64(smVisualSettings.getLogo()));
        return result;
    }

    public static String getConverterToBase64(MultiLingualImageData imageData) {
        BinaryData binaryData = SiteConverterHelper.getLocalBinaryData(imageData, LocaleHelper.getCurrentLocale().getLanguage());
        if (binaryData != null) {
            String type = HttpHelper.getMimeType((ContentType)binaryData.getContentType());
            return String.format("data:%s;base64, %s", type, Base64.encode((byte[])binaryData.getData()));
        }
        return null;
    }

    public static BinaryData getLocalBinaryData(MultiLingualImageData imageData, String local) {
        if (local == null) {
            return null;
        }
        switch (local.toLowerCase()) {
            case "ru": {
                return imageData.getRu();
            }
            case "en": {
                return imageData.getEn();
            }
            case "kz": {
                return imageData.getKz();
            }
            case "hy": {
                return imageData.getHy();
            }
            case "bg": {
                return imageData.getBg();
            }
            case "ka": {
                return imageData.getKa();
            }
            case "uk": {
                return imageData.getUk();
            }
            case "az": {
                return imageData.getAz();
            }
        }
        return null;
    }

    public static ThirdStepSettings convertThirdStepSettings2Rest(SMStep3Settings step3Settings) {
        ThirdStepSettings result = new ThirdStepSettings();
        result.setDisplayRulesInOneLine(step3Settings.isDisplayRulesInOneLine());
        result.setDisplayIataRules(step3Settings.isDisplayIataRulesBlock());
        result.setBriefBookingRules(SiteConverterHelper.getLocalizedText(step3Settings.getBookingRulesSmallBlock()));
        result.setFullBookingRules(SiteConverterHelper.getLocalizedText(step3Settings.getBookingRulesBigBlock()));
        result.setBriefBookingRulesRail(SiteConverterHelper.getLocalizedText(step3Settings.getBookingRulesRailSmallBlock()));
        result.setFullBookingRulesRail(SiteConverterHelper.getLocalizedText(step3Settings.getBookingRulesRailBigBlock()));
        ArrayList rulesRail = new ArrayList();
        step3Settings.getCustomerRules().forEach(customer2RuleText -> {
            CustomerRulesRail rule = new CustomerRulesRail();
            rule.setCustomer(customer2RuleText.getCustomer());
            rule.setRulesText(customer2RuleText.getRulesText());
            rulesRail.add(rule);
        });
        result.getCustomerRulesRail().addAll(rulesRail);
        result.setBriefBookingRulesHotels(SiteConverterHelper.getLocalizedText(step3Settings.getBookingRulesHotelsSmallBlock()));
        result.setFullBookingRulesHotels(SiteConverterHelper.getLocalizedText(step3Settings.getBookingRulesHotelsBigBlock()));
        result.setBriefBookingRulesTransfers(SiteConverterHelper.getLocalizedText(step3Settings.getBookingRulesTransfersSmallBlock()));
        result.setFullBookingRulesTransfers(SiteConverterHelper.getLocalizedText(step3Settings.getBookingRulesTransfersBigBlock()));
        result.setSecurityRulesInfo(SiteConverterHelper.getLocalizedText(step3Settings.getPersonalDataRules()));
        result.setDisplaySecurityRules(!step3Settings.isDisablePersonalDataRules());
        result.setDisplayDKNumber(!step3Settings.isDisableDK());
        List<PassportType> types = SiteConverterHelper.getBasePassportTypes(step3Settings);
        result.getPassengerTypeDocument().addAll(SiteConverterHelper.getPassengerTypeDocuments(types));
        return result;
    }

    public static List<PassengerTypeDocuments> getPassengerTypeDocuments(List<PassportType> types) {
        List<PassengerTypeDocuments> result = BASE_PASSENGER_TYPES.stream().map(pt -> SiteConverterHelper.convertPassengerTypeDocuments2Rest((DictionaryReference<PassengerType>)pt, types)).collect(Collectors.toList());
        result.addAll(DictHelper.getAllChildTypes().stream().map(pt -> SiteConverterHelper.convertPassengerTypeDocuments2Rest((DictionaryReference<PassengerType>)pt, types)).collect(Collectors.toList()));
        result.add(SiteConverterHelper.convertPassengerTypeDocuments2Rest((DictionaryReference<PassengerType>)DictHelper.getPromoPassengerType(), types));
        return result;
    }

    public static FourthStepSettings convertFourthStepSettings2Rest(SMStep4Settings step4Settings) {
        FourthStepSettings result = new FourthStepSettings();
        result.getCashSalesOfficesDetails().addAll(step4Settings.getCashSalesOfficesDetails().stream().map(SiteConverterHelper::convertSalesOfficeDetails2Rest).collect(Collectors.toList()));
        result.setDeliveryInputEnabled(step4Settings.isDeliveryInputEnabled());
        return result;
    }

    public static PassengerTypeDocuments convertPassengerTypeDocuments2Rest(DictionaryReference<PassengerType> passengerType, List<PassportType> types) {
        PassengerTypeDocuments result = new PassengerTypeDocuments();
        result.setPassengerType(passengerType);
        result.getPassportTypes().addAll(types);
        if (!DictHelper.isAdultPassengerTypeCategory(passengerType)) {
            result.getPassportTypes().remove(PassportType.INTERNAL);
            result.getPassportTypes().remove(PassportType.MILITARYCERTIFICATE);
            result.getPassportTypes().remove(PassportType.MILITARYID);
            result.getPassportTypes().remove(PassportType.SEAMANSID);
        }
        return result;
    }

    private static List<PassportType> getBasePassportTypes(SMStep3Settings step3Settings) {
        return step3Settings.getAllowedDocuments();
    }
}

