/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TextPatternHelperEngine {
    private static final Pattern AGENCY_FULL_NAME = Pattern.compile("\\$\\{agencyFullName\\}");
    private static final Pattern AGENCY_SHORT_NAME = Pattern.compile("\\$\\{agencyShortName\\}");
    private static final Pattern AGENCY_PHONE = Pattern.compile("\\$\\{agencyPhone\\}");
    private static final Pattern CLIENT_CODE = Pattern.compile("\\$\\{clientCode\\}");
    private static final Pattern COMPANY_EMAIL = Pattern.compile("\\$\\{companyEmail\\}");
    private static final Pattern CONTACT_PHONE = Pattern.compile("\\$\\{contactPhone\\}");
    private static final Pattern CONTACT_EMAIL = Pattern.compile("\\$\\{contactEmail\\}");
    private static final Pattern CUSTOMER = Pattern.compile("\\$\\{customer\\}");
    private static final Pattern DEPARTURE_DATE = Pattern.compile("\\$\\{departureDate\\}");
    private static final Pattern PNR = Pattern.compile("\\$\\{pnr\\}");
    private static final Pattern ROUTE = Pattern.compile("\\$\\{route\\}");
    private static final Pattern TIME_LIMIT_DATE = Pattern.compile("\\$\\{timeLimitDate\\}");
    private static final Pattern TIME_LIMIT_TIME = Pattern.compile("\\$\\{timeLimitTime\\}");
    private final Map<Pattern, PatternAction> actions;

    public TextPatternHelperEngine(SalesContext salesContext) {
        this(salesContext, null);
    }

    public TextPatternHelperEngine(SalesContext salesContext, Reservation reservation) {
        Organization agency = (Organization)EntityStorage.get().resolve(salesContext.getSubagency()).getEntity();
        EntityContainer clientCtr = EntityStorage.get().resolve(salesContext.getClient());
        this.actions = new LinkedHashMap<Pattern, PatternAction>();
        this.actions.put(AGENCY_FULL_NAME, textWithPattern -> AGENCY_FULL_NAME.matcher(textWithPattern).replaceAll(agency.getFullName().toString()));
        this.actions.put(AGENCY_SHORT_NAME, textWithPattern -> AGENCY_SHORT_NAME.matcher(textWithPattern).replaceAll(agency.getShortName().toString()));
        this.actions.put(AGENCY_PHONE, textWithPattern -> {
            List phones = agency.getCommunications().stream().filter(com -> CommunicationType.WORK_PHONE.equals((Object)com.getType()) || CommunicationType.AGENCY.equals((Object)com.getType())).map(ProfileHelper::buildFullPhoneNumber).collect(Collectors.toCollection(LinkedList::new));
            return AGENCY_PHONE.matcher(textWithPattern).replaceAll(phones.size() > 0 ? CollectionUtil.collectionToString((Iterable)phones, (String)"; ", (boolean)false) : "");
        });
        if (clientCtr != null) {
            this.actions.put(CLIENT_CODE, textWithPattern -> CLIENT_CODE.matcher(textWithPattern).replaceAll(((Organization)clientCtr.getEntity()).getCode()));
        }
        this.actions.put(COMPANY_EMAIL, textWithPattern -> {
            String email = "";
            for (Communication com : agency.getCommunications()) {
                if (!CommunicationType.EMAIL.equals((Object)com.getType())) continue;
                email = com.getSense();
                break;
            }
            return COMPANY_EMAIL.matcher(textWithPattern).replaceAll(email);
        });
        this.actions.put(CONTACT_PHONE, textWithPattern -> {
            String phone = "";
            if (reservation != null) {
                block3: for (Communication comm : reservation.getBookingFile().getCustomer().getCommunications()) {
                    switch (comm.getType()) {
                        case CELL: 
                        case MOBILE: 
                        case HOME_PHONE: 
                        case WORK_PHONE: {
                            phone = CommonHelper.buildPhoneNumber(comm);
                            break block3;
                        }
                        default: {
                            continue block3;
                        }
                    }
                }
            }
            return CONTACT_PHONE.matcher(textWithPattern).replaceAll(phone);
        });
        this.actions.put(CONTACT_EMAIL, textWithPattern -> {
            String email = "";
            if (reservation != null) {
                block3: for (Communication comm : reservation.getBookingFile().getCustomer().getCommunications()) {
                    switch (comm.getType()) {
                        case EMAIL: {
                            email = comm.getSense();
                            break block3;
                        }
                        default: {
                            continue block3;
                        }
                    }
                }
            }
            return CONTACT_EMAIL.matcher(textWithPattern).replaceAll(email);
        });
        this.actions.put(CUSTOMER, textWithPattern -> {
            String customer = "";
            if (reservation != null) {
                customer = TextUtil.buildFullName((PersonalName)reservation.getBookingFile().getCustomer().getPassport());
            }
            return CUSTOMER.matcher(textWithPattern).replaceAll(customer);
        });
        this.actions.put(PNR, textWithPattern -> {
            String pnr = "";
            if (reservation != null) {
                pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
            }
            return PNR.matcher(textWithPattern).replaceAll(pnr);
        });
        this.actions.put(ROUTE, textWithPattern -> {
            String route = "";
            if (reservation != null) {
                for (BaseProduct bp : reservation.getProducts()) {
                    if (!(bp instanceof Product)) continue;
                    Product prod = (Product)bp;
                    StringBuilder sbRoute = new StringBuilder();
                    LinkedList segs = AirProductHelper.getProductSegmentsStream((Product)prod).collect(Collectors.toCollection(LinkedList::new));
                    for (int i = 0; i < segs.size(); ++i) {
                        Segment s = (Segment)segs.get(i);
                        if (!s.isStarting()) {
                            sbRoute.append(" - ").append(TextPatternHelperEngine.getLocationCode((DictionaryReference<GeoLocation>)s.getArriveLocation()));
                            continue;
                        }
                        if (i != 0) {
                            sbRoute.append(", ");
                        }
                        sbRoute.append(TextPatternHelperEngine.getLocationCode((DictionaryReference<GeoLocation>)s.getDepartureLocation())).append(" - ").append(TextPatternHelperEngine.getLocationCode((DictionaryReference<GeoLocation>)s.getArriveLocation()));
                    }
                    route = sbRoute.toString();
                    break;
                }
            }
            return ROUTE.matcher(textWithPattern).replaceAll(route);
        });
        this.actions.put(DEPARTURE_DATE, textWithPattern -> {
            String departureDate = "";
            if (reservation != null) {
                for (BaseProduct bp : reservation.getProducts()) {
                    if (!(bp instanceof Product)) continue;
                    Product prod = (Product)bp;
                    LinkedList segs = AirProductHelper.getProductSegmentsStream((Product)prod).collect(Collectors.toCollection(LinkedList::new));
                    Date departure = null;
                    if (!segs.isEmpty()) {
                        departure = ((Segment)segs.get(0)).getStartDate();
                    }
                    departureDate = new SimpleDateFormat("dd.MM.yyyy", LocaleHelper.getCurrentLocale()).format(departure);
                    break;
                }
            }
            return DEPARTURE_DATE.matcher(textWithPattern).replaceAll(departureDate);
        });
        this.actions.put(TIME_LIMIT_DATE, textWithPattern -> {
            String timeLimitDate = "";
            if (reservation != null) {
                timeLimitDate = new SimpleDateFormat("EEEE, dd MMMM yyyy", LocaleHelper.getCurrentLocale()).format(reservation.getTimeLimit());
            }
            return TIME_LIMIT_DATE.matcher(textWithPattern).replaceAll(timeLimitDate);
        });
        this.actions.put(TIME_LIMIT_TIME, textWithPattern -> {
            String timeLimitTime = "";
            if (reservation != null) {
                timeLimitTime = new SimpleDateFormat("HH:mm", LocaleHelper.getCurrentLocale()).format(reservation.getTimeLimit());
            }
            return TIME_LIMIT_TIME.matcher(textWithPattern).replaceAll(timeLimitTime);
        });
    }

    private static String getLocationCode(DictionaryReference<GeoLocation> locRef) {
        GeoLocation loc = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(locRef);
        String code = (String)loc.getCodeVariants().get("IATA");
        if (TextUtil.isBlank((String)code)) {
            code = (String)loc.getCodeVariants().get("CRT");
        }
        return code;
    }

    public final String replacePatterns(String textWithPatterns) {
        if (TextUtil.isBlank((String)textWithPatterns)) {
            return "";
        }
        String result = textWithPatterns;
        for (Map.Entry<Pattern, PatternAction> e : this.actions.entrySet()) {
            if (!e.getKey().matcher(result).find()) continue;
            result = e.getValue().apply(result);
        }
        return result.replaceAll("contenteditable=\"true\"", "");
    }

    private static interface PatternAction {
        public String apply(String var1);
    }
}

