/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.authorization;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.SalesPointType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersProperties;
import com.gridnine.xtrip.server.ibecorp.assets.SiteUserPreferences;
import com.gridnine.xtrip.server.ibecorp.b2b.primeconcept.model.avia.B2BPrimeConceptClientType;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.model.helpers.ProfileHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public class AuthorizationHelper {
    public static final String AUTH_DATA_KEY = "AUTH_DATA";
    public static final String RETAIN_REQUEST_TOKEN_KEY = "RETAIN_REQUEST_TOKEN";
    public static final Predicate<PersonType> VALID_B2B_TYPES_CRITERION = type -> type == PersonType.AGENT || type == PersonType.PASSENGER || type == PersonType.WEB_AGENT;
    private static final Predicate<PersonType> VALID_B2C_TYPES_CRITERION = type -> type == PersonType.PASSENGER;

    private AuthorizationHelper() {
    }

    public static EntityContainer<Person> findProfileByLogin(String login) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)login));
        SearchResult searchResult = EntityStorage.get().search(PersonIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        if (searchResult.getData().size() != 1) {
            throw Xeption.forAdmin((String)String.format("Can't find passenger profile for %s, result count is %d.", login, searchResult.getData().size()), (Object[])new Object[0]);
        }
        return EntityStorage.get().resolve(((PersonIndex)searchResult.getData().get(0)).getSource());
    }

    public static boolean isValidB2BPersonTypes(Person person) {
        return person.getTypes().stream().anyMatch(VALID_B2B_TYPES_CRITERION);
    }

    public static boolean isDisabledB2BPerson(Person authUser, EntityReference<Organization> currentOrg) {
        Date closed = authUser.getEmployments().stream().filter(emp -> emp.getOrganization().equals((Object)currentOrg)).findFirst().get().getClosed();
        return closed != null && closed.before(new Date());
    }

    public static boolean isValidB2CPersonTypes(Person person) {
        return person.getTypes().stream().filter(VALID_B2C_TYPES_CRITERION).count() == 1L;
    }

    public static SalesContext getB2BSalesContextForAgent(EntityReference<Person> agentRef, EntityReference<SMSite> siteRef) throws Exception {
        EntityReference<Organization> subagencyRef = AuthorizationHelper.findB2BSubagency(agentRef);
        EntityReference<Organization> mainAgencyRef = AuthorizationHelper.checkB2BSiteForSubagencyAndGetMainAgency(subagencyRef, siteRef);
        SalesContext result = new SalesContext();
        result.setAgent(agentRef);
        result.setSubagency(subagencyRef);
        result.setSite(siteRef);
        result.setAgency(mainAgencyRef != null ? mainAgencyRef : AuthorizationHelper.getMainAgency(result));
        result.setTechnicalProvider(ProfileHelper.findTechnicalProviderProfile());
        return result;
    }

    private static EntityReference<Organization> getB2BClientforPrimeConcept(B2BPrimeConceptClientType clientType) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)clientType.name()));
        List organizationIndices = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (organizationIndices.size() != 1) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0434\u0435\u0444\u043e\u043b\u0442\u043d\u044b\u0439 \u043a\u043b\u0438\u0435\u043d\u0442 \u0434\u043b\u044f \u0442\u0438\u043f\u0430 {0}.", (Object[])new Object[]{clientType.name()});
        }
        return ((OrganizationIndex)organizationIndices.get(0)).getSource();
    }

    private static EntityReference<Person> getDefaultEmplForPrimeConcept(EntityReference<Organization> clientRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)clientRef.getUid()));
        EntityContainer client = EntityStorage.get().resolve(clientRef);
        if (client != null && client.getEntity() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.code.name(), (Object)(((Organization)client.getEntity()).getCode() + "_Empl")));
            List personIndices = EntityStorage.get().search(PersonIndex.class, query).getData();
            if (personIndices.size() != 1) {
                throw Xeption.forAdmin((String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0438\u0441\u043a\u0435 \u0434\u0435\u0444\u043e\u043b\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0444\u0438\u043b\u044f \u0430\u0433\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 {0}.", (Object[])new Object[]{clientRef});
            }
            return ((PersonIndex)personIndices.get(0)).getSource();
        }
        throw Xeption.forAdmin((String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0438\u0441\u043a\u0435 \u0434\u0435\u0444\u043e\u043b\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0444\u0438\u043b\u044f \u0430\u0433\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 {0}.", (Object[])new Object[]{clientRef});
    }

    public static SalesContext getB2BSalesContextForPrimeConcept(B2BPrimeConceptClientType clientType, EntityReference<SMSite> siteRef) {
        EntityReference<Organization> clientRef = AuthorizationHelper.getB2BClientforPrimeConcept(clientType);
        EntityReference<Organization> mainAgencyRef = CommonHelper.findMainAgency();
        if (mainAgencyRef == null) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e.", (Object[])new Object[0]);
        }
        AuthorizationHelper.checkPrimeConceptSiteForClient(clientRef, mainAgencyRef, siteRef);
        EntityReference<SalesPoint> salesPointRef = AuthorizationHelper.findDefaultWebSalesPoint(mainAgencyRef);
        if (salesPointRef == null) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0434\u0435\u0444\u043e\u043b\u0442\u043d\u0430\u044f WEB \u0442\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436 \u0434\u043b\u044f \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 {0}.", (Object[])new Object[]{mainAgencyRef});
        }
        EntityReference<Person> defaultEmployeeRef = AuthorizationHelper.getDefaultEmplForPrimeConcept(clientRef);
        SalesContext result = new SalesContext();
        result.setAgent(defaultEmployeeRef);
        result.setClient(clientRef);
        result.setAgency(mainAgencyRef);
        result.setSubagency(mainAgencyRef);
        result.setSalesPoint(salesPointRef);
        result.setSite(siteRef);
        return result;
    }

    private static void checkPrimeConceptSiteForClient(EntityReference<Organization> clientRef, EntityReference<Organization> subagencyRef, EntityReference<SMSite> siteRef) {
        EntityContainer clientContainer = EntityStorage.get().resolve(clientRef);
        EntityContainer siteContainer = EntityStorage.get().resolve(siteRef);
        EntityContainer subagencyContainer = EntityStorage.get().resolve(subagencyRef);
        if (siteContainer != null && siteContainer.getEntity() != null) {
            Organization subAgency;
            Organization client;
            SMSite site = (SMSite)siteContainer.getEntity();
            if (site.getSiteType() == null || site.getSiteType() != SMSiteType.B2B) {
                throw Xeption.forAdmin((String)"\u0422\u0438\u043f \u0441\u0430\u0439\u0442\u0430 {0} \u043e\u0442\u043b\u0438\u0447\u0435\u043d \u043e\u0442 B2B.", (Object[])new Object[]{siteRef});
            }
            if (!(clientContainer == null || clientContainer.getEntity() == null || (client = (Organization)clientContainer.getEntity()).getB2bSite() != null && client.getB2bSite().equals(siteRef) || subagencyContainer == null || subagencyContainer.getEntity() == null || (subAgency = (Organization)subagencyContainer.getEntity()).getB2bSite() != null && subAgency.getB2bSite().equals(siteRef))) {
                throw Xeption.forAdmin((String)"\u0421\u0430\u0439\u0442 {0} \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043d\u0438 \u043a \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c\u0443 \u043a\u043b\u0438\u0435\u043d\u0442\u0443 {1}, \u043d\u0438 \u043a \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0443-\u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044e {2}", (Object[])new Object[]{siteRef, clientRef, subagencyRef});
            }
        }
    }

    public static SalesContext getB2BSalesContextForCorporant(EntityReference<Person> corporantEmplRef, EntityReference<SMSite> siteRef) throws Exception {
        EntityReference<Organization> clientRef = AuthorizationHelper.findB2BCorporateClientForCorporant(corporantEmplRef);
        EntityReference<Organization> subagencyRef = AuthorizationHelper.findB2BSubagencyForCorporateClient(clientRef);
        if (subagencyRef == null) {
            throw Xeption.forAdmin((String)"\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0434\u043b\u044f \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u043d\u0442\u0430 {0} \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d.", (Object[])new Object[]{corporantEmplRef.getCaption()});
        }
        EntityReference<Organization> mainAgencyRef = AuthorizationHelper.checkSiteForClientAndGetMainAgency(clientRef, subagencyRef, siteRef);
        SalesContext result = new SalesContext();
        result.setAgent(corporantEmplRef);
        result.setSubagency(subagencyRef);
        result.setClient(clientRef);
        result.setSite(siteRef);
        result.setAgency(mainAgencyRef != null ? mainAgencyRef : AuthorizationHelper.getMainAgency(result));
        return result;
    }

    private static EntityReference<Organization> findMainAgencyFromGdsAccount(SalesContext salesContext) throws Exception {
        RuleSet rules = CommonIbecorpHelper.getRules((EntityReference)salesContext.getSite());
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(Targets.GDS_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setActionSet((Object)new GDSParametersActions());
        proxy.setPropertySet((Object)new GDSParametersProperties(salesContext, proxy));
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        EntityReference gdsAccountRef = AuthorizationHelper.searchGdsAccount(((GDSParametersActions)proxy.getActionSet()).getApplicableGdsAccounts());
        if (gdsAccountRef == null) {
            RuleProxy railProxy = new RuleProxy();
            railProxy.setProxyType(RzdTargets.RZD_PARAMETERS.getId());
            railProxy.setProxyDate(new Date());
            railProxy.setActionSet((Object)new RzdParametersActions());
            RuleEngine.applyRules(Collections.singletonList(railProxy), (RuleSet)rules);
            gdsAccountRef = AuthorizationHelper.searchGdsAccount(((RzdParametersActions)railProxy.getActionSet()).getApplicableGdsAccounts());
        }
        return gdsAccountRef != null ? ((BaseGdsAccount)EntityStorage.get().resolve(gdsAccountRef).getEntity()).getAgency() : null;
    }

    private static <T extends BaseGdsAccount> EntityReference<T> searchGdsAccount(Set<EntityReference<T>> gdsAccountRefs) {
        return gdsAccountRefs.stream().filter(gdsAccount -> {
            EntityContainer gdsAccountCtr = EntityStorage.get().resolve(gdsAccount);
            return gdsAccountCtr != null && ((BaseGdsAccount)gdsAccountCtr.getEntity()).getAgency() != null;
        }).findFirst().orElse(null);
    }

    public static SalesContext getB2CSalesContextForAuthorizedPassenger(EntityReference<SMSite> siteRef, EntityReference<Person> passengerRef) {
        SalesContext result = AuthorizationHelper.getB2CSalesContextForPassenger(siteRef);
        result.setCustomer(passengerRef);
        return result;
    }

    public static SalesContext getB2CSalesContextForPassenger(EntityReference<SMSite> siteRef) {
        EntityReference<Organization> subagencyRef = AuthorizationHelper.findB2CSubagency(siteRef);
        EntityReference<Person> webAgent = AuthorizationHelper.findWebAgentForSubagency(subagencyRef);
        EntityReference<Organization> clientRef = AuthorizationHelper.findB2CRetailProfile(subagencyRef);
        EntityReference<Organization> mainAgencyRef = CommonHelper.findMainAgency();
        if (mainAgencyRef == null) {
            mainAgencyRef = subagencyRef;
        }
        SalesContext result = new SalesContext();
        result.setAgency(mainAgencyRef);
        result.setSubagency(subagencyRef);
        result.setAgent(webAgent);
        result.setClient(clientRef);
        result.setSalesPoint(AuthorizationHelper.findB2CSalesPoint(subagencyRef));
        result.setSite(siteRef);
        return result;
    }

    private static EntityReference<SalesPoint> findB2CSalesPoint(EntityReference<Organization> agencyRef) {
        EntityReference spRef = ((Organization)EntityStorage.get().resolve(agencyRef).getEntity()).getB2cSalesPoint();
        AuthorizationHelper.checkSalesPoint(agencyRef, (EntityReference<SalesPoint>)spRef);
        return spRef;
    }

    private static EntityReference<Organization> findB2CRetailProfile(EntityReference<Organization> agencyRef) {
        EntityReference b2cRetailProfileRef = ((Organization)EntityStorage.get().resolve(agencyRef).getEntity()).getB2cRetailProfile();
        if (EntityStorage.get().resolve(b2cRetailProfileRef) != null) {
            return b2cRetailProfileRef;
        }
        return AuthorizationHelper.findDefaultRetailProfile();
    }

    private static EntityReference<Person> findWebAgentForSubagency(EntityReference<Organization> agencyRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)agencyRef.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.WEB_AGENT.name()));
        List data = EntityStorage.get().search(PersonIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        if (data.isEmpty()) {
            throw new IllegalStateException(String.format("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u0435\u0431-\u0430\u0433\u0435\u043d\u0442\u0430, \u0434\u043b\u044f \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 [%s]", agencyRef));
        }
        return ((PersonIndex)data.get(0)).getSource();
    }

    private static EntityReference<Organization> findB2CSubagency(EntityReference<SMSite> siteRef) throws IllegalStateException {
        EntityContainer subagencyCtr = EntityStorage.get().resolve(AuthorizationHelper.getB2cAgency(siteRef));
        AuthorizationHelper.checkSubagency((EntityContainer<Organization>)subagencyCtr);
        return subagencyCtr.toReference();
    }

    private static EntityReference<Organization> getB2cAgency(EntityReference<SMSite> site) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.b2cSite.name(), site));
        List indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (indexes.size() > 1) {
            throw Xeption.forAdmin((String)"more than one agency found for B2C site {0}.", (Object[])new Object[]{site});
        }
        if (indexes.isEmpty()) {
            throw Xeption.forAdmin((String)"no agency found for B2C site {0}.", (Object[])new Object[]{site});
        }
        return ((OrganizationIndex)indexes.get(0)).getSource();
    }

    private static EntityReference<Organization> findB2BSubagency(EntityReference<Person> agentRef) {
        EntityReference<Organization> subagencyRef = AuthorizationHelper.findEmploymentForPerson(agentRef);
        if (subagencyRef == null) {
            throw Xeption.forAdmin((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0430\u0433\u0435\u043d\u0442 [%s].", (Object[])new Object[]{agentRef});
        }
        EntityContainer subagencyCtr = EntityStorage.get().resolve(subagencyRef);
        AuthorizationHelper.checkSubagency((EntityContainer<Organization>)subagencyCtr);
        return subagencyRef;
    }

    private static EntityReference<Organization> findB2BSubagencyForCorporateClient(EntityReference<Organization> corporateClientRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().addAll(Arrays.asList(SearchCriterion.eq((String)ContractIndex.Property.disabled.name(), (Object)false), SearchCriterion.eq((String)ContractIndex.Property.customer.name(), corporateClientRef), SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.CLIENT)));
        List searchResult = EntityStorage.get().search(ContractIndex.class, query).getData();
        return searchResult.stream().filter(c -> MiscUtil.isBetween((Date)c.getStartDate(), (Date)c.getEndDate(), (Date)new Date())).map(ContractIndex::getSupplier).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static EntityReference<Organization> checkB2BSiteForSubagencyAndGetMainAgency(EntityReference<Organization> subagencyRef, EntityReference<SMSite> siteRef) {
        EntityReference<Organization> res;
        EntityContainer subagencyContainer = EntityStorage.get().resolve(subagencyRef);
        EntityReference b2bSite = ((Organization)subagencyContainer.getEntity()).getB2bSite();
        if (siteRef.equals((Object)b2bSite)) {
            return null;
        }
        if (b2bSite == null && (res = AuthorizationHelper.getMainAgencyFromContract(subagencyRef, siteRef)) != null) {
            return res;
        }
        throw Xeption.forAdmin((String)"\u0441\u0430\u0439\u0442 {0} \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043a \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0443 {1}.", (Object[])new Object[]{siteRef, subagencyRef});
    }

    private static EntityReference<Organization> getMainAgencyFromContract(EntityReference<Organization> subagencyRef, EntityReference<SMSite> siteRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().addAll(Arrays.asList(SearchCriterion.eq((String)ContractIndex.Property.disabled.name(), (Object)false), SearchCriterion.eq((String)ContractIndex.Property.customer.name(), subagencyRef), SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.SUBAGENCY)));
        List searchResult = EntityStorage.get().search(ContractIndex.class, query).getData();
        return searchResult.stream().filter(c -> MiscUtil.isBetween((Date)c.getStartDate(), (Date)c.getEndDate(), (Date)new Date())).map(ContractIndex::getSupplier).filter(Objects::nonNull).filter(supplier -> {
            EntityContainer mainAgencyCtr = EntityStorage.get().resolve(supplier);
            Organization mainAgency = (Organization)mainAgencyCtr.getEntity();
            return siteRef.equals((Object)mainAgency.getB2bSite());
        }).findFirst().orElse(null);
    }

    private static EntityReference<Organization> getMainAgency(SalesContext salesCtx) throws Exception {
        EntityReference<Organization> mainAgency = CommonHelper.findMainAgency();
        if (mainAgency == null) {
            mainAgency = AuthorizationHelper.findMainAgencyFromGdsAccount(salesCtx);
        }
        return mainAgency;
    }

    private static EntityReference<Organization> findEmploymentForPerson(EntityReference<Person> personRef) {
        PersonEmployment employment;
        EntityContainer personCtr = EntityStorage.get().resolve(personRef);
        List<PersonEmployment> employments = AuthorizationHelper.getValidEmployments((Person)personCtr.getEntity());
        if (employments.size() > 1) {
            return AuthorizationHelper.findSelectedEmployment(((Person)personCtr.getEntity()).getLoginName());
        }
        if (employments.size() == 1 && (employment = employments.get(0)).isMainEmployment()) {
            return employment.getOrganization();
        }
        return null;
    }

    public static EntityReference<Organization> findSelectedEmployment(String loginName) {
        SiteUserPreferences preferences = (SiteUserPreferences)AssetsStorage.get().find(SiteUserPreferences.class, "loginName", (Object)loginName);
        if (preferences == null) {
            throw Xeption.forDeveloper((String)String.format("Site preferences for loginName %s are not found", loginName), (Object[])new Object[0]);
        }
        return preferences.getOrganizationReference();
    }

    public static List<PersonEmployment> getValidEmployments(Person person) {
        Date currentDate = new Date();
        return person.getEmployments().stream().filter(pe -> pe.getOrganization() != null).filter(pe -> MiscUtil.isBetween((Date)pe.getOpened(), (Date)pe.getClosed(), (Date)currentDate)).collect(Collectors.toList());
    }

    private static void checkSubagency(EntityContainer<Organization> subagencyCtr) {
        if (subagencyCtr == null) {
            throw Xeption.forAdmin((String)"\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e [%s].", (Object[])new Object[0]);
        }
        if (!((Organization)subagencyCtr.getEntity()).getTypes().contains(OrganizationType.AGENCY)) {
            throw Xeption.forEndUser((String)String.format("\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e [%s] \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0440\u043e\u043b\u0438 [%s].", subagencyCtr, OrganizationType.AGENCY), (Object[])new Object[0]);
        }
    }

    private static void checkSalesPoint(EntityReference<Organization> agencyRef, EntityReference<SalesPoint> spRef) {
        if (spRef == null) {
            throw Xeption.forAdmin((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 WEB \u0442\u043e\u0447\u043a\u0443 \u043f\u0440\u043e\u0434\u0430\u0436 \u0434\u043b\u044f \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 {0}.", (Object[])new Object[]{agencyRef});
        }
        EntityContainer spCtr = EntityStorage.get().resolve(spRef);
        if (spCtr == null) {
            throw Xeption.forAdmin((String)String.format("sales point '%s' from sales context was not resolved.", spRef), (Object[])new Object[0]);
        }
        if (!MiscUtil.equals(agencyRef, (Object)((SalesPoint)spCtr.getEntity()).getAgency())) {
            throw Xeption.forAdmin((String)String.format("\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436 '[%s]' \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0443 '[%s]'.", agencyRef, ((SalesPoint)spCtr.getEntity()).getAgency()), (Object[])new Object[0]);
        }
    }

    private static EntityReference<Organization> findDefaultRetailProfile() {
        EntityReference clientRef = AuthorizationHelper.findProfileReferenceByCode(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE, null), OrganizationIndex.class);
        if (clientRef == null) {
            throw Xeption.forAdmin((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0440\u043e\u0437\u043d\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u043f\u0440\u043e\u0434\u0430\u0436.", (Object[])new Object[0]);
        }
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (clientCtr == null) {
            throw Xeption.forAdmin((String)String.format("client retail profile '%s' from sales context was not resolved", clientRef), (Object[])new Object[0]);
        }
        return clientRef;
    }

    private static EntityReference<Organization> findB2BCorporateClientForCorporant(EntityReference<Person> corporantEmployeeRef) {
        EntityReference<Organization> corporateClientRef = AuthorizationHelper.findEmploymentForPerson(corporantEmployeeRef);
        if (corporateClientRef == null) {
            throw Xeption.forAdmin((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0430.", (Object[])new Object[0]);
        }
        Organization corporateClient = (Organization)EntityStorage.get().resolve(corporateClientRef).getEntity();
        if (!corporateClient.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            throw Xeption.forAdmin((String)String.format("\u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b [%s] \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430 [%s] \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u043c \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c", corporateClientRef, corporantEmployeeRef), (Object[])new Object[0]);
        }
        return corporateClientRef;
    }

    private static EntityReference<SalesPoint> findDefaultWebSalesPoint(EntityReference<Organization> subagency) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.agency.name(), subagency));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.type.name(), (Object)SalesPointType.WEB_SITE));
        List data = EntityStorage.get().search(SalesPointIndex.class, query).getData();
        if (data.isEmpty()) {
            return null;
        }
        if (data.size() > 1) {
            throw Xeption.forAdmin((String)"\u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e WEB-\u0442\u043e\u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436 \u0434\u043b\u044f \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 {0}.", (Object[])new Object[]{subagency});
        }
        return ((SalesPointIndex)data.get(0)).getSource();
    }

    private static <E extends BaseProfile, I extends EntityIndex<E>> EntityReference<E> findProfileReferenceByCode(String code, Class<I> cls) {
        List<EntityReference<E>> result = AuthorizationHelper.getProfileReferencesByCode(code, cls);
        return result.size() != 1 ? null : result.get(0);
    }

    private static <E extends BaseProfile, I extends EntityIndex<E>> List<EntityReference<E>> getProfileReferencesByCode(String code, Class<I> cls) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"code", (Object)code));
        query.getPreferredProperties().add("code");
        SearchResult searchResult = EntityStorage.get().search(cls, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        ArrayList<EntityReference<E>> result = new ArrayList<EntityReference<E>>(searchResult.getData().size());
        searchResult.getData().stream().map(EntityIndex::getSource).forEach(result::add);
        return result;
    }

    public static boolean isCorporantAuthorized(Person user) {
        Set personTypes = user.getTypes().stream().filter(VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet());
        if (personTypes.size() == 1) {
            return user.getTypes().contains(PersonType.PASSENGER);
        }
        SiteUserPreferences preferences = (SiteUserPreferences)AssetsStorage.get().find(SiteUserPreferences.class, "loginName", (Object)user.getLoginName());
        if (preferences == null) {
            throw Xeption.forDeveloper((String)String.format("Site preferences for loginName %s are not found", user.getLoginName()), (Object[])new Object[0]);
        }
        return preferences.getPersonType() == PersonType.PASSENGER;
    }

    public static boolean isCorporantAuthorized(EntityReference<Person> userRef) {
        if (userRef == null) {
            return true;
        }
        return AuthorizationHelper.isCorporantAuthorized((Person)EntityStorage.get().resolve(userRef).getEntity());
    }

    @Deprecated
    public static boolean isCorporantAuthorizedOld(Person person) {
        return person.getTypes().contains(PersonType.PASSENGER) && !person.getTypes().contains(PersonType.AGENT);
    }

    private static EntityReference<Organization> checkSiteForClientAndGetMainAgency(EntityReference<Organization> clientRef, EntityReference<Organization> subagencyRef, EntityReference<SMSite> siteRef) {
        EntityContainer clientContainer = EntityStorage.get().resolve(clientRef);
        EntityContainer siteContainer = EntityStorage.get().resolve(siteRef);
        EntityContainer subagencyContainer = EntityStorage.get().resolve(subagencyRef);
        if (siteContainer != null && siteContainer.getEntity() != null) {
            Organization subAgency;
            Organization client;
            SMSite site = (SMSite)siteContainer.getEntity();
            if (site.getSiteType() == null || site.getSiteType() != SMSiteType.B2B) {
                throw Xeption.forAdmin((String)"\u0422\u0438\u043f \u0441\u0430\u0439\u0442\u0430 {0} \u043e\u0442\u043b\u0438\u0447\u0435\u043d \u043e\u0442 B2B.", (Object[])new Object[]{siteRef});
            }
            if (!(clientContainer == null || clientContainer.getEntity() == null || (client = (Organization)clientContainer.getEntity()).getB2bSite() != null && siteRef.equals((Object)client.getB2bSite()) || subagencyContainer == null || subagencyContainer.getEntity() == null || siteRef.equals((Object)(subAgency = (Organization)subagencyContainer.getEntity()).getB2bSite()) || subAgency.getB2bSite() != null)) {
                EntityReference<Organization> mainAgencyRef = AuthorizationHelper.getMainAgencyFromContract(subagencyRef, siteRef);
                if (mainAgencyRef != null) {
                    return mainAgencyRef;
                }
                throw Xeption.forAdmin((String)"\u0421\u0430\u0439\u0442 {0} \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043d\u0438 \u043a \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c\u0443 \u043a\u043b\u0438\u0435\u043d\u0442\u0443 {1}, \u043d\u0438 \u043a \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0443-\u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044e {2}", (Object[])new Object[]{siteRef, clientRef, subagencyRef});
            }
        }
        return null;
    }

    public static String[] decodeAuthorizationData(String authorization) {
        String decoded;
        int separator;
        String basic;
        StringTokenizer st = new StringTokenizer(authorization);
        if (st.hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (separator = (decoded = new String(Base64.decodeBase64((byte[])st.nextToken().getBytes()))).indexOf(":")) != -1) {
            String username = decoded.substring(0, separator);
            String password = decoded.substring(separator + 1);
            return new String[]{username, password};
        }
        return null;
    }
}

