/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.authorization;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class BookingFilePermissionProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer bookingFileEntityContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        this.checkPermissions(salesContext, (EntityContainer<BookingFile>)bookingFileEntityContainer);
    }

    private void checkPermissions(SalesContext salesContext, EntityContainer<BookingFile> bookingFileEntityContainer) {
        boolean isValid;
        BookingFile bookingFile = (BookingFile)bookingFileEntityContainer.getEntity();
        Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
        boolean bl = isValid = this.isValidBookingFile(salesContext, bookingFile) && this.isValidReservation(salesContext, reservation);
        if (!isValid) {
            throw Xeption.forEndUser((String)String.format("Invalid permissions for booking file [%s]", bookingFile), (Object[])new Object[0]);
        }
    }

    private boolean isValidReservation(SalesContext salesContext, Reservation reservation) {
        return reservation.getSubagency().equals((Object)salesContext.getSubagency()) && (reservation.getSalesPoint() == null || salesContext.getSalesPoint() == null || reservation.getSalesPoint().equals((Object)salesContext.getSalesPoint())) && reservation.getBookingAgent().equals((Object)salesContext.getAgent());
    }

    private boolean isValidBookingFile(SalesContext salesContext, BookingFile bookingFile) {
        return bookingFile.getSite().equals((Object)salesContext.getSite()) && bookingFile.getAgency().equals((Object)salesContext.getAgency()) && bookingFile.getCustomerProfile().equals((Object)salesContext.getClient());
    }
}

