/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.authorization.login;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.auth.AuthHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.AuthorizationValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public abstract class LoginProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LoginParameters parameters = (LoginParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        try {
            this.authorize(parameters);
            EntityContainer<Person> authorizedUser = null;
            try {
                EntityContainer<Person> loggedProfile = AuthorizationHelper.findProfileByLogin(parameters.getLogin());
                if (this.isAuthenticatedUser(loggedProfile, parameters)) {
                    authorizedUser = loggedProfile;
                }
                ctx.putObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER, (Object)authorizedUser.toReference());
                AuthHelper.updateLastLoginDate((String)parameters.getLogin());
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error(String.format("Error logging in user. Cannot find profile [%s]", parameters.getLogin()));
                throw e;
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Throwable t) {
            parameters.getValidationContext().getLoginValidationMessages().add(AuthorizationValidationMessages.getInvalidLoginOrPassword());
            parameters.getValidationContext().getPasswordValidationMessages().add(AuthorizationValidationMessages.getInvalidLoginOrPassword());
            throw new ValidationException();
        }
    }

    protected void authorize(LoginParameters parameters) throws Exception {
        String password = parameters.getPassword();
        LogicalStorage.get().authorize(parameters.getLogin(), password.toCharArray());
    }

    protected abstract boolean isAuthenticatedUser(EntityContainer<Person> var1, LoginParameters var2) throws Exception;
}

