/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.authorization.recovery;

import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.AuthorizationValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class CheckRecoveryTokenProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LoginParameters parameters = (LoginParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String recoveryToken = parameters.getRecoveryToken();
        String decodeResult = DesUtil.decode((String)recoveryToken);
        String[] recoveryTokenData = decodeResult.split("\\|");
        if (System.currentTimeMillis() > Long.parseLong(recoveryTokenData[2])) {
            parameters.getValidationContext().getRecoveryTokenValidationMessages().add(AuthorizationValidationMessages.getPasswordRecoveryTokenExpired());
            throw Xeption.forEndUser((String)Messages.PasswordRecoveryTokenExpiredError, (Object[])new Object[0]);
        }
        String login = recoveryTokenData[0];
        String password = recoveryTokenData[1];
        String recoveryEmail = recoveryTokenData[3];
        try {
            LogicalStorage.get().authorize(login, Base64.decode((String)password));
        }
        catch (Throwable t) {
            throw Xeption.forEndUser((String)Messages.PasswordRecoveryTokenWithInvalidPasswordError, (Object[])new Object[0]);
        }
        parameters.setLogin(login);
        parameters.setRecoveryEmail(recoveryEmail);
    }
}

