/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.authorization.recovery;

import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginResult;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Locale;

public class SendNewPasswordProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LoginParameters parameters = (LoginParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        String domain = ((SMSite)EntityStorage.get().resolve(siteRef).getEntity()).getDomain();
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        String recoveryEmail = parameters.getRecoveryEmail();
        String password = parameters.getPassword();
        String subject = domain + ": " + L10nResourcesManager.getStr((String)Messages.PasswordRecoveryMailSubject, (Locale)currentLocale, (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(L10nResourcesManager.getStr((String)Messages.PasswordRecoveryNewPasswordMessage, (Locale)currentLocale, (Object[])new Object[]{password}));
        sb.append("\n\n");
        sb.append(L10nResourcesManager.getStr((String)Messages.PasswordRecoveryChangePasswordMessage, (Locale)currentLocale, (Object[])new Object[0]));
        String text = sb.toString();
        NotificationHelper.sendSimpleNotification((EntityReference<SMSite>)siteRef, new String[]{recoveryEmail}, subject, text, false, new MailPart[0]);
        LoginResult result = new LoginResult();
        result.setRecoveryMailSent(true);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

