/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.authorization.recovery;

import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.AuthorizationValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginResult;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public abstract class SendRecoveryTokenProcessor
extends BaseProcessor {
    private static final long validTokenTime = 10800000L;

    public void process(MessageContext ctx) throws Exception {
        LoginParameters parameters = (LoginParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        String login = parameters.getLogin();
        if (TextUtil.isBlank((String)login)) {
            parameters.getValidationContext().getLoginValidationMessages().add(AuthorizationValidationMessages.getEmptyLogin());
            throw new ValidationException();
        }
        UserAccount account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)login);
        if (account == null) {
            parameters.getValidationContext().getLoginValidationMessages().add(AuthorizationValidationMessages.getInvalidLogin());
            throw new ValidationException();
        }
        String recoveryEmail = this.getRecoveryEmail(parameters, siteType);
        String token = this.getRecoveryToken(login, Base64.encode((byte[])account.getPasswordDigest()), recoveryEmail);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        RestContext restContext = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        this.sendPasswordRecoveryTokenToMail(recoveryEmail, token, (EntityReference<SMSite>)siteRef, restContext);
        LoginResult result = new LoginResult();
        result.setRecoveryMailSent(true);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private String getRecoveryToken(String login, String passwordDigest, String recoveryEmail) throws Exception {
        long validTokenTimeLimit = System.currentTimeMillis() + 10800000L;
        String tokenData = login + "|" + passwordDigest + "|" + validTokenTimeLimit + "|" + recoveryEmail;
        return DesUtil.encode((String)tokenData);
    }

    private void sendPasswordRecoveryTokenToMail(String toAddress, String token, EntityReference<SMSite> siteRef, RestContext restContext) throws Exception {
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        String domain = ((SMSite)EntityStorage.get().resolve(siteRef).getEntity()).getDomain();
        String recoveryLink = this.getRecoveryLink(restContext, token);
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head></head><body>");
        sb.append(L10nResourcesManager.getStr((String)Messages.PasswordRecoveryLinkMessage, (Locale)currentLocale, (Object[])new Object[]{recoveryLink}));
        sb.append(L10nResourcesManager.getStr((String)Messages.PasswordRecoveryExpirationWarning, (Locale)currentLocale, (Object[])new Object[0]));
        sb.append("</body></html>");
        String text = sb.toString();
        String subject = domain + ": " + L10nResourcesManager.getStr((String)Messages.PasswordRecoveryMailSubject, (Locale)currentLocale, (Object[])new Object[0]);
        NotificationHelper.sendSimpleNotification(siteRef, new String[]{toAddress}, subject, text, true, new MailPart[0]);
    }

    private String getRecoveryLink(RestContext restContext, String token) {
        HttpServletRequest request = restContext.getRequest();
        String host = request.getHeader("host");
        String scheme = request.getHeader("X-Forwarded-Proto") != null ? request.getHeader("X-Forwarded-Proto") : request.getScheme();
        scheme = scheme != null && scheme.indexOf("https") > -1 ? "https" : "http";
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(host);
        sb.append("/?locale=");
        sb.append(LocaleManager.get().getCurrentLocale().getLanguage());
        sb.append("#authorization/recovery/");
        sb.append(token);
        return sb.toString();
    }

    protected abstract String getRecoveryEmail(LoginParameters var1, SMSiteType var2) throws Exception;
}

