/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.authorization.recovery;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.util.RandomUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.security.GeneralSecurityException;

public class UpdatePasswordProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        LoginParameters parameters = (LoginParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String login = parameters.getLogin();
        UserAccount account = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)login);
        if (account == null) {
            throw new GeneralSecurityException(String.format("user %s is absent in database", login));
        }
        if (!account.isActive()) {
            throw new GeneralSecurityException(String.format("user %s is inactive", login));
        }
        String newPassword = RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.LATIN_ALPHA_NUM, (int)10, (int)10);
        account.setPassword(newPassword.toCharArray());
        AssetsStorage.get().save((BaseAsset)account);
        parameters.setPassword(newPassword);
    }
}

