/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.QualifiedFlightNumber;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.gds.model.ScheduleFlight;
import com.gridnine.xtrip.common.gds.model.ScheduleFlightSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.model.VendorCommissionDebugItem;
import com.gridnine.xtrip.common.gds.model.VisaRequirement;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.common.PenaltiesResolver;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.McoToProductMapping;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.AviaReservation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BPassenger;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocaInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocoInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Money;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.AdditionalServicesDetails;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.AirlineWithCodeReference;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.BestFlight;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.BestFlights;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.ConnectionsRestriction;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.DictionaryItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.DocoDocaNeededInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.ExchangePenaltiesInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.ExtendedLuggage;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Flight;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.FlightItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GeoLocationType;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Leg;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.MatrixFlightWithGap;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RefundPenaltiesInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestAviaInformationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestVendorCommissionItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.ScheduleFlightItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.ScheduleFlightSegmentItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchLeg;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchMatrixFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SeatDescription;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.ServiceStatus;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.ServicesDetails;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.ServicesStatuses;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Days;
import org.joda.time.ReadablePartial;

public final class AviaConverterHelper {
    private static final List<String> PRIORITY_AIRLINE_CODE_SYSTEMS = Arrays.asList(CodeSystem.IATA.name(), CodeSystem.CRT.name());

    private AviaConverterHelper() {
    }

    public static ScheduleFlightItem convertScheduleFlight2Rest(ScheduleFlight flight) {
        ScheduleFlightItem result = new ScheduleFlightItem();
        flight.getSegments().stream().map(AviaConverterHelper::convertScheduleFlightSegment2Rest).forEach(seg -> result.getSegments().add(seg));
        return result;
    }

    public static FlightItem convertFlightSearchItem2Rest(com.gridnine.xtrip.common.gds.model.Flight flight, PriceComponentsParameters parameters, PriceDisplayStyle priceDisplayStyle, boolean displayTimeLimit, EntityReference<Organization> client, List<EntityReference<Person>> passengers, TripParameters tripParams, boolean showGdsAccountName, SMStep2Settings step2Settings, Map<String, ExchangeRateData> currencyExchangeRateDataMap) throws Exception {
        FlightItem result = AviaConverterHelper.baseConvertFlightSearchItem2Rest(flight, parameters, priceDisplayStyle, displayTimeLimit, showGdsAccountName, step2Settings, currencyExchangeRateDataMap);
        FlightDataWrapper wrapper = new FlightDataWrapper();
        wrapper.setGdsFlight(flight);
        wrapper.setClient(client);
        if (tripParams != null) {
            wrapper.setBookingFile(tripParams.getBookingFileRef());
        }
        wrapper.getPassengers().addAll(passengers);
        result.setFlightToken(B2BRestHelper.encodeToken((XSSerializable)wrapper));
        return result;
    }

    public static List<B2BPassenger> convertTravellers2Rest(Reservation reservation) {
        return CommonHelper.collectTravellers(reservation).stream().map(traveller -> AviaConverterHelper.convertTraveller2Rest(traveller, reservation)).collect(Collectors.toList());
    }

    private static B2BPassenger convertTraveller2Rest(Traveller traveller, Reservation reservation) {
        B2BPassenger passenger = new B2BPassenger();
        AviaConverterHelper.updatePassenger((Passenger)passenger, BookingHelper.findAirProductByTravellerUid((Reservation)reservation, (String)traveller.getUid(), null));
        passenger.getCostCodes().addAll(CommonConverterHelper.convertCostCodesToRest(reservation, traveller));
        return passenger;
    }

    public static FlightItem convertFlightSearchItem2Rest(com.gridnine.xtrip.common.gds.model.Flight flight, PriceComponentsParameters parameters, PriceDisplayStyle priceDisplayStyle, boolean displayTimeLimit, boolean showGdsAccountName, SMStep2Settings step2Settings) throws Exception {
        return AviaConverterHelper.convertFlightSearchItem2Rest(flight, parameters, priceDisplayStyle, displayTimeLimit, showGdsAccountName, step2Settings, Collections.emptyMap());
    }

    public static FlightItem convertFlightSearchItem2Rest(com.gridnine.xtrip.common.gds.model.Flight flight, PriceComponentsParameters parameters, PriceDisplayStyle priceDisplayStyle, boolean displayTimeLimit, boolean showGdsAccountName, SMStep2Settings step2Settings, Map<String, ExchangeRateData> currencyExchangeRateDataMap) throws Exception {
        FlightItem result = AviaConverterHelper.baseConvertFlightSearchItem2Rest(flight, parameters, priceDisplayStyle, displayTimeLimit, showGdsAccountName, step2Settings, currencyExchangeRateDataMap);
        result.setFlightToken(B2BRestHelper.encodeToken((XSSerializable)flight));
        return result;
    }

    private static FlightItem baseConvertFlightSearchItem2Rest(com.gridnine.xtrip.common.gds.model.Flight flight, PriceComponentsParameters parameters, PriceDisplayStyle priceDisplayStyle, boolean displayTimeLimit, boolean showGdsAccountName, SMStep2Settings step2Settings, Map<String, ExchangeRateData> currencyExchangeRateDataMap) {
        FlightItem result = new FlightItem();
        result.setFlight(AviaConverterHelper.convertFlight2Rest(flight, parameters, null, displayTimeLimit, showGdsAccountName));
        AviaPriceComponents priceComponents = AviaPriceComponents.builder(flight, parameters).build();
        BigDecimal total = AviaHelper.getPriceByDisplayStyle(priceDisplayStyle, priceComponents, AviaHelper.getAdultsType(flight.getSeats()));
        result.getFlight().getPrice().getTotal().setAmount(total.setScale(0, RoundingMode.HALF_DOWN));
        ExchangeRateData rateData = currencyExchangeRateDataMap.get(priceComponents.getCurrency());
        if (rateData != null) {
            BigDecimal converted = MulticurrencyHelper.convert((BigDecimal)total, (ExchangeRateData)rateData);
            result.getFlight().setSortedPrice(CommonConverterHelper.convertMoney2Rest(converted, rateData.getCurrency().getCode()));
        } else {
            result.getFlight().setSortedPrice(result.getFlight().getPrice().getTotal());
        }
        result.setExtendedFare(FlightHelper.getFlightSegmentsList((com.gridnine.xtrip.common.gds.model.Flight)flight).stream().map(AviaConverterHelper::convertBaseSegmentInfo2Rest).allMatch(segment -> AviaConverterHelper.hasExtendedFare(segment, step2Settings)));
        return result;
    }

    public static void addFlightToMatrix(com.gridnine.xtrip.common.gds.model.Flight flight, Map<String, Map<String, MatrixFlightWithGap>> to, AviaPriceComponents priceComponents, Pair<org.joda.time.LocalDate> requestedDates, PriceDisplayStyle priceDisplayStyle) {
        MatrixFlightWithGap candidate = AviaConverterHelper.convertMatrixFlight2Rest(flight, priceComponents, requestedDates, priceDisplayStyle);
        Map<String, MatrixFlightWithGap> departuresFrom = Optional.ofNullable(to.get(candidate.getDepartureTo().toString())).orElseGet(AviaConverterHelper.addMatrixDepartures(to, candidate));
        Days gapTo = Days.daysBetween((ReadablePartial)((ReadablePartial)requestedDates.getFirst()), (ReadablePartial)candidate.getDepartureTo());
        Days gapFrom = Days.ZERO;
        if (requestedDates.getLast() != null) {
            gapFrom = Days.daysBetween((ReadablePartial)((ReadablePartial)requestedDates.getLast()), (ReadablePartial)candidate.getDepartureFrom());
        }
        candidate.setGapToRequiredDates(Math.abs(gapTo.getDays()) + Math.abs(gapFrom.getDays()));
        candidate.setMaxGapToRequiredDates(Math.max(Math.abs(gapTo.getDays()), Math.abs(gapFrom.getDays())));
        departuresFrom.putIfAbsent(candidate.getDepartureFrom().toString(), candidate);
        MatrixFlightWithGap cheapestByDate = departuresFrom.get(candidate.getDepartureFrom().toString());
        if (CommonConverterHelper.MONEY_COMPARATOR.compare(cheapestByDate.getPrice(), candidate.getPrice()) > 0) {
            departuresFrom.put(candidate.getDepartureFrom().toString(), candidate);
        }
    }

    private static Supplier<Map<String, MatrixFlightWithGap>> addMatrixDepartures(Map<String, Map<String, MatrixFlightWithGap>> to, MatrixFlightWithGap candidate) {
        return () -> {
            HashMap<String, MatrixFlightWithGap> departures = new HashMap<String, MatrixFlightWithGap>();
            departures.put(candidate.getDepartureFrom().toString(), candidate);
            to.put(candidate.getDepartureTo().toString(), departures);
            return departures;
        };
    }

    private static MatrixFlightWithGap convertMatrixFlight2Rest(com.gridnine.xtrip.common.gds.model.Flight flight, AviaPriceComponents priceComponents, Pair<org.joda.time.LocalDate> requestedDates, PriceDisplayStyle priceDisplayStyle) {
        MatrixFlightWithGap result = new MatrixFlightWithGap();
        List flightLegs = FlightHelper.getFlightLegs((com.gridnine.xtrip.common.gds.model.Flight)flight);
        result.setCarrier(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)flight.getCarrier()));
        result.setDepartureTo(new org.joda.time.LocalDate((Object)((FlightSegment)((List)flightLegs.get(0)).get(0)).getDateBegin()));
        result.setDepartureFrom(new org.joda.time.LocalDate((Object)((FlightSegment)((List)flightLegs.get(flightLegs.size() - 1)).get(0)).getDateBegin()));
        result.setPrice(CommonConverterHelper.convertMoney2Rest(AviaHelper.getPriceByDisplayStyle(priceDisplayStyle, priceComponents, AviaHelper.getAdultsType(flight.getSeats())), priceComponents.getCurrency()));
        Pair flightDates = new Pair((Object)result.getDepartureTo(), (Object)result.getDepartureFrom());
        if (requestedDates.equals((Object)flightDates)) {
            result.setCurrent(true);
        }
        if (result.getDepartureTo().equals(requestedDates.getFirst()) && requestedDates.getLast() == null) {
            result.setCurrent(true);
        }
        return result;
    }

    public static FlightDataWrapper convertRestToken2FlightDataWrapper(String token) {
        try {
            return (FlightDataWrapper)XUtil.deserialize((byte[])GZIPUtil.gunzip((byte[])Base64.decode((String)token)));
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"Error converting token to Flight data", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static com.gridnine.xtrip.common.gds.model.Flight convertRestToken2Flight(String token) {
        com.gridnine.xtrip.common.gds.model.Flight result = new com.gridnine.xtrip.common.gds.model.Flight();
        try {
            XUtil.fromString((String)new String(GZIPUtil.gunzip((byte[])Base64.decode((String)token)), StandardCharsets.UTF_8), (XSerializable)result);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"Error converting token to flight", (Throwable)e, (Object[])new Object[0]);
        }
        return result;
    }

    public static void addFlightToBestPrices(com.gridnine.xtrip.common.gds.model.Flight flight, Map<ConnectionsRestriction, BestFlights> bestFlights, GeneralPriceComponents priceComponents, Map<String, ExchangeRateData> currencyExchangeRateDataMap) {
        boolean toReplace;
        ConnectionsRestriction cr = AviaConverterHelper.getConnectionRestriction(flight);
        if (!bestFlights.containsKey(cr)) {
            bestFlights.put(cr, new BestFlights());
        }
        BestFlight candidate = AviaConverterHelper.convertBestFlight2Rest(flight, priceComponents, currencyExchangeRateDataMap);
        List bestByConnection = bestFlights.get(cr).getBestFlights();
        boolean hasBestByConnectionAndAirline = bestByConnection.stream().anyMatch(bf -> bf.getCarrier().equals(candidate.getCarrier()));
        boolean bl = toReplace = hasBestByConnectionAndAirline && bestByConnection.removeIf(bf -> bf.getCarrier().equals(candidate.getCarrier()) && CommonConverterHelper.MONEY_COMPARATOR.compare(bf.getSortedPrice(), candidate.getSortedPrice()) > 0);
        if (!hasBestByConnectionAndAirline || toReplace) {
            bestByConnection.add(candidate);
        }
    }

    private static ConnectionsRestriction getConnectionRestriction(com.gridnine.xtrip.common.gds.model.Flight flight) {
        int connectionsCount = 0;
        int legConnections = 0;
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                if (seg.isStarting()) {
                    if (legConnections > connectionsCount) {
                        connectionsCount = legConnections;
                    }
                    legConnections = 0;
                    continue;
                }
                ++legConnections;
            }
        }
        if (legConnections > connectionsCount) {
            connectionsCount = legConnections;
        }
        ConnectionsRestriction result = connectionsCount == 0 ? ConnectionsRestriction.DIRECT : (connectionsCount == 1 ? ConnectionsRestriction.ONE_CONNECTION : ConnectionsRestriction.TWO_CONNECTIONS);
        return result;
    }

    private static List<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment> convertFlightSegments2Rest(com.gridnine.xtrip.common.gds.model.Flight flight, PriceComponentsParameters priceComponentsParameters) {
        DictionaryReference<PassengerType> mainPassengerType = AviaConverterHelper.findMainPassengerType(flight);
        return FlightHelper.getFlightSegmentsStream((com.gridnine.xtrip.common.gds.model.Flight)flight).map(fs -> AviaConverterHelper.convertFlightSegment2Rest(fs, mainPassengerType, priceComponentsParameters)).collect(Collectors.toList());
    }

    private static com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment convertFlightSegment2Rest(FlightSegment segment, DictionaryReference<PassengerType> mainPassengerType, PriceComponentsParameters priceComponentsParameters) {
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment result = AviaConverterHelper.convertBaseSegmentInfo2Rest(segment);
        SegmentInfo segmentInfo = new SegmentInfo(priceComponentsParameters);
        segmentInfo.setBrandedFare(AviaConverterHelper.findFareInfo(segment, mainPassengerType));
        segmentInfo.setCarrier((DictionaryReference<Airline>)segment.getAirline());
        segment.getFareInfos().forEach(fi -> {
            segmentInfo.addBaseExtendedLuggageInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getExtendedLuggageInfo());
            segmentInfo.addBaseLuggageInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getLuggageInfo());
            segmentInfo.addBrandedLuggageInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getFareDetails());
            segmentInfo.addFareBasisInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getFareBasis(), fi.getRemarksSearchContext());
        });
        result.setServicesDetails(AviaConverterHelper.convertServicesDetails2Rest(segmentInfo));
        segment.getTechStopInfos().forEach(info -> result.getTechStopInfos().add(AviaConverterHelper.convertTechStopInfosRest(info)));
        return result;
    }

    private static com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.TechStopInfo convertTechStopInfosRest(TechStopInfo techStopInfo) {
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.TechStopInfo result = new com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.TechStopInfo();
        result.setLocation(AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)techStopInfo.getLocation()));
        result.setCity(AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)techStopInfo.getLocation()));
        result.setArrivalDate(techStopInfo.getArrivalDateTime());
        result.setDepartureDate(techStopInfo.getDepartureDateTime());
        result.setDuration(techStopInfo.getDuration());
        return result;
    }

    private static com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment convertBaseSegmentInfo2Rest(FlightSegment segment) {
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment result = new com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment();
        result.setDepartureAirport(AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getLocationBegin()));
        result.setDepartureCity(AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getLocationBegin()));
        result.setArrivalAirport(AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getLocationEnd()));
        result.setArrivalCity(AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getLocationEnd()));
        result.setDepartureDate(LocalDateTime.ofInstant(segment.getDateBegin().toInstant(), ZoneId.systemDefault()));
        result.setArrivalDate(LocalDateTime.ofInstant(segment.getDateEnd().toInstant(), ZoneId.systemDefault()));
        result.setAirline(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)segment.getAirline()));
        if (!segment.getAirline().getCode().equals(segment.getOperatingAirline().getCode())) {
            result.setOperatingAirline(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)segment.getOperatingAirline()));
        }
        result.setFlightNumber(segment.getFlightNumber());
        result.setAircraft(AviaConverterHelper.convertDictionaryReference2RestDictionaryItem((DictionaryReference<? extends BaseDictionary>)segment.getBoard()));
        result.setStops(Integer.valueOf(segment.getStops()));
        result.setTravelDuration(Integer.valueOf(segment.getTravelDuration()));
        result.setStarting(segment.isStarting());
        result.setClassOfService(segment.getServiceClass());
        result.setClassOfServiceCode(segment.getBookingClass());
        result.setSubjectToGovernmentApproval(segment.isSubjectToGovernmentApproval());
        return result;
    }

    private static ScheduleFlightSegmentItem convertScheduleFlightSegment2Rest(ScheduleFlightSegment segment) {
        ScheduleFlightSegmentItem result = new ScheduleFlightSegmentItem();
        result.setAircraft(AviaConverterHelper.convertDictionaryReference2RestDictionaryItem((DictionaryReference<? extends BaseDictionary>)segment.getBoard()));
        result.setAirline(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)segment.getAirline()));
        result.setOperatingAirline(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)segment.getOperatingAirline()));
        result.setDepartureAirport(AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getLocationBegin()));
        result.setDepartureCity(AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getLocationBegin()));
        result.setArrivalAirport(AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getLocationEnd()));
        result.setArrivalCity(AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getLocationEnd()));
        result.setDepartureDate(LocalDateTime.of(segment.getStartDate(), segment.getStartTime()));
        result.setArrivalDate(LocalDateTime.of(segment.getEndDate(), segment.getEndTime()));
        result.setFlightNumber(segment.getFlightNumber());
        result.setTravelDuration(segment.getTravelDuration());
        segment.getOperationDays().stream().map(Enum::name).forEach(dow -> result.getDaysOfWeek().add(dow));
        return result;
    }

    private static ServicesDetails convertServicesDetails2Rest(SegmentInfo segmentInfo) {
        ServicesDetails result = new ServicesDetails();
        result.getFreeLuggage().putAll(segmentInfo.getFreeLuggageInfo());
        result.getPaidLuggage().putAll(segmentInfo.getPaidLuggageInfo());
        result.getFreeCabinLuggage().putAll(segmentInfo.getFreeCabinLuggageInfo());
        result.getPaidCabinLuggage().putAll(segmentInfo.getPaidCabinLuggageInfo());
        result.getFareBasis().putAll(segmentInfo.fareBasis);
        result.getFareRules().putAll(segmentInfo.fareRules);
        FareDetails fareDetails = segmentInfo.getBrandedFare();
        if (fareDetails != null) {
            result.setTariffName(AviaConverterHelper.convertTariffName(segmentInfo));
            AdditionalServicesDetails additionalDetails = new AdditionalServicesDetails();
            additionalDetails.setExtraMileageBonus(fareDetails.getExtraMileageBonus());
            additionalDetails.setClassUpgradeAvailable(fareDetails.getClassUpgradeAvailable());
            additionalDetails.setBusinessLoungeAccess(fareDetails.getBusinessLoungeAccess());
            additionalDetails.setPriorityBoarding(fareDetails.getPriorityBoarding());
            additionalDetails.setTransferIncluded(fareDetails.getTransferIncluded());
            additionalDetails.setSeatChoice(fareDetails.getSeatChoice());
            additionalDetails.setMealService(fareDetails.getMealService());
            result.setAdditionalDetails(additionalDetails);
        }
        return result;
    }

    private static String convertTariffName(SegmentInfo segmentInfo) {
        if (segmentInfo == null || segmentInfo.getBrandedFare() == null) {
            return null;
        }
        FareDetails fareDetails = segmentInfo.getBrandedFare();
        Locale locale = LocaleUtil.createNormalizedLocale((Locale)LocaleManager.get().getCurrentLocale());
        return GDSHelper.getDisplayBrandName((FareDetails)fareDetails, (Locale)locale);
    }

    private static FareDetails findFareInfo(FlightSegment flightSegment, DictionaryReference<PassengerType> mainPassengerType) {
        FareInfo fareInfo = flightSegment.getFareInfos().stream().filter(p -> p.getPassengerType().equals((Object)mainPassengerType)).findFirst().orElse(null);
        if (fareInfo == null) {
            fareInfo = flightSegment.getFareInfos().stream().findFirst().orElse(null);
        }
        if (fareInfo != null) {
            return fareInfo.getFareDetails();
        }
        return null;
    }

    private static String convertLuggageUnit2Rest(DictionaryReference<LuggageUnit> unitRef) {
        if (unitRef != null) {
            LuggageUnit unit = (LuggageUnit)DictionaryCache.get().resolveReference(unitRef);
            if (unit != null && !unit.getSpellVariants().isEmpty()) {
                Locale locale = LocaleHelper.getCurrentLocale();
                return (String)CommonConverterHelper.findByLocale(unit.getTranslations(), locale);
            }
            return unitRef.getCode();
        }
        return null;
    }

    public static com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment convertBaseSegmentInfo2Rest(Segment segment) {
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment result = new com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment();
        result.setDepartureAirport(AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
        result.setDepartureCity(AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
        result.setArrivalAirport(AviaConverterHelper.getAirportWithIATACode((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        result.setArrivalCity(AviaConverterHelper.getAirportCity((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        if (segment.getStartDate() != null) {
            result.setDepartureDate(LocalDateTime.ofInstant(segment.getStartDate().toInstant(), ZoneId.systemDefault()));
        }
        if (segment.getEndDate() != null) {
            result.setArrivalDate(LocalDateTime.ofInstant(segment.getEndDate().toInstant(), ZoneId.systemDefault()));
        }
        result.setAirline(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)segment.getAirline()));
        if (segment.isCodeShare()) {
            result.setOperatingAirline(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)segment.getCodeShareCarrier()));
        }
        result.setFlightNumber(segment.getFlightNo());
        try {
            result.setAircraft(AviaConverterHelper.convertDictionaryReference2RestDictionaryItem((DictionaryReference<? extends BaseDictionary>)segment.getBoard()));
        }
        catch (NullPointerException e) {
            throw Xeption.forEndUser((String)"\u0412 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435 \u2116 {0} \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0438\u043f \u0441\u0430\u043c\u043e\u043b\u0451\u0442\u0430. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437.", (Object[])new Object[]{Integer.toString(segment.getRecordNumber())});
        }
        result.setStops(segment.getNoOfStops());
        result.setTravelDuration(segment.getFlightDuration());
        result.setStarting(segment.isStarting());
        result.setClassOfServiceCode(segment.getClassOfSvcCode());
        return result;
    }

    private static Segment findSameSegment(Segment segment, List<Segment> segments) {
        return segments.stream().filter(s -> AviaHelper.isSameProductSegment(s, segment)).findFirst().orElse(null);
    }

    public static Flight convertFlight2Rest(com.gridnine.xtrip.common.gds.model.Flight gdsFlight, PriceComponentsParameters parameters, SMGeneralSettings generalSettings, boolean displayTimeLimit, boolean showGdsAccountName) {
        VisaRequirement vr;
        Flight result = new Flight();
        PenaltiesResolver penaltiesResolver = new PenaltiesResolver(gdsFlight);
        result.getExchange().putAll(Penalty2RestConverter.convertExchangeInfo(penaltiesResolver.getPenaltiesInfos(), parameters));
        result.getRefund().putAll(Penalty2RestConverter.convertRefundInfo(penaltiesResolver.getPenaltiesInfos(), parameters));
        List<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment> restSegments = AviaConverterHelper.convertFlightSegments2Rest(gdsFlight, parameters);
        result.getLegs().addAll(AviaConverterHelper.convertLegs2Rest(restSegments, true, !gdsFlight.getMultiTicketBreakdown().isEmpty(), gdsFlight.getRequestedRoute()));
        result.setServicesStatuses(AviaConverterHelper.convertServicesStatuses2Rest(result));
        if (generalSettings != null && displayTimeLimit) {
            result.setTimeLimit(AviaConverterHelper.getCorrectTimeLimit(gdsFlight.getTimeLimit(), generalSettings));
            result.setTimeLimitCity(AviaConverterHelper.getTimeLimitCity(generalSettings));
        }
        result.setTripartiteContractDiscountApplied(AviaConverterHelper.isTripartiteContractDiscountApplied(gdsFlight));
        if (!gdsFlight.getMultiTicketBreakdown().isEmpty()) {
            result.setMultiTicket(true);
            result.getMessages().add(RestAviaInformationMessages.getMultiTicketFlight());
        }
        if (AviaConverterHelper.hasDifferentLuggage(restSegments)) {
            result.getMessages().add(RestAviaInformationMessages.getDifferentLuggage());
        }
        result.setCarrier(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)gdsFlight.getCarrier()));
        result.setAirlineAlliance(((Airline)DictionaryCache.get().resolveReference(gdsFlight.getCarrier())).getAlliance());
        result.setPrice(AviaPriceComponents.builder(gdsFlight, parameters).build().createPrice());
        result.getSeats().addAll(AviaConverterHelper.convertSeatPreferences2Rest(gdsFlight.getSeats()));
        result.setInfoMessage(gdsFlight.getInfoMessage());
        result.setHideOtherFares(gdsFlight.isFlightFaresSearchDisabled());
        result.setGds(gdsFlight.getGds());
        result.setGdsAccountName(gdsFlight.getGdsAccount().getCaption());
        result.setShowGdsAccountName(showGdsAccountName);
        result.setAvailableSeats(AviaConverterHelper.calcFlightAvailableSeats(gdsFlight));
        if (!gdsFlight.getVisaRequirements().isEmpty() && ((vr = (VisaRequirement)gdsFlight.getVisaRequirements().get(0)).isDocoNeeded() || vr.isDocaNeeded())) {
            DocoDocaNeededInfo info = new DocoDocaNeededInfo();
            info.setCountry(vr.getCountry());
            info.setDocaNeeded(vr.isDocaNeeded());
            info.setDocoNeeded(vr.isDocoNeeded());
            result.setDocoDocaNeededInfo(info);
        }
        CommonConverterHelper.addTravelPolicyInfo(gdsFlight.getTravelPolicyImpositionResult(), (HasTravelPolicyCompliance)result);
        gdsFlight.getVendorCommissionsDebugData().forEach((pt, items) -> result.getVendorCommissionsData().put(pt, items.stream().map(AviaConverterHelper::convertVendorCommissionItem).collect(Collectors.toList())));
        return result;
    }

    private static boolean hasDifferentLuggage(List<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment> restSegments) {
        ServicesDetails servicesDetails = null;
        for (com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment restSegment : restSegments) {
            if (servicesDetails == null) {
                servicesDetails = restSegment.getServicesDetails();
                continue;
            }
            if (!AviaConverterHelper.hasDifferentLuggage(servicesDetails, restSegment.getServicesDetails())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDifferentLuggage(ServicesDetails servicesDetails1, ServicesDetails servicesDetails2) {
        return AviaConverterHelper.hasDifferentLuggage(servicesDetails1.getFreeCabinLuggage(), servicesDetails2.getFreeCabinLuggage()) || AviaConverterHelper.hasDifferentLuggage(servicesDetails1.getPaidCabinLuggage(), servicesDetails2.getPaidCabinLuggage()) || AviaConverterHelper.hasDifferentLuggage(servicesDetails1.getFreeLuggage(), servicesDetails2.getFreeLuggage()) || AviaConverterHelper.hasDifferentLuggage(servicesDetails1.getPaidLuggage(), servicesDetails2.getPaidLuggage());
    }

    private static boolean hasDifferentLuggage(Map<DictionaryReference<PassengerType>, ExtendedLuggage> luggageMap1, Map<DictionaryReference<PassengerType>, ExtendedLuggage> luggageMap2) {
        if (luggageMap1.size() != luggageMap2.size()) {
            return true;
        }
        for (DictionaryReference<PassengerType> passengerType : luggageMap1.keySet()) {
            ExtendedLuggage luggage2;
            ExtendedLuggage luggage1 = luggageMap1.get(passengerType);
            if (!AviaConverterHelper.hasDifferentLuggage(luggage1, luggage2 = luggageMap2.get(passengerType))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDifferentLuggage(ExtendedLuggage luggage1, ExtendedLuggage luggage2) {
        if (luggage1 == null && luggage2 == null) {
            return false;
        }
        if (luggage1 == null || luggage2 == null) {
            return true;
        }
        return !MiscUtil.equals((Object)luggage1.isNil(), (Object)luggage2.isNil()) || !MiscUtil.equals((Object)luggage1.getPieces(), (Object)luggage2.getPieces()) || !MiscUtil.equals((Object)luggage1.getUnit(), (Object)luggage2.getUnit()) || !MiscUtil.equals((Object)luggage1.getWeight(), (Object)luggage2.getWeight()) || !MiscUtil.equals((Object)luggage1.getWeightUnit(), (Object)luggage2.getWeightUnit()) || !MiscUtil.equals((Object)luggage1.getLength(), (Object)luggage2.getLength()) || !MiscUtil.equals((Object)luggage1.getWidth(), (Object)luggage2.getWidth()) || !MiscUtil.equals((Object)luggage1.getHeight(), (Object)luggage2.getHeight()) || !MiscUtil.equals((Object)luggage1.getDimensionsSum(), (Object)luggage2.getDimensionsSum()) || !MiscUtil.equals((Object)luggage1.getDimensionUnit(), (Object)luggage2.getDimensionUnit());
    }

    private static Integer calcFlightAvailableSeats(com.gridnine.xtrip.common.gds.model.Flight gdsFlight) {
        List segments = FlightHelper.getSegments((com.gridnine.xtrip.common.gds.model.Flight)gdsFlight);
        if (segments.stream().anyMatch(seg -> seg.getAvailableSeats() == null)) {
            return null;
        }
        return segments.stream().map(FlightSegment::getAvailableSeats).min(Integer::compareTo).orElse(null);
    }

    public static boolean isTripartiteContractDiscountApplied(com.gridnine.xtrip.common.gds.model.Flight gdsFlight) {
        return AirProductHelper.isTripartiteDiscount((TripartiteContractDetails)gdsFlight.getTripartiteContractDetails());
    }

    private static RestVendorCommissionItem convertVendorCommissionItem(VendorCommissionDebugItem gdsItem) {
        RestVendorCommissionItem result = new RestVendorCommissionItem();
        result.setRate(gdsItem.getRate());
        result.setAmount(CommonConverterHelper.convertMoney2Rest(gdsItem.getAmount()));
        result.setRuleNumber(gdsItem.getRuleNumber());
        result.setContractCaption(gdsItem.getContractCaption());
        return result;
    }

    public static boolean isInternationalFlight(com.gridnine.xtrip.common.gds.model.Flight flight) {
        for (FlightSegment segment : FlightHelper.getSegments((com.gridnine.xtrip.common.gds.model.Flight)flight)) {
            if (!AviaConverterHelper.isDomesticCountry((DictionaryReference<GeoLocation>)segment.getLocationBegin())) {
                return true;
            }
            if (AviaConverterHelper.isDomesticCountry((DictionaryReference<GeoLocation>)segment.getLocationEnd())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDomesticCountry(DictionaryReference<GeoLocation> locationRef) {
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef);
        Country country = (Country)DictionaryCache.get().resolveReference(location.getCountry());
        return country.isDomestic();
    }

    public static boolean isMiddleNameRequired(com.gridnine.xtrip.common.gds.model.Flight gdsFlight) {
        for (FlightSegment segment : FlightHelper.getSegments((com.gridnine.xtrip.common.gds.model.Flight)gdsFlight)) {
            if (AviaConverterHelper.isCountryWithMiddleName((DictionaryReference<GeoLocation>)segment.getLocationBegin()) && AviaConverterHelper.isCountryWithMiddleName((DictionaryReference<GeoLocation>)segment.getLocationEnd())) continue;
            return false;
        }
        return true;
    }

    private static boolean isCountryWithMiddleName(DictionaryReference<GeoLocation> locationRef) {
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef);
        return DictHelper.getRuRef().equals((Object)location.getCountry());
    }

    private static List<SeatDescription> convertSeatPreferences2Rest(List<SeatPreferences> seatPreferences) {
        return GDSHelper.seatPreferencesToMap(seatPreferences).entrySet().stream().sorted((es1, es2) -> CommonHelper.sortByPassengerType((DictionaryReference<PassengerType>)((DictionaryReference)es1.getKey()), (DictionaryReference<PassengerType>)((DictionaryReference)es2.getKey()))).map(AviaConverterHelper::convertSeatDescription2Rest).collect(Collectors.toList());
    }

    private static SeatDescription convertSeatDescription2Rest(Map.Entry<DictionaryReference<PassengerType>, Integer> e) {
        SeatDescription sd = new SeatDescription();
        sd.setType(e.getKey());
        sd.setCount(e.getValue().intValue());
        return sd;
    }

    private static ServicesStatuses convertServicesStatuses2Rest(Flight flight) {
        ServicesStatuses result = new ServicesStatuses();
        List legs = flight.getLegs();
        result.setBaggage(AviaConverterHelper.getBaggageServiceStatus(legs));
        result.setRefund(AviaConverterHelper.getRefundServiceStatus(flight.getRefund()));
        result.setExchange(AviaConverterHelper.getExchangeServiceStatus(flight.getExchange()));
        return result;
    }

    public static ServicesStatuses convertServicesStatuses2Rest(AviaReservation reservation) {
        ServicesStatuses result = new ServicesStatuses();
        result.setBaggage(AviaConverterHelper.getBaggageServiceStatus(reservation.getLegs()));
        result.setRefund(AviaConverterHelper.getRefundServiceStatus(reservation.getRefund()));
        result.setExchange(AviaConverterHelper.getExchangeServiceStatus(reservation.getExchange()));
        return result;
    }

    private static ServicesStatuses convertServicesStatuses2Rest(com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Reservation reservation) {
        ServicesStatuses result = new ServicesStatuses();
        result.setBaggage(AviaConverterHelper.getBaggageServiceStatus(reservation.getLegs()));
        result.setRefund(AviaConverterHelper.getRefundServiceStatus(reservation.getRefund()));
        result.setExchange(AviaConverterHelper.getExchangeServiceStatus(reservation.getExchange()));
        return result;
    }

    private static ServiceStatus getRefundServiceStatus(Map<DictionaryReference<PassengerType>, RefundPenaltiesInfo> refundInfo) {
        for (RefundPenaltiesInfo refundPenaltiesInfo : refundInfo.values()) {
            if (refundPenaltiesInfo == null) {
                return ServiceStatus.OFF;
            }
            if (!Optional.ofNullable(refundPenaltiesInfo.isRefundableBeforeDeparture()).orElse(false).booleanValue() && !Optional.ofNullable(refundPenaltiesInfo.isRefundableAfterDeparture()).orElse(false).booleanValue()) {
                return ServiceStatus.OFF;
            }
            if (Optional.ofNullable(refundPenaltiesInfo.isRefundableBeforeDeparture()).orElse(false).booleanValue() && refundPenaltiesInfo.getRefundBeforeDeparture() != null && !MiscUtil.isZero((BigDecimal)refundPenaltiesInfo.getRefundBeforeDeparture().getAmount(), (boolean)true)) {
                return ServiceStatus.PAID;
            }
            if (!Optional.ofNullable(refundPenaltiesInfo.isRefundableAfterDeparture()).orElse(false).booleanValue() || refundPenaltiesInfo.getRefundAfterDeparture() == null || MiscUtil.isZero((BigDecimal)refundPenaltiesInfo.getRefundAfterDeparture().getAmount(), (boolean)true)) continue;
            return ServiceStatus.PAID;
        }
        return ServiceStatus.FREE;
    }

    private static ServiceStatus getExchangeServiceStatus(Map<DictionaryReference<PassengerType>, ExchangePenaltiesInfo> refundInfo) {
        for (ExchangePenaltiesInfo exchangePenaltiesInfo : refundInfo.values()) {
            if (exchangePenaltiesInfo == null) {
                return ServiceStatus.OFF;
            }
            if (!Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue() && !Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue()) {
                return ServiceStatus.OFF;
            }
            if (Optional.ofNullable(exchangePenaltiesInfo.isExchangeableBeforeDeparture()).orElse(false).booleanValue() && exchangePenaltiesInfo.getExchangeBeforeDeparture() != null && !MiscUtil.isZero((BigDecimal)exchangePenaltiesInfo.getExchangeBeforeDeparture().getAmount(), (boolean)true)) {
                return ServiceStatus.PAID;
            }
            if (!Optional.ofNullable(exchangePenaltiesInfo.isExchangeableAfterDeparture()).orElse(false).booleanValue() || exchangePenaltiesInfo.getExchangeAfterDeparture() == null || MiscUtil.isZero((BigDecimal)exchangePenaltiesInfo.getExchangeAfterDeparture().getAmount(), (boolean)true)) continue;
            return ServiceStatus.PAID;
        }
        return ServiceStatus.FREE;
    }

    private static ServiceStatus getBaggageServiceStatus(List<Leg> legs) {
        List segmentInfos = legs.stream().map(Leg::getSegments).flatMap(Collection::stream).collect(Collectors.toList());
        boolean isWithoutLuggage = segmentInfos.stream().map(com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment::getServicesDetails).anyMatch(sd -> {
            Collection<ExtendedLuggage> luggage = sd.getFreeLuggage().values();
            return AviaConverterHelper.withoutLuggage(luggage);
        });
        if (isWithoutLuggage) {
            boolean isWithoutPaidLuggage = segmentInfos.stream().map(com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment::getServicesDetails).anyMatch(sd -> {
                Collection<ExtendedLuggage> luggage = sd.getPaidLuggage().values();
                return AviaConverterHelper.withoutLuggage(luggage);
            });
            if (isWithoutPaidLuggage) {
                return ServiceStatus.OFF;
            }
            return ServiceStatus.PAID;
        }
        return ServiceStatus.FREE;
    }

    private static boolean withoutLuggage(Collection<ExtendedLuggage> srcLuggage) {
        ArrayList luggage = new ArrayList();
        srcLuggage.stream().filter(item -> Objects.nonNull(item.getPieces()) || Objects.nonNull(item.getPrice()) || Objects.nonNull(item.getWeightUnit()) || Objects.nonNull(item.getLength()) || Objects.nonNull(item.getWidth()) || Objects.nonNull(item.getHeight()) || Objects.nonNull(item.getDimensionsSum()) || Objects.nonNull(item.getDimensionUnit()) || Objects.nonNull(item.getUnit()) || Objects.nonNull(item.getWeight())).collect(Collectors.toCollection(() -> luggage));
        return luggage.isEmpty() || luggage.stream().anyMatch(Objects::isNull) || luggage.stream().filter(Objects::nonNull).anyMatch(el -> Boolean.TRUE.equals(el.isNil()));
    }

    private static DictionaryReference<PassengerType> findMainPassengerType(com.gridnine.xtrip.common.gds.model.Flight gdsFlight) {
        Set<DictionaryReference<PassengerType>> passengerTypes = gdsFlight.getSeats().stream().map(SeatPreferences::getPassengerType).collect(Collectors.toSet());
        return AviaConverterHelper.findMainPassengerType(passengerTypes);
    }

    private static DictionaryReference<PassengerType> findMainPassengerType(Reservation reservation) {
        Set<DictionaryReference<PassengerType>> passengerTypes = AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> p.getTicketType() != TicketType.CORRECTION).map(Product::getPassengerType).collect(Collectors.toSet());
        return AviaConverterHelper.findMainPassengerType(passengerTypes);
    }

    private static DictionaryReference<PassengerType> findMainPassengerType(Set<DictionaryReference<PassengerType>> passengerTypes) {
        if (passengerTypes.contains(DictHelper.getAdultPassengerType())) {
            return DictHelper.getAdultPassengerType();
        }
        if (passengerTypes.contains(((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH)).toReference())) {
            return ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH)).toReference();
        }
        if (passengerTypes.contains(((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR)).toReference())) {
            return ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR)).toReference();
        }
        return passengerTypes.stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static List<Leg> convertLegs2Rest(List<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment> segmentList, boolean online, boolean multiTicketLegs, List<RouteSegment> requestedRoute) {
        if (!online && segmentList.size() == 2) {
            com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment segment1 = segmentList.get(0);
            com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment segment2 = segmentList.get(1);
            if ((segment1.getDepartureCity() != null && segment2.getArrivalCity() != null && Objects.equals(segment1.getDepartureCity().getUid(), segment2.getArrivalCity().getUid()) || segment1.getDepartureAirport() != null && segment2.getArrivalAirport() != null && Objects.equals(segment1.getDepartureAirport().getUid(), segment2.getArrivalAirport().getUid())) && (segment1.getArrivalCity() != null && segment2.getDepartureCity() != null && Objects.equals(segment1.getArrivalCity().getUid(), segment2.getDepartureCity().getUid()) || segment1.getArrivalAirport() != null && segment2.getDepartureAirport() != null && Objects.equals(segment1.getArrivalAirport().getUid(), segment2.getDepartureAirport().getUid()))) {
                segment2.setStarting(true);
            }
        }
        if (multiTicketLegs) {
            Iterator requestedRouteIterator = requestedRoute.stream().flatMap(seg -> Stream.of(seg.getLocationBegin(), seg.getLocationEnd())).iterator();
            boolean insideLeg = false;
            DictionaryReference legEnd = null;
            for (com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment segment : segmentList) {
                if (insideLeg) {
                    segment.setStarting(false);
                    if (!AviaConverterHelper.isWithinSameCity(legEnd, segment.getArrivalAirport())) continue;
                    legEnd = null;
                    insideLeg = false;
                    continue;
                }
                DictionaryReference legStart = (DictionaryReference)requestedRouteIterator.next();
                if (!AviaConverterHelper.isWithinSameCity((DictionaryReference<GeoLocation>)legStart, segment.getDepartureAirport())) {
                    throw Xeption.forDeveloper((String)"expected leg start but city doesn't match: {0} and {1}", (Object[])new Object[]{legStart.getCode(), segment.getDepartureAirport().getUid()});
                }
                segment.setStarting(true);
                legEnd = (DictionaryReference)requestedRouteIterator.next();
                insideLeg = true;
                if (!AviaConverterHelper.isWithinSameCity((DictionaryReference<GeoLocation>)legEnd, segment.getArrivalAirport())) continue;
                legEnd = null;
                insideLeg = false;
            }
        }
        ArrayList<Leg> result = new ArrayList<Leg>();
        Leg currentLeg = null;
        for (com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment segment : segmentList) {
            if (currentLeg == null || segment.isStarting()) {
                currentLeg = new Leg();
                result.add(currentLeg);
            }
            currentLeg.getSegments().add(segment);
        }
        for (Leg leg : result) {
            leg.setDuration(AviaConverterHelper.calculateDuration(leg));
        }
        return result;
    }

    private static Integer calculateDuration(Leg leg) {
        Integer result = AviaConverterHelper.calculateDurationAsSum(leg);
        if (result != null) {
            return result;
        }
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment firstSeg = (com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment)leg.getSegments().get(0);
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment lastSeg = (com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment)leg.getSegments().get(leg.getSegments().size() - 1);
        return AviaConverterHelper.calculateDuration(firstSeg.getDepartureDate(), firstSeg.getDepartureAirport(), lastSeg.getArrivalDate(), lastSeg.getArrivalAirport());
    }

    private static Integer calculateDurationAsSum(Leg leg) {
        int result = 0;
        for (int i = 0; i < leg.getSegments().size(); ++i) {
            com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment seg = (com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment)leg.getSegments().get(i);
            if (seg.getTravelDuration() == null) {
                return null;
            }
            result += seg.getTravelDuration().intValue();
            if (i <= 0) continue;
            com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment prevSeg = (com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment)leg.getSegments().get(i - 1);
            Integer duration = AviaConverterHelper.calculateDuration(prevSeg.getArrivalDate(), prevSeg.getArrivalAirport(), seg.getDepartureDate(), seg.getDepartureAirport());
            if (duration == null) {
                return null;
            }
            result += duration.intValue();
        }
        return result;
    }

    private static Integer calculateDuration(LocalDateTime dateTimeFrom, DictionaryItem airportFrom, LocalDateTime dateTimeTo, DictionaryItem airportTo) {
        if (dateTimeFrom == null || airportFrom == null || dateTimeTo == null || airportTo == null) {
            return null;
        }
        ZonedDateTime from = DictHelper.getZonedDateTime((LocalDateTime)dateTimeFrom, (DictionaryReference)new GeoLocationReference(airportFrom.getRefCode()));
        if (from == null) {
            return null;
        }
        ZonedDateTime to = DictHelper.getZonedDateTime((LocalDateTime)dateTimeTo, (DictionaryReference)new GeoLocationReference(airportTo.getRefCode()));
        if (to == null) {
            return null;
        }
        return (int)Duration.between(from, to).toMinutes();
    }

    private static boolean isWithinSameCity(DictionaryReference<GeoLocation> loc1, DictionaryItem loc2) {
        return DictHelper.isWithinSameCity(loc1, (DictionaryReference)DictHelper.findGeoLocationByCodeVariant((String)loc2.getUid()).toReference());
    }

    public static com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Reservation convertReservation2Rest(Reservation reservation, PriceComponentsParameters priceComponentsParameters, SMGeneralSettings generalSettings) {
        VisaRequirement vr;
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Reservation result = new com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Reservation();
        PenaltiesResolver penaltiesResolver = new PenaltiesResolver(reservation);
        result.getExchange().putAll(Penalty2RestConverter.convertExchangeInfo(penaltiesResolver.getPenaltiesInfos(), priceComponentsParameters));
        result.getRefund().putAll(Penalty2RestConverter.convertRefundInfo(penaltiesResolver.getPenaltiesInfos(), priceComponentsParameters));
        result.getLegs().addAll(AviaConverterHelper.convertLegs2Rest(AviaConverterHelper.convertReservationSegments2Rest(reservation, priceComponentsParameters), CommonIbecorpHelper.isOnlineReservation((Reservation)reservation), false, null));
        result.setServicesStatuses(AviaConverterHelper.convertServicesStatuses2Rest(result));
        result.getPassengers().addAll(AirProductHelper.getAirProductsStream((Reservation)reservation).map(AviaConverterHelper::convertTraveller2Rest).sorted((p1, p2) -> CommonHelper.sortByPassengerType((DictionaryReference<PassengerType>)p1.getType(), (DictionaryReference<PassengerType>)p2.getType())).collect(Collectors.toList()));
        result.setCustomer(CommonConverterHelper.convertCustomer2Rest(reservation.getBookingFile().getCustomer()));
        if (Arrays.asList(ReservationStatus.BOOKING, ReservationStatus.ERROR).contains(CommonIbecorpHelper.getReservationStatus((Reservation)reservation))) {
            result.setTimeLimit(AviaConverterHelper.getCorrectTimeLimit(reservation.getTimeLimit(), generalSettings));
            result.setTimeLimitCity(AviaConverterHelper.getTimeLimitCity(generalSettings));
        }
        result.setCarrier(AviaConverterHelper.findMainProduct(reservation, AviaConverterHelper.findMainPassengerType(reservation)).getCarrier());
        try {
            result.setAirlineAlliance(((Airline)DictionaryCache.get().resolveReference(AviaConverterHelper.findMainProduct(reservation, AviaConverterHelper.findMainPassengerType(reservation)).getCarrier())).getAlliance());
        }
        catch (NullPointerException e) {
            result.setAirlineAlliance(null);
        }
        result.setPrice(ReservationPriceComponents.builder(reservation, priceComponentsParameters).build().createPrice());
        result.setRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        if (!reservation.getVisaRequirements().isEmpty() && ((vr = (VisaRequirement)reservation.getVisaRequirements().get(0)).isDocaNeeded() && !vr.isDocaSent() || vr.isDocoNeeded() && !vr.isDocoSent())) {
            DocoDocaNeededInfo info = new DocoDocaNeededInfo();
            info.setCountry(vr.getCountry());
            info.setDocaNeeded(vr.isDocaNeeded());
            info.setDocoNeeded(vr.isDocoNeeded());
            result.setDocoDocaNeededInfo(info);
        }
        return result;
    }

    public static List<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment> convertReservationSegments2Rest(Reservation reservation, PriceComponentsParameters priceComponentsParameters) {
        ArrayList<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment> result = new ArrayList<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment>(10);
        DictionaryReference<PassengerType> mainPassengerType = AviaConverterHelper.findMainPassengerType(reservation);
        List<Product> mainProducts = AviaConverterHelper.findMainProducts(reservation, mainPassengerType);
        List products = AirProductHelper.getAirProductsList((Reservation)reservation).stream().filter(p -> p.getTicketType() != TicketType.CORRECTION).collect(Collectors.toList());
        GDSHelper.getMcoProductsStream((Collection)reservation.getProducts()).filter(BookingConverterHelper::isFlyArystanPackage).forEach(products::add);
        if (mainProducts.isEmpty() && products.isEmpty()) {
            mainProducts.addAll(AirProductHelper.getProducts((Reservation)reservation).stream().filter(p -> ProductHandler.of((BaseProduct)p).getTicketType((BaseProduct)p) != TicketType.CORRECTION).collect(Collectors.toList()));
        }
        boolean hasSeveralProductsPerTraveller = false;
        for (Segment segment : mainProducts.stream().flatMap(p -> AirProductHelper.getProductSegmentsList((Product)p).stream()).collect(Collectors.toList())) {
            com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment segmentResult = AviaConverterHelper.convertBaseSegmentInfo2Rest(segment);
            segmentResult.setClassOfService(DictHelper.findClassOfService((Segment)segment, (Date)mainProducts.get(0).getIssueDate()));
            SegmentInfo segmentInfo = new SegmentInfo(priceComponentsParameters);
            segmentInfo.setBrandedFare(segment.getFareDetails());
            segmentInfo.setCarrier((DictionaryReference<Airline>)segment.getAirline());
            for (Product p2 : products) {
                if (p2.getPassengerType() == null) continue;
                Segment sameSegment = AviaConverterHelper.findSameSegment(segment, AirProductHelper.getProductSegmentsList((Product)p2));
                if (sameSegment != null) {
                    segmentInfo.addBaseLuggageInfo((DictionaryReference<PassengerType>)p2.getPassengerType(), sameSegment.getLuggageInfo());
                    segmentInfo.addBrandedLuggageInfo((DictionaryReference<PassengerType>)p2.getPassengerType(), sameSegment.getFareDetails());
                    segmentInfo.addFareBasisInfo((DictionaryReference<PassengerType>)p2.getPassengerType(), sameSegment.getFareBasis(), sameSegment.getRemarksSearchContext());
                    continue;
                }
                if (!AirProductHelper.isAirProduct((BaseProduct)p2)) continue;
                hasSeveralProductsPerTraveller = true;
            }
            segmentResult.setServicesDetails(AviaConverterHelper.convertServicesDetails2Rest(segmentInfo));
            segment.getTechStopInfos().forEach(info -> segmentResult.getTechStopInfos().add(AviaConverterHelper.convertTechStopInfosRest(info)));
            if (result.stream().anyMatch(r -> Objects.equals(r.getDepartureDate(), segmentResult.getDepartureDate()) && Objects.equals(r.getDepartureAirport() != null ? r.getDepartureAirport().getUid() : null, segmentResult.getDepartureAirport() != null ? segmentResult.getDepartureAirport().getUid() : null) && Objects.equals(r.getFlightNumber(), segmentResult.getFlightNumber()))) continue;
            result.add(segmentResult);
        }
        return hasSeveralProductsPerTraveller ? AviaConverterHelper.sortSegmentsByDepartureDate(result) : result;
    }

    private static List<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment> sortSegmentsByDepartureDate(List<com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment> segments) {
        return segments.stream().sorted((s1, s2) -> {
            DictionaryReference geolocationRef1 = DictHelper.getAirport((String)s1.getDepartureAirport().getUid(), (CodeSystem)CodeSystem.IATA);
            DictionaryReference geolocationRef2 = DictHelper.getAirport((String)s2.getDepartureAirport().getUid(), (CodeSystem)CodeSystem.IATA);
            ZoneId zoneId1 = DictHelper.getZoneId((DictionaryReference)geolocationRef1);
            ZoneId zoneId2 = DictHelper.getZoneId((DictionaryReference)geolocationRef2);
            if (null == zoneId1) {
                return null == zoneId2 ? 0 : -1;
            }
            if (null == zoneId2) {
                return 1;
            }
            return s1.getDepartureDate().atZone(ZoneId.systemDefault()).withZoneSameLocal(zoneId1).isAfter(s2.getDepartureDate().atZone(ZoneId.systemDefault()).withZoneSameLocal(zoneId2)) ? 1 : -1;
        }).collect(Collectors.toList());
    }

    private static Product findMainProduct(Reservation reservation, DictionaryReference<PassengerType> mainPassengerType) {
        return AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> p.getTicketType() != TicketType.CORRECTION).filter(p -> null == mainPassengerType || p.getPassengerType().equals((Object)mainPassengerType)).findFirst().get();
    }

    private static List<Product> findMainProducts(Reservation reservation, DictionaryReference<PassengerType> mainPassengerType) {
        Set collect = AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> p.getTicketType() != TicketType.CORRECTION).filter(p -> (null == mainPassengerType || mainPassengerType.equals((Object)p.getPassengerType())) && p.getNextProduct() == null).collect(Collectors.toSet());
        HashSet strList = new HashSet();
        BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).map(Product::getMcoToProductMapping).filter(Objects::nonNull).map(McoToProductMapping::getProductUid).filter(TextUtil::nonBlank).forEach(strList::add);
        BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).filter(p -> p.getProductCategory() == ProductCategory.AIR && strList.contains(p.getUid())).forEach(collect::add);
        return new ArrayList<Product>(collect);
    }

    private static LocalDateTime getCorrectTimeLimit(Date timeLimit, SMGeneralSettings generalSettings) {
        if (timeLimit == null) {
            return null;
        }
        return LocalDateTime.ofInstant(timeLimit.toInstant(), CommonHelper.getTimeZone(generalSettings).getTimeZone().toZoneId()).minusMinutes(15L);
    }

    private static String getTimeLimitCity(SMGeneralSettings generalSettings) {
        return CommonHelper.getTimeZone(generalSettings).getTimeZoneCity().toString(LocaleManager.get().getCurrentLocale());
    }

    private static BestFlight convertBestFlight2Rest(com.gridnine.xtrip.common.gds.model.Flight flight, GeneralPriceComponents priceComponents, Map<String, ExchangeRateData> currencyExchangeRateDataMap) {
        BestFlight result = new BestFlight();
        result.setCarrier(AviaConverterHelper.convert2AirlineWithCodeReference((DictionaryReference<Airline>)flight.getCarrier()));
        BigDecimal total = priceComponents.getTotal();
        result.setPrice(CommonConverterHelper.convertMoney2Rest(total, priceComponents.getCurrency()));
        ExchangeRateData rateData = currencyExchangeRateDataMap.get(priceComponents.getCurrency());
        if (total != null && rateData != null) {
            BigDecimal converted = MulticurrencyHelper.convert((BigDecimal)total, (ExchangeRateData)rateData);
            result.setSortedPrice(CommonConverterHelper.convertMoney2Rest(converted, rateData.getCurrency().getCode()));
        } else {
            result.setSortedPrice(result.getPrice());
        }
        return result;
    }

    private static DictionaryReference<GeoLocation> getGeoLocationDictReferenceByCode(String code) {
        return DictHelper.toReference((BaseDictionary)DictionaryCache.get().lookup(GeoLocation.class, code, new String[0]).stream().findFirst().orElse(null));
    }

    public static void populateSegment(Date minimumDate, BaseRoute br, RouteSegment seg) {
        seg.setLocationBegin(AviaConverterHelper.getGeoLocationDictReferenceByCode(br.getDepartureCode()));
        seg.setLocationEnd(AviaConverterHelper.getGeoLocationDictReferenceByCode(br.getArrivalCode()));
        AviaConverterHelper.setDate(minimumDate, br, seg);
        AviaConverterHelper.setTimeOfDate(br, seg);
        seg.setAirline(br.getAirline());
        seg.setFlightNumber(br.getFlightNumber());
    }

    public static Collection<QualifiedFlightNumber> buildFlightNumbers(List<String> flightNumbers) {
        return flightNumbers.stream().filter(TextUtil::nonBlank).map(fn -> {
            MiscUtil.Pair<DictionaryReference<Airline>, String> pair = AviaConverterHelper.parseFlightNumber(fn);
            QualifiedFlightNumber qfn = new QualifiedFlightNumber();
            qfn.setAirline((DictionaryReference)pair.getFirst());
            qfn.setFlightNumber((String)pair.getSecond());
            return qfn;
        }).collect(Collectors.toList());
    }

    private static MiscUtil.Pair<DictionaryReference<Airline>, String> parseFlightNumber(String flightNumber) {
        AirlineReference airlineRef = null;
        if (!(flightNumber.length() <= 2 || Character.isDigit(flightNumber.charAt(0)) && Character.isDigit(flightNumber.charAt(1)))) {
            String airlineCode = flightNumber.substring(0, 2).toUpperCase();
            Airline airline = DictHelper.findAirlineByAnyCode((String)airlineCode);
            if (airline == null) {
                throw Xeption.forDeveloper((String)"invalid airline code {0}, should have been handled by validation", (Object[])new Object[]{airlineCode});
            }
            airlineRef = airline.toReference();
            flightNumber = flightNumber.substring(2);
        }
        flightNumber = flightNumber.replaceAll("^0+", "");
        return new MiscUtil.Pair(airlineRef, (Object)flightNumber);
    }

    public static void populateSegment(Date minimumDate, SearchLeg fl, RouteSegment seg) {
        seg.setLocationBegin(fl.getDeparture());
        seg.setLocationEnd(fl.getArrival());
        AviaConverterHelper.setDate(minimumDate, fl, seg);
        AviaConverterHelper.setTimeOfDate(fl, seg);
    }

    private static void setDate(Date minimumDate, BaseRoute fl, RouteSegment seg) {
        if (Objects.nonNull(minimumDate) && minimumDate.after(fl.getDate().toDate())) {
            seg.setDate(minimumDate);
        } else {
            seg.setDate(fl.getDate().toDate());
        }
    }

    private static void setTimeOfDate(BaseRoute br, RouteSegment seg) {
        Integer timeBegin = null;
        Integer timeEnd = null;
        if (br.getDepartureTimeWindowStart() != null) {
            LocalTime localTimeBegin = br.getDepartureTimeWindowStart();
            timeBegin = localTimeBegin.getHour() * 60 + localTimeBegin.getMinute();
        }
        if (br.getDepartureTimeWindowEnd() != null) {
            LocalTime localTimeEnd = br.getDepartureTimeWindowEnd();
            timeEnd = localTimeEnd.getHour() * 60 + localTimeEnd.getMinute();
        }
        seg.setDepartureTimeBegin(timeBegin);
        seg.setDepartureTimeEnd(timeEnd);
    }

    private static void setDate(Date minimumDate, SearchLeg fl, RouteSegment seg) {
        if (Objects.nonNull(minimumDate) && minimumDate.after(fl.getDate().toDate())) {
            seg.setDate(minimumDate);
        } else {
            seg.setDate(fl.getDate().toDate());
        }
    }

    private static void setTimeOfDate(SearchLeg fl, RouteSegment seg) {
        int timeBegin = 0;
        int timeEnd = 1439;
        if (fl.getDepartureTimeWindowStart() != null) {
            LocalTime localTimeBegin = fl.getDepartureTimeWindowStart();
            timeBegin = localTimeBegin.getHour() * 60 + localTimeBegin.getMinute();
        }
        if (fl.getDepartureTimeWindowEnd() != null) {
            LocalTime localTimeEnd = fl.getDepartureTimeWindowEnd();
            timeEnd = localTimeEnd.getHour() * 60 + localTimeEnd.getMinute();
        }
        seg.setDepartureTimeBegin(Integer.valueOf(timeBegin));
        seg.setDepartureTimeEnd(Integer.valueOf(timeEnd));
    }

    private static boolean isSameDay(Date date1, Date date2) {
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(date1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(date2);
        return cal1.get(5) == cal2.get(5) && cal1.get(2) == cal2.get(2) && cal1.get(1) == cal2.get(1);
    }

    public static Pair<org.joda.time.LocalDate> getRequestedMatrixDates(SearchMatrixFlightsParameters parameters) {
        org.joda.time.LocalDate to = ((SearchLeg)parameters.getFlightLegs().get(0)).getDate();
        org.joda.time.LocalDate from = parameters.getRouteType() == RouteType.ROUNDTRIP ? ((SearchLeg)parameters.getFlightLegs().get(parameters.getFlightLegs().size() - 1)).getDate() : null;
        return new Pair((Object)to, from);
    }

    public static Pair<org.joda.time.LocalDate> getRequestedMatrixDates(CommonSearchParameters parameters) {
        org.joda.time.LocalDate to = ((BaseRoute)parameters.getRoutes().get(0)).getDate();
        org.joda.time.LocalDate from = parameters.getRouteType() == RouteType.ROUNDTRIP ? ((BaseRoute)parameters.getRoutes().get(parameters.getRoutes().size() - 1)).getDate() : null;
        return new Pair((Object)to, from);
    }

    public static void setCheapestFlight(Map<String, Map<String, MatrixFlightWithGap>> to, byte cheapestItemsNumber) {
        List<MatrixFlightWithGap> cheapestFlights = to.values().stream().map(Map::values).flatMap(Collection::stream).sorted((matrixFlight1, matrixFlight2) -> {
            int priceComparisionResult = CommonConverterHelper.MONEY_COMPARATOR.compare(matrixFlight1.getPrice(), matrixFlight2.getPrice());
            if (priceComparisionResult != 0) {
                return priceComparisionResult;
            }
            if (matrixFlight1.getGapToRequiredDates() > matrixFlight2.getGapToRequiredDates()) {
                return 1;
            }
            if (matrixFlight1.getGapToRequiredDates() < matrixFlight2.getGapToRequiredDates()) {
                return -1;
            }
            if (matrixFlight1.getMaxGapToRequiredDates() > matrixFlight2.getMaxGapToRequiredDates()) {
                return 1;
            }
            if (matrixFlight1.getMaxGapToRequiredDates() < matrixFlight2.getMaxGapToRequiredDates()) {
                return -1;
            }
            return 0;
        }).limit(cheapestItemsNumber).collect(Collectors.toList());
        if (cheapestFlights.size() > 0) {
            MatrixFlightWithGap firstCheapestFlight = (MatrixFlightWithGap)cheapestFlights.get(0);
            if (firstCheapestFlight.isCurrent()) {
                firstCheapestFlight.setCheapest(true);
            } else {
                cheapestFlights.forEach(matrixFlight -> matrixFlight.setCheapest(true));
            }
        }
    }

    public static Traveller convertRest2Traveler(Passenger passenger, com.gridnine.xtrip.common.gds.model.Flight gdsFlight) {
        boolean docaNeeded;
        List visaRequirements;
        Traveller result = new Traveller();
        result.setPassport(AviaConverterHelper.convertRest2Passport(passenger.getPassport(), gdsFlight));
        result.setName(TextUtil.buildFullName((PersonalName)result.getPassport()));
        result.getCommunications().addAll(AviaConverterHelper.convertRest2ContactCommunications(passenger));
        if (CommonValidationHelper.hasBonusCard(passenger.getBonusCard())) {
            result.getAirlineBonusCards().add(CommonConverterHelper.convertRest2BookingAirlineBonusCard(passenger.getBonusCard()));
        }
        boolean docoNeeded = CollectionUtil.isNotEmpty((Collection)(visaRequirements = gdsFlight.getVisaRequirements())) && ((VisaRequirement)visaRequirements.get(0)).isDocoNeeded();
        boolean bl = docaNeeded = CollectionUtil.isNotEmpty((Collection)visaRequirements) && ((VisaRequirement)visaRequirements.get(0)).isDocaNeeded();
        if (docoNeeded && passenger.getDocoInfo() != null) {
            result.setVisaNotNeeded(!passenger.getDocoInfo().isVisa());
            if (passenger.getDocoInfo().isVisa()) {
                result.getDocoInformations().add(CommonConverterHelper.convertRest2DocoInformation(passenger.getDocoInfo()));
            }
        }
        if (docaNeeded && passenger.getDocaInfo() != null) {
            result.getDocaInformations().add(CommonConverterHelper.convertRest2DocaInformation(passenger.getDocaInfo()));
        }
        return result;
    }

    private static Passenger convertTraveller2Rest(Product product) {
        Passenger result = new Passenger();
        AviaConverterHelper.updatePassenger(result, product);
        return result;
    }

    private static void updatePassenger(Passenger result, Product product) {
        result.setType(product.getPassengerType());
        Traveller traveller = product.getTraveller();
        CommonConverterHelper.updateRestTraveller((RestTraveller)result, traveller);
        if (traveller.getDocoInformations() != null && !traveller.getDocoInformations().isEmpty()) {
            result.setDocoInfo(AviaConverterHelper.convertDocoInformation(traveller.getDocoInformations()).get(0));
        }
        if (traveller.getDocaInformations() != null && !traveller.getDocaInformations().isEmpty()) {
            result.setDocaInfo(AviaConverterHelper.convertDocaInformation(traveller.getDocaInformations()).get(0));
        }
        if (traveller.getAirlineBonusCards() != null && !traveller.getAirlineBonusCards().isEmpty()) {
            result.setBonusCard(CommonConverterHelper.convertAirlineBonusCard2Rest((AirlineBonusCard)traveller.getAirlineBonusCards().get(0)));
        }
    }

    public static List<DocaInfo> convertDocaInformation(List<DocaInformation> docaInformations) {
        ArrayList<DocaInfo> result = new ArrayList<DocaInfo>();
        for (DocaInformation el : docaInformations) {
            DocaInfo docaInfo = new DocaInfo();
            docaInfo.setAddressType(el.getType());
            docaInfo.setCountry(el.getCountry());
            docaInfo.setCity(el.getCity());
            docaInfo.setStreet(el.getStreet());
            docaInfo.setStateProvince(el.getStateProvince());
            docaInfo.setZipPostalCode(el.getZipPostalCode());
            result.add(docaInfo);
        }
        return result;
    }

    public static List<DocoInfo> convertDocoInformation(List<DocoInformation> docoInformations) {
        ArrayList<DocoInfo> result = new ArrayList<DocoInfo>();
        for (DocoInformation el : docoInformations) {
            DocoInfo docoInfo = new DocoInfo();
            docoInfo.setPlaceOfBirthCountry(el.getPlaceOfBirthCountry());
            docoInfo.setVisaNumber(el.getVisaNumber());
            docoInfo.setVisaIssuePlace(el.getVisaIssuePlace());
            docoInfo.setVisaIssueDate(MiscUtil.convertToJodaLocalDate((Date)el.getVisaIssueDate()));
            docoInfo.setVisaExpirationDate(MiscUtil.convertToJodaLocalDate((Date)el.getVisaExpirationDate()));
            docoInfo.setVisaApplicableCountry(el.getVisaApplicableCountry());
            docoInfo.setVisa(true);
            result.add(docoInfo);
        }
        return result;
    }

    private static List<Communication> convertRest2ContactCommunications(Passenger passenger) {
        ArrayList<Communication> result = new ArrayList<Communication>(5);
        if (AviaHelper.hasEmail((DictionaryReference<PassengerType>)passenger.getType()) && TextUtil.nonBlank((String)passenger.getEmail())) {
            result.add(CommonConverterHelper.convertRest2EmailCommunication(passenger.getEmail(), Communication::new));
        }
        if (!CommonHelper.isEmpty(passenger.getPhone())) {
            result.add(CommonConverterHelper.convertRest2PhoneCommunication(passenger.getPhone(), CommunicationType.MOBILE, Communication::new));
        }
        return result;
    }

    private static Passport convertRest2Passport(RestPassport passport, com.gridnine.xtrip.common.gds.model.Flight gdsFlight) {
        if (passport == null) {
            return null;
        }
        Passport result = new Passport();
        result.setGender(passport.getGender());
        result.setFirstName(AviaConverterHelper.convertPassportName(passport.getFirstName()));
        result.setSecondName(AviaConverterHelper.convertPassportName(passport.getSecondName()));
        result.setLastName(AviaConverterHelper.convertPassportName(passport.getLastName()));
        if (!passport.isWithoutMiddleName()) {
            result.setMiddleName(AviaConverterHelper.convertPassportName(passport.getMiddleName()));
        }
        result.setBirthday(DateUtils.toJavaDate((LocalDate)passport.getBirthDate()));
        result.setCitizenship(passport.getCitizenship());
        result.setOriginCountry(passport.getOriginCountry());
        result.setType(AviaConverterHelper.convertPassportType(passport, gdsFlight));
        result.setExpired(AviaHelper.isCalculateExpiredDate(passport, gdsFlight) ? CommonValidationHelper.calculateExpiredDate((DictionaryReference<Country>)passport.getCitizenship(), FlightHelper.getLastArrivalTime((com.gridnine.xtrip.common.gds.model.Flight)gdsFlight)) : DateUtils.toJavaDate((LocalDate)passport.getExpiredDate()));
        result.setNumber(AviaConverterHelper.convertPassportNumber(passport.getNumber(), gdsFlight.getGds(), result.getType()));
        return result;
    }

    public static Passport convertRest2PassportForRule(RestPassport passport, com.gridnine.xtrip.common.gds.model.Flight gdsFlight) {
        if (passport == null) {
            return null;
        }
        Passport result = new Passport();
        result.setCitizenship(passport.getCitizenship());
        result.setType(AviaConverterHelper.convertPassportType(passport, gdsFlight));
        return result;
    }

    private static String convertPassportName(String name) {
        return !TextUtil.isBlank((String)name) ? name.toUpperCase().trim() : null;
    }

    private static PassportType convertPassportType(RestPassport passport, com.gridnine.xtrip.common.gds.model.Flight gdsFlight) {
        if (AviaHelper.isInternalNoDomesticPassport(passport, gdsFlight)) {
            return PassportType.PASSPORT;
        }
        if (AviaHelper.isForeignNoDomesticPassport(passport, gdsFlight)) {
            return PassportType.FOREIGN_NATIONAL_PASSPORT;
        }
        return passport.getType();
    }

    private static String convertPassportNumber(String number, GdsName gdsName, PassportType passportType) {
        if (number == null) {
            return null;
        }
        if (AviaHelper.isSirenaBirthDateNotification(gdsName, passportType)) {
            return number.replaceAll(" ", "");
        }
        StringBuilder result = new StringBuilder();
        number.chars().forEach(ch -> result.append(AviaConverterHelper.mapCharacter(ch, passportType == PassportType.BIRTHDAY_NOTIFICATION)));
        return result.toString();
    }

    private static String mapCharacter(int ch, boolean isBirthDateNotification) {
        if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || isBirthDateNotification && ch == 32) {
            return Character.valueOf((char)ch).toString();
        }
        if (isBirthDateNotification) {
            switch (ch) {
                case 1040: 
                case 1072: {
                    return "A";
                }
                case 1041: 
                case 1073: {
                    return "B";
                }
                case 1042: 
                case 1074: {
                    return "V";
                }
                case 1043: 
                case 1075: {
                    return "G";
                }
                case 1044: 
                case 1076: {
                    return "D";
                }
                case 1045: 
                case 1077: {
                    return "E";
                }
                case 1025: 
                case 1105: {
                    return "E";
                }
                case 1046: 
                case 1078: {
                    return "ZH";
                }
                case 1047: 
                case 1079: {
                    return "Z";
                }
                case 1048: 
                case 1080: {
                    return "I";
                }
                case 1049: 
                case 1081: {
                    return "I";
                }
                case 1050: 
                case 1082: {
                    return "K";
                }
                case 1051: 
                case 1083: {
                    return "L";
                }
                case 1052: 
                case 1084: {
                    return "M";
                }
                case 1053: 
                case 1085: {
                    return "H";
                }
                case 1054: 
                case 1086: {
                    return "O";
                }
                case 1055: 
                case 1087: {
                    return "P";
                }
                case 1056: 
                case 1088: {
                    return "R";
                }
                case 1057: 
                case 1089: {
                    return "S";
                }
                case 1058: 
                case 1090: {
                    return "T";
                }
                case 1059: 
                case 1091: {
                    return "U";
                }
                case 1060: 
                case 1092: {
                    return "F";
                }
                case 1061: 
                case 1093: {
                    return "KH";
                }
                case 1062: 
                case 1094: {
                    return "TC";
                }
                case 1063: 
                case 1095: {
                    return "CH";
                }
                case 1064: 
                case 1096: {
                    return "SH";
                }
                case 1065: 
                case 1097: {
                    return "SHCH";
                }
                case 1066: 
                case 1098: {
                    return "";
                }
                case 1067: 
                case 1099: {
                    return "Y";
                }
                case 1068: 
                case 1100: {
                    return "";
                }
                case 1069: 
                case 1101: {
                    return "E";
                }
                case 1070: 
                case 1102: {
                    return "U";
                }
                case 1071: 
                case 1103: {
                    return "IA";
                }
            }
        } else {
            switch (ch) {
                case 1040: 
                case 1072: {
                    return Character.valueOf('A').toString();
                }
                case 1042: 
                case 1074: {
                    return Character.valueOf('B').toString();
                }
                case 1045: 
                case 1077: {
                    return Character.valueOf('E').toString();
                }
                case 1030: 
                case 1110: {
                    return Character.valueOf('I').toString();
                }
                case 1050: 
                case 1082: {
                    return Character.valueOf('K').toString();
                }
                case 1052: 
                case 1084: {
                    return Character.valueOf('M').toString();
                }
                case 1053: 
                case 1085: {
                    return Character.valueOf('H').toString();
                }
                case 1054: 
                case 1086: {
                    return Character.valueOf('O').toString();
                }
                case 1058: 
                case 1090: {
                    return Character.valueOf('T').toString();
                }
                case 1056: 
                case 1088: {
                    return Character.valueOf('P').toString();
                }
                case 1061: 
                case 1093: {
                    return Character.valueOf('X').toString();
                }
                case 1057: 
                case 1089: {
                    return Character.valueOf('C').toString();
                }
                case 1048: 
                case 1080: {
                    return Character.valueOf('U').toString();
                }
                case 1059: 
                case 1091: {
                    return Character.valueOf('Y').toString();
                }
            }
            return "";
        }
        return "";
    }

    private static boolean hasExtendedFare(com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment segment, SMStep2Settings step2Settings) {
        return step2Settings.getExtendedTariffAirlines().contains(segment.getAirline().getUid());
    }

    public static com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GeoLocationReference convertGeoLocationReference2Rest(GeoLocation location, Locale locale) {
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GeoLocationReference result = new com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GeoLocationReference();
        result.setCode(location.getCode());
        result.setUid(location.getCode());
        result.setIataCode((String)location.getCodeVariants().get(CodeSystem.IATA.name()));
        result.setCrtCode((String)location.getCodeVariants().get(CodeSystem.CRT.name()));
        if (location.getType() == LocationType.CITY) {
            result.setCityCaption((String)CommonConverterHelper.findByLocale(location.getTranslations(), locale));
            result.setCountryCaption(AviaConverterHelper.getCountryCaption(location, locale));
            result.setType(GeoLocationType.CITY);
        } else if (location.getType() == LocationType.AIRPORT) {
            GeoLocation city = (GeoLocation)DictionaryCache.get().resolveReference(location.getParent());
            result.setAirportCaption((String)CommonConverterHelper.findByLocale(location.getTranslations(), locale));
            if (city != null) {
                result.setCityCaption((String)CommonConverterHelper.findByLocale(city.getTranslations(), locale));
                result.setCountryCaption(AviaConverterHelper.getCountryCaption(city, locale));
            } else {
                result.setCountryCaption(AviaConverterHelper.getCountryCaption(location, locale));
            }
            result.setType(GeoLocationType.AIRPORT);
        } else {
            throw new IllegalArgumentException("unexpected location type " + location.getType());
        }
        return result;
    }

    private static String getCountryCaption(GeoLocation location, Locale locale) {
        Country country = (Country)DictionaryCache.get().resolveReference(location.getCountry());
        if (country == null) {
            return null;
        }
        return (String)CommonConverterHelper.findByLocale(country.getTranslations(), locale);
    }

    public static com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.AirlineReference convertAirlineReference2Rest(Airline airline, Locale locale) {
        AirlineAlliance alliance;
        Country country;
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.AirlineReference result = new com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.AirlineReference();
        result.setCode(airline.getCode());
        result.setUid(airline.getCode());
        result.setNumber(airline.getAirlineNumber());
        result.setAirportCaption((String)CommonConverterHelper.findByLocale(airline.getTranslations(), locale));
        if (airline.getCountry() != null && (country = (Country)DictionaryCache.get().resolveReference(airline.getCountry())) != null) {
            result.setCountryCaption((String)CommonConverterHelper.findByLocale(country.getTranslations(), locale));
        }
        if (airline.getAlliance() != null && (alliance = (AirlineAlliance)DictionaryCache.get().resolveReference(airline.getAlliance())) != null) {
            result.setAlliance((String)CommonConverterHelper.findByLocale(alliance.getTranslations(), locale));
        }
        StringBuilder searchString = new StringBuilder();
        airline.getTranslations().forEach((key, value) -> searchString.append((String)value).append(" "));
        result.setSearchString(searchString.toString());
        return result;
    }

    private static AirlineWithCodeReference convert2AirlineWithCodeReference(DictionaryReference<Airline> airlineRef) {
        if (airlineRef == null) {
            return null;
        }
        AirlineWithCodeReference result = new AirlineWithCodeReference();
        result.setUid(airlineRef.getCode());
        result.setCaption(airlineRef.toString());
        Airline airline = (Airline)DictionaryCache.get().resolveReference(airlineRef);
        if (airline == null) {
            result.setAirlineCode(airlineRef.getCode());
        } else {
            Set codeVariantsEntries = airline.getCodeVariants().entrySet();
            Map.Entry airlineCodeEntry = null;
            List notEmptyEntries = codeVariantsEntries.stream().filter(entry -> TextUtil.nonBlank((String)((String)entry.getKey()))).filter(entry -> TextUtil.nonBlank((String)((String)entry.getValue()))).collect(Collectors.toList());
            if (notEmptyEntries.size() == 1) {
                airlineCodeEntry = (Map.Entry)notEmptyEntries.get(0);
            } else if (notEmptyEntries.size() > 1) {
                for (String priorityCodeSystem : PRIORITY_AIRLINE_CODE_SYSTEMS) {
                    airlineCodeEntry = notEmptyEntries.stream().filter(entry -> priorityCodeSystem.equals(entry.getKey())).findFirst().orElse(null);
                    if (airlineCodeEntry == null) continue;
                    break;
                }
                if (airlineCodeEntry == null) {
                    airlineCodeEntry = (Map.Entry)notEmptyEntries.get(0);
                }
            }
            if (airlineCodeEntry != null) {
                result.setCodeSystem((String)airlineCodeEntry.getKey());
                result.setAirlineCode((String)airlineCodeEntry.getValue());
            } else {
                result.setAirlineCode(airlineRef.getCode());
            }
        }
        return result;
    }

    private static DictionaryItem getAirportWithIATACode(DictionaryReference<GeoLocation> airport) {
        DictionaryItem result = AviaConverterHelper.convertDictionaryReference2RestDictionaryItem(airport);
        GeoLocation airportLocation = (GeoLocation)DictionaryCache.get().resolveReference(airport);
        if (airportLocation == null || airportLocation.getCodeVariants() == null) {
            return result;
        }
        String code = (String)airportLocation.getCodeVariants().get(CodeSystem.IATA.name());
        if (StringUtils.isEmpty((String)code)) {
            code = (String)airportLocation.getCodeVariants().get(CodeSystem.CRT.name());
        }
        if (StringUtils.isEmpty((String)code)) {
            return result;
        }
        result.setUid(code);
        result.setRefCode(airportLocation.getCode());
        result.setCaption(airport.toString());
        return result;
    }

    private static DictionaryItem getAirportCity(DictionaryReference<GeoLocation> airport) {
        GeoLocation airportLocation = (GeoLocation)DictionaryCache.get().resolveReference(airport);
        if (airportLocation != null && airportLocation.getType() == LocationType.AIRPORT) {
            DictionaryReference city = airportLocation.getParent();
            GeoLocation cityLocation = (GeoLocation)DictionaryCache.get().resolveReference(city);
            if (cityLocation != null && cityLocation.getType() == LocationType.CITY) {
                return AviaConverterHelper.convertDictionaryReference2RestDictionaryItem((DictionaryReference<? extends BaseDictionary>)city);
            }
        }
        return null;
    }

    private static DictionaryItem convertDictionaryReference2RestDictionaryItem(DictionaryReference<? extends BaseDictionary> dictRef) {
        if (null == dictRef) {
            return null;
        }
        DictionaryItem result = new DictionaryItem();
        result.setUid(dictRef.getCode());
        result.setRefCode(dictRef.getCode());
        BaseDictionary bd = DictionaryCache.get().resolveReference(dictRef);
        String caption = null;
        if (bd != null) {
            Locale locale = LocaleManager.get().getCurrentLocale();
            caption = (String)MiscUtil.findByLocale((Map)bd.getTranslations(), (Locale)locale);
            if (TextUtil.isBlank((String)caption) && !MiscUtil.equals((Object)locale, (Object)Locale.ENGLISH)) {
                caption = (String)MiscUtil.findByLocale((Map)bd.getTranslations(), (Locale)Locale.ENGLISH);
            }
        }
        result.setCaption(caption);
        if (StringUtils.isEmpty((String)result.getCaption())) {
            if (StringUtils.isNotEmpty((String)dictRef.getCode())) {
                result.setCaption(dictRef.getCode());
            } else {
                result.setCaption(dictRef.toString());
            }
        }
        return result;
    }

    private static class SegmentInfo {
        private final Set<DictionaryReference<PassengerType>> usedTypes = new HashSet<DictionaryReference<PassengerType>>();
        private final Map<DictionaryReference<PassengerType>, ExtendedLuggageInfo> baseExtendedLuggageInfo = new HashMap<DictionaryReference<PassengerType>, ExtendedLuggageInfo>();
        private final Map<DictionaryReference<PassengerType>, LuggageInfo> baseLuggageInfo = new HashMap<DictionaryReference<PassengerType>, LuggageInfo>();
        private final Map<DictionaryReference<PassengerType>, FareDetails> brandedLuggageInfo = new HashMap<DictionaryReference<PassengerType>, FareDetails>();
        private final Map<DictionaryReference<PassengerType>, String> fareBasis = new HashMap<DictionaryReference<PassengerType>, String>();
        private final Map<DictionaryReference<PassengerType>, String> fareRules = new HashMap<DictionaryReference<PassengerType>, String>();
        private FareDetails brandedFare;
        private DictionaryReference<Airline> carrier;
        private final PriceComponentsParameters priceComponentsParameters;

        public SegmentInfo(PriceComponentsParameters priceComponentsParameters) {
            this.priceComponentsParameters = priceComponentsParameters;
        }

        private ExtendedLuggage convertLuggageInfo2Rest(LuggageInfo luggageInfo) {
            ExtendedLuggage result = new ExtendedLuggage();
            if (luggageInfo != null) {
                boolean isNil = luggageInfo.isNil() || luggageInfo.getQuantity() == null || luggageInfo.getQuantity() == 0;
                result.setNil(Boolean.valueOf(isNil));
                if (!isNil) {
                    result.setPieces(luggageInfo.getQuantity());
                    result.setUnit(AviaConverterHelper.convertLuggageUnit2Rest((DictionaryReference<LuggageUnit>)luggageInfo.getUnit()));
                }
            }
            return result;
        }

        private boolean hasBrandedLuggageInfo(FareDetails fareDetails, Function<FareDetails, ExtendedLuggageInfo> getLuggage) {
            return Stream.of(fareDetails).filter(Objects::nonNull).map(getLuggage).anyMatch(this::hasLuggageInfo);
        }

        private boolean hasLuggageInfo(ExtendedLuggageInfo extendedLuggageInfo) {
            return Stream.of(extendedLuggageInfo).filter(Objects::nonNull).flatMap(li -> Stream.of(li.getPieces(), li.getWeight())).filter(Objects::nonNull).anyMatch(val -> val > 0);
        }

        private ExtendedLuggage getFreeLuggage(FareDetails fareDetails, ExtendedLuggageInfo extendedLuggageInfo, LuggageInfo luggageInfo) {
            if (this.hasBrandedLuggageInfo(fareDetails, FareDetails::getLuggageInfo)) {
                return this.covertExtendedLuggageToRest(fareDetails.getLuggageInfo());
            }
            if (this.hasLuggageInfo(extendedLuggageInfo)) {
                return this.covertExtendedLuggageToRest(extendedLuggageInfo);
            }
            return this.convertLuggageInfo2Rest(luggageInfo);
        }

        private ExtendedLuggage getFreeCabinLuggage(FareDetails fareDetails) {
            if (this.hasBrandedLuggageInfo(fareDetails, FareDetails::getCabinLuggageInfo)) {
                return this.covertExtendedLuggageToRest(fareDetails.getCabinLuggageInfo());
            }
            return new ExtendedLuggage();
        }

        private ExtendedLuggage covertExtendedLuggageToRest(ExtendedLuggageInfo extendedLuggageInfo) {
            ExtendedLuggage result = new ExtendedLuggage();
            result.setNil(Boolean.valueOf(false));
            result.setPieces(extendedLuggageInfo.getPieces());
            result.setWeight(extendedLuggageInfo.getWeight());
            result.setWeightUnit(extendedLuggageInfo.getWeightUnit());
            result.setLength(extendedLuggageInfo.getLength());
            result.setWidth(extendedLuggageInfo.getWidth());
            result.setHeight(extendedLuggageInfo.getHeight());
            result.setDimensionsSum(extendedLuggageInfo.getDimensionsSum());
            result.setDimensionUnit(extendedLuggageInfo.getDimensionUnit());
            return result;
        }

        private ExtendedLuggage exchangeAndConvertExtendedLuggage2Rest(ExtendedLuggageInfo luggageInfo, com.gridnine.xtrip.common.model.system.Money price) {
            ExtendedLuggage result = new ExtendedLuggage();
            if (luggageInfo != null) {
                result.setNil(Boolean.valueOf(luggageInfo.getPieces() != null && luggageInfo.getPieces() == 0 || luggageInfo.getPieces() == null && (luggageInfo.getWeight() == null || luggageInfo.getWeight() == 0)));
                result.setPieces(luggageInfo.getPieces());
                result.setWeight(luggageInfo.getWeight());
                result.setWeightUnit(luggageInfo.getWeightUnit());
                result.setLength(luggageInfo.getLength());
                result.setWidth(luggageInfo.getWidth());
                result.setHeight(luggageInfo.getHeight());
                result.setDimensionsSum(luggageInfo.getDimensionsSum());
                result.setDimensionUnit(luggageInfo.getDimensionUnit());
            }
            if (price != null) {
                if (price.getCurrency().equals(this.priceComponentsParameters.getCurrency())) {
                    result.setPrice(CommonConverterHelper.convertMoney2Rest(price.getValue(), price.getCurrency()));
                } else {
                    com.gridnine.xtrip.common.model.system.Money money = new com.gridnine.xtrip.common.model.system.Money();
                    money.setCurrency(this.priceComponentsParameters.getCurrency());
                    money.setValue(CurrencyHelper.exchange((com.gridnine.xtrip.common.model.system.Money)price, (String)this.priceComponentsParameters.getCurrency()));
                    result.setPrice(CommonConverterHelper.convertMoney2Rest(money));
                }
            }
            return result;
        }

        void addBaseExtendedLuggageInfo(DictionaryReference<PassengerType> passengerType, ExtendedLuggageInfo extendedLuggageInfo) {
            this.usedTypes.add(passengerType);
            this.baseExtendedLuggageInfo.put(passengerType, extendedLuggageInfo);
        }

        void addBaseLuggageInfo(DictionaryReference<PassengerType> passengerType, LuggageInfo luggageInfo) {
            this.usedTypes.add(passengerType);
            this.baseLuggageInfo.put(passengerType, luggageInfo);
        }

        void addBrandedLuggageInfo(DictionaryReference<PassengerType> passengerType, FareDetails fareDetails) {
            this.usedTypes.add(passengerType);
            this.brandedLuggageInfo.put(passengerType, fareDetails);
        }

        void addFareBasisInfo(DictionaryReference<PassengerType> passengerType, String fareBasisCode, String remarksSearchContext) {
            this.usedTypes.add(passengerType);
            this.fareBasis.put(passengerType, fareBasisCode);
            this.fareRules.put(passengerType, remarksSearchContext);
        }

        FareDetails getBrandedFare() {
            return this.brandedFare;
        }

        void setBrandedFare(FareDetails brandedFare) {
            this.brandedFare = brandedFare;
        }

        DictionaryReference<Airline> getCarrier() {
            return this.carrier;
        }

        void setCarrier(DictionaryReference<Airline> carrier) {
            this.carrier = carrier;
        }

        Map<DictionaryReference<PassengerType>, ExtendedLuggage> getFreeLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> this.getFreeLuggage(this.brandedLuggageInfo.get(t), this.baseExtendedLuggageInfo.get(t), this.baseLuggageInfo.get(t))));
        }

        Map<DictionaryReference<PassengerType>, ExtendedLuggage> getPaidLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> {
                FareDetails fareDetails = Optional.ofNullable(this.brandedLuggageInfo.get(t)).orElse(new FareDetails());
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getPaidLuggageInfo(), fareDetails.getPaidLuggagePrice());
            }));
        }

        Map<DictionaryReference<PassengerType>, ExtendedLuggage> getFreeCabinLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> this.getFreeCabinLuggage(this.brandedLuggageInfo.get(t))));
        }

        Map<DictionaryReference<PassengerType>, ExtendedLuggage> getPaidCabinLuggageInfo() {
            return this.usedTypes.stream().collect(Collectors.toMap(UnaryOperator.identity(), t -> {
                FareDetails fareDetails = Optional.ofNullable(this.brandedLuggageInfo.get(t)).orElse(new FareDetails());
                return this.exchangeAndConvertExtendedLuggage2Rest(fareDetails.getPaidCabinLuggageInfo(), fareDetails.getPaidCabinLuggagePrice());
            }));
        }
    }

    public static class Penalty2RestConverter {
        private static Money exchangeAndConvertMoney2Rest(PriceComponentsParameters priceComponentsParameters, com.gridnine.xtrip.common.model.system.Money money) {
            if (money == null || priceComponentsParameters.getCurrency().equals(money.getCurrency())) {
                return CommonConverterHelper.convertMoney2Rest(money);
            }
            com.gridnine.xtrip.common.model.system.Money result = new com.gridnine.xtrip.common.model.system.Money();
            result.setCurrency(priceComponentsParameters.getCurrency());
            result.setValue(CurrencyHelper.exchange((com.gridnine.xtrip.common.model.system.Money)money, (String)priceComponentsParameters.getCurrency()));
            return CommonConverterHelper.convertMoney2Rest(result);
        }

        private static RefundPenaltiesInfo convertRefundPenalties2Rest(PriceComponentsParameters priceComponentsParameters, PenaltiesInfo penaltiesInfo) {
            RefundPenaltiesInfo result = new RefundPenaltiesInfo();
            if (penaltiesInfo == null) {
                return result;
            }
            result.setRefundableBeforeDeparture(penaltiesInfo.getRefundableBeforeDeparture());
            result.setRefundableAfterDeparture(penaltiesInfo.getRefundableAfterDeparture());
            result.setRefundBeforeDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getRefundBeforeDeparture()));
            result.setRefundAfterDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getRefundAfterDeparture()));
            result.setRefundConditionsApplyBeforeDeparture(penaltiesInfo.isConditionsApplyRefundableBefore());
            result.setRefundConditionsApplyAfterDeparture(penaltiesInfo.isConditionsApplyRefundableAfter());
            return result;
        }

        private static ExchangePenaltiesInfo convertExchangePenalties2Rest(PriceComponentsParameters priceComponentsParameters, PenaltiesInfo penaltiesInfo) {
            ExchangePenaltiesInfo result = new ExchangePenaltiesInfo();
            if (penaltiesInfo == null) {
                return result;
            }
            result.setExchangeableBeforeDeparture(penaltiesInfo.getExchangableBeforeDeparture());
            result.setExchangeableAfterDeparture(penaltiesInfo.getExchangableAfterDeparture());
            result.setExchangeBeforeDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getExchangeBeforeDeparture()));
            result.setExchangeAfterDeparture(Penalty2RestConverter.exchangeAndConvertMoney2Rest(priceComponentsParameters, penaltiesInfo.getExchangeAfterDeparture()));
            result.setExchangeConditionsApplyBeforeDeparture(penaltiesInfo.isConditionsApplyExchangableBefore());
            result.setExchangeConditionsApplyAfterDeparture(penaltiesInfo.isConditionsApplyExchangableAfter());
            return result;
        }

        public static Map<DictionaryReference<PassengerType>, ExchangePenaltiesInfo> convertExchangeInfo(Map<DictionaryReference<PassengerType>, PenaltiesInfo> penaltiesInfos, PriceComponentsParameters priceComponentsParameters) {
            return penaltiesInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Penalty2RestConverter.convertExchangePenalties2Rest(priceComponentsParameters, (PenaltiesInfo)e.getValue())));
        }

        public static Map<DictionaryReference<PassengerType>, RefundPenaltiesInfo> convertRefundInfo(Map<DictionaryReference<PassengerType>, PenaltiesInfo> penaltiesInfos, PriceComponentsParameters priceComponentsParameters) {
            HashMap<DictionaryReference<PassengerType>, RefundPenaltiesInfo> result = new HashMap<DictionaryReference<PassengerType>, RefundPenaltiesInfo>();
            penaltiesInfos.forEach((k, v) -> result.put((DictionaryReference<PassengerType>)k, Penalty2RestConverter.convertRefundPenalties2Rest(priceComponentsParameters, v)));
            return result;
        }
    }
}

