/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.midoffice.model.BaseReservationCreationParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.AirlineWithCodeReference;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.DictionaryItem;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AviaHelper {
    private AviaHelper() {
    }

    public static int getAdultPassengersCount(Map<DictionaryReference<PassengerType>, Integer> passengers) {
        return passengers.entrySet().stream().filter(e -> PassengerFilters.adultsFilter.test((DictionaryReference<PassengerType>)e.getKey())).mapToInt(Map.Entry::getValue).sum();
    }

    public static int getChildrenPassengersCount(Map<DictionaryReference<PassengerType>, Integer> passengers) {
        return passengers.entrySet().stream().filter(e -> PassengerFilters.childrenFilter.test((DictionaryReference<PassengerType>)e.getKey())).mapToInt(Map.Entry::getValue).sum();
    }

    public static int getInfantPassengersCount(Map<DictionaryReference<PassengerType>, Integer> passengers) {
        return passengers.entrySet().stream().filter(e -> PassengerFilters.infantsFilter.test((DictionaryReference<PassengerType>)e.getKey())).mapToInt(Map.Entry::getValue).sum();
    }

    public static int getYouthAndSeniorsCount(Map<DictionaryReference<PassengerType>, Integer> passengers) {
        return passengers.entrySet().stream().filter(e -> PassengerFilters.youthsAndSeniorsFilter.test((DictionaryReference<PassengerType>)e.getKey())).mapToInt(Map.Entry::getValue).sum();
    }

    private static int getYouthPassengersCount(Map<DictionaryReference<PassengerType>, Integer> passengers) {
        return passengers.entrySet().stream().filter(e -> PassengerFilters.youthsFilter.test((DictionaryReference<PassengerType>)e.getKey())).mapToInt(Map.Entry::getValue).sum();
    }

    private static int getSeniorPassengersCount(Map<DictionaryReference<PassengerType>, Integer> passengers) {
        return passengers.entrySet().stream().filter(e -> PassengerFilters.seniorsFilter.test((DictionaryReference<PassengerType>)e.getKey())).mapToInt(Map.Entry::getValue).sum();
    }

    private static int getPromoPassengersCount(Map<DictionaryReference<PassengerType>, Integer> passengers) {
        return passengers.entrySet().stream().filter(e -> PassengerFilters.promosFilter.test((DictionaryReference<PassengerType>)e.getKey())).mapToInt(Map.Entry::getValue).sum();
    }

    public static boolean isValidPassengerTypeCategory(DictionaryReference<PassengerType> type) {
        if (PassengerFilters.adultsFilter.test(type) || PassengerFilters.youthsAndSeniorsFilter.test(type)) {
            return DictHelper.isAdultPassengerTypeCategory(type);
        }
        if (PassengerFilters.childrenFilter.test(type)) {
            return DictHelper.isChildPassengerTypeCategory(type);
        }
        if (PassengerFilters.infantsFilter.test(type)) {
            return DictHelper.isInfantPassengerTypeCategory(type);
        }
        return true;
    }

    private static DictionaryReference<PassengerType> getAdultsType(Map<DictionaryReference<PassengerType>, Integer> passengers) {
        Object result = AviaHelper.getSeniorPassengersCount(passengers) > 0 ? ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR)).toReference() : (AviaHelper.getYouthPassengersCount(passengers) > 0 ? ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH)).toReference() : (AviaHelper.getPromoPassengersCount(passengers) > 0 ? DictHelper.getPromoPassengerType() : DictHelper.getAdultPassengerType()));
        return result;
    }

    public static DictionaryReference<PassengerType> getAdultsType(List<SeatPreferences> seatPreferences) {
        return AviaHelper.getAdultsType(GDSHelper.seatPreferencesToMap(seatPreferences));
    }

    public static BigDecimal getPriceByDisplayStyle(PriceDisplayStyle priceDisplayStyle, AviaPriceComponents priceComponents, DictionaryReference<PassengerType> adultsType) {
        if (Objects.isNull(priceDisplayStyle) || priceDisplayStyle == PriceDisplayStyle.FOR_ADULT_PASSENGER) {
            return MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceComponents.getSinglePassengerTotal(adultsType), priceComponents.getSeparatedAncillaryFee(adultsType)});
        }
        return priceComponents.getTotal();
    }

    private static boolean isInternalRussianFlight(Flight flight) {
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                if (AviaHelper.isRussianGeoLocation((DictionaryReference<GeoLocation>)seg.getLocationBegin()) && AviaHelper.isRussianGeoLocation((DictionaryReference<GeoLocation>)seg.getLocationEnd())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isRussianGeoLocation(DictionaryReference<GeoLocation> ref) {
        GeoLocation loc = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(ref);
        if (loc == null) {
            return false;
        }
        DictionaryReference countryRef = loc.getCountry();
        return countryRef != null && "RU".equals(countryRef.getCode());
    }

    public static boolean isInternalCisCountryFlight(Flight flight) {
        DictionaryReference countryRef = null;
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                DictionaryReference endCountryRef;
                DictionaryReference startCountryRef = DictHelper.getCountry((DictionaryReference)seg.getLocationBegin());
                if (!MiscUtil.equals((Object)startCountryRef, (Object)(endCountryRef = DictHelper.getCountry((DictionaryReference)seg.getLocationEnd())), (boolean)false)) {
                    return false;
                }
                if (countryRef == null) {
                    countryRef = startCountryRef;
                    continue;
                }
                if (MiscUtil.equals((Object)countryRef, (Object)startCountryRef)) continue;
                return false;
            }
        }
        Country country = (Country)DictionaryCache.get().resolveReference(countryRef);
        if (country == null) {
            return false;
        }
        return country.getRegions().contains(AirProductHelper.cisRegion);
    }

    static boolean isInternalNoDomesticPassport(RestPassport passport, Flight gdsFlight) {
        if ((gdsFlight.getGds() == GdsName.SIRENA || gdsFlight.getGds() == GdsName.MIXVEL) && passport.getType() == PassportType.INTERNAL && CommonValidationHelper.isRu((DictionaryReference<Country>)passport.getCitizenship())) {
            return false;
        }
        return !(gdsFlight.getGds() != GdsName.SIRENA && gdsFlight.getGds() != GdsName.MIXVEL || passport.getType() != PassportType.INTERNAL || CommonValidationHelper.isRu((DictionaryReference<Country>)passport.getCitizenship()) && CommonValidationHelper.isRu((DictionaryReference<Country>)passport.getOriginCountry()));
    }

    static boolean isCalculateExpiredDate(RestPassport passport, Flight gdsFlight) {
        return AviaHelper.isInternalNoDomesticPassport(passport, gdsFlight) || passport.getType() == PassportType.INTERNAL || passport.getType() == PassportType.BIRTHDAY_NOTIFICATION;
    }

    static boolean isSirenaBirthDateNotification(GdsName gdsName, PassportType passportType) {
        return (gdsName == GdsName.SIRENA || gdsName == GdsName.MIXVEL) && passportType == PassportType.BIRTHDAY_NOTIFICATION;
    }

    static boolean isForeignNoDomesticPassport(RestPassport passport, Flight gdsFlight) {
        return !(gdsFlight.getGds() != GdsName.SIRENA && gdsFlight.getGds() != GdsName.MIXVEL || passport.getType() != PassportType.FOREIGN || CommonValidationHelper.isRu((DictionaryReference<Country>)passport.getCitizenship()) && CommonValidationHelper.isRu((DictionaryReference<Country>)passport.getOriginCountry()));
    }

    public static boolean hasEmail(DictionaryReference<PassengerType> pType) {
        return DictHelper.isAdultPassengerTypeCategory(pType);
    }

    public static GdsReservationCreationParameters getReservationCreationParameters(Collection<BaseReservationCreationParameters> reservationCreationParameters) {
        return reservationCreationParameters.stream().filter(rcp -> rcp instanceof GdsReservationCreationParameters).findFirst().map(rcp -> (GdsReservationCreationParameters)rcp).get();
    }

    public static boolean hasInvalidSegments(Reservation reservation) {
        return AirProductHelper.getAirProductsStream((Reservation)reservation).flatMap(AirProductHelper::getProductSegmentsStream).anyMatch(s -> !s.getStatus().equals("HK") && !s.getStatus().equals("confirm"));
    }

    public static boolean isSameProductSegment(Segment s1, Segment s2) {
        return MiscUtil.equals((Object)s1.getAirline(), (Object)s2.getAirline()) && MiscUtil.equals((Object)s1.getDepartureLocation(), (Object)s2.getDepartureLocation()) && MiscUtil.equals((Object)s1.getArriveLocation(), (Object)s2.getArriveLocation()) && MiscUtil.equals((Object)s1.getFlightNo(), (Object)s2.getFlightNo()) && MiscUtil.equals((Object)s1.getStartDate(), (Object)s2.getStartDate()) && MiscUtil.equals((Object)s1.getEndDate(), (Object)s2.getEndDate());
    }

    public static boolean isSameSegment(com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment s1, com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Segment s2) {
        return MiscUtil.equals((Object)AviaHelper.getRestAirlineUid(s1.getAirline()), (Object)AviaHelper.getRestAirlineUid(s2.getAirline())) && MiscUtil.equals((Object)AviaHelper.getDictItemUid(s1.getDepartureAirport()), (Object)AviaHelper.getDictItemUid(s2.getDepartureAirport())) && MiscUtil.equals((Object)AviaHelper.getDictItemUid(s1.getDepartureCity()), (Object)AviaHelper.getDictItemUid(s2.getDepartureCity())) && MiscUtil.equals((Object)AviaHelper.getDictItemUid(s1.getArrivalAirport()), (Object)AviaHelper.getDictItemUid(s2.getArrivalAirport())) && MiscUtil.equals((Object)AviaHelper.getDictItemUid(s1.getArrivalCity()), (Object)AviaHelper.getDictItemUid(s2.getArrivalCity())) && MiscUtil.equals((Object)s1.getFlightNumber(), (Object)s2.getFlightNumber()) && MiscUtil.equals((Object)s1.getDepartureDate(), (Object)s2.getDepartureDate());
    }

    private static String getRestAirlineUid(AirlineWithCodeReference restAirline) {
        return restAirline == null ? null : restAirline.getUid();
    }

    private static String getDictItemUid(DictionaryItem dictItem) {
        return dictItem == null ? null : dictItem.getUid();
    }

    private static Set<String> collectDictItemCodes(DictionaryItem ... items) {
        return Stream.of(items).filter(Objects::nonNull).map(DictionaryItem::getUid).collect(Collectors.toSet());
    }

    public static boolean isRuDocumentsNotAllowedForFlight(Flight flight) {
        return flight.getSegmentTariffs().stream().anyMatch(st -> st.getSegments().stream().anyMatch(seg -> {
            GeoLocation begin = (GeoLocation)DictHelper.resolve((DictionaryReference)seg.getLocationBegin());
            GeoLocation end = (GeoLocation)DictHelper.resolve((DictionaryReference)seg.getLocationEnd());
            Country beginCountry = (Country)DictHelper.resolve((DictionaryReference)begin.getCountry());
            Country endCountry = (Country)DictHelper.resolve((DictionaryReference)end.getCountry());
            return !beginCountry.isRuPassportAllowed() || !endCountry.isRuPassportAllowed();
        }));
    }

    public static TransliterationType verifyTransliteration(Flight gdsFlight, TransliterationType transliterationType) {
        return (TransliterationType)MiscUtil.guarded((Object)transliterationType, (Object)(gdsFlight.isLatinRegistration() ? TransliterationType.LATIN : TransliterationType.LATIN_AND_CYRILLIC));
    }

    public static List<Passport> getPassport(List<EntityReference<Person>> passengers) {
        return passengers.stream().map(EntityStorageHelper::resolve).filter(Objects::nonNull).map(EntityContainer::getEntity).map(Person::getPassports).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static final class PassengerFilters {
        public static final Predicate<DictionaryReference<PassengerType>> noFilterTypes = type -> true;
        static final Predicate<DictionaryReference<PassengerType>> adultsFilter = type -> type.equals((Object)DictHelper.getAdultPassengerType());
        static final Predicate<DictionaryReference<PassengerType>> childrenFilter = type -> type.equals((Object)DictHelper.getChildPassengerType());
        static final Predicate<DictionaryReference<PassengerType>> infantsFilter = type -> type.equals((Object)DictHelper.getInfantPassengerType());
        public static final Predicate<DictionaryReference<PassengerType>> adultsAndInfantsFilter = type -> adultsFilter.test((DictionaryReference<PassengerType>)type) || infantsFilter.test((DictionaryReference<PassengerType>)type);
        static final Predicate<DictionaryReference<PassengerType>> youthsFilter = type -> type.equals((Object)((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.YOUTH)).toReference());
        static final Predicate<DictionaryReference<PassengerType>> seniorsFilter = type -> type.equals((Object)((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.SENIOR)).toReference());
        static final Predicate<DictionaryReference<PassengerType>> promosFilter = type -> type.equals((Object)((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.PROMO)).toReference());
        public static final Predicate<DictionaryReference<PassengerType>> youthsAndSeniorsFilter = type -> youthsFilter.test((DictionaryReference<PassengerType>)type) || seniorsFilter.test((DictionaryReference<PassengerType>)type);

        private PassengerFilters() {
        }
    }
}

