/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.rules.passport.PassportActionSet;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BCreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.TravellerPhoneValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchLeg;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.rules.PassportRuleHelper;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.joda.time.ReadablePartial;

public final class AviaValidationHelper {
    private static final Pattern ALPHA_NUMERIC_PATTERN = Pattern.compile("^([1-9A-Za-z]){3}[0-9A-Za-z]{3}(($)|([1-9A-Za-z]$)|([0-9A-Za-z]{4})$)");
    private static final Pattern RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN = Pattern.compile("^[IVX]+[\u0410-\u042f\u0430-\u044f]{2}[0-9]{6}$");

    private AviaValidationHelper() {
    }

    public static void validateFlightLeg(SearchLeg fl) {
        if (Objects.isNull(fl.getDeparture())) {
            fl.getValidationContext().getDepartureValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDepartureLocation());
        }
        if (Objects.isNull(fl.getArrival())) {
            fl.getValidationContext().getArrivalValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyArrivalLocation());
        }
        if (Objects.nonNull(fl.getDeparture()) && fl.getDeparture().equals((Object)fl.getArrival())) {
            fl.getValidationContext().getDepartureValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
            fl.getValidationContext().getArrivalValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
        }
        if (Objects.isNull(fl.getDate())) {
            fl.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDate());
        }
        if (Objects.nonNull(fl.getDate()) && fl.getDate().isBefore((ReadablePartial)org.joda.time.LocalDate.now())) {
            fl.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getPastDate());
        }
        if (fl.getDepartureTimeWindowStart() != null && fl.getDepartureTimeWindowEnd() != null && fl.getDepartureTimeWindowStart().isAfter(fl.getDepartureTimeWindowEnd())) {
            fl.getValidationContext().getDepartureTimeWindowStartValidationMessages().add(SearchFlightsParametersValidationMessages.getStartTimeAfterEndTime());
        }
    }

    public static void validateRoute(BaseRoute br, Date minimumDate) {
        if (TextUtil.isBlank((String)br.getDepartureCode())) {
            br.getValidationContext().getDepartureCodeValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDepartureLocation());
        }
        if (TextUtil.isBlank((String)br.getArrivalCode())) {
            br.getValidationContext().getArrivalCodeValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyArrivalLocation());
        }
        if (TextUtil.nonBlank((String)br.getDepartureCode()) && br.getDepartureCode().equals(br.getArrivalCode())) {
            br.getValidationContext().getDepartureCodeValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
            br.getValidationContext().getArrivalCodeValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
        }
        if (Objects.isNull(br.getDate())) {
            br.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyDate());
        }
        if (Objects.nonNull(br.getDate()) && br.getDate().isBefore((ReadablePartial)org.joda.time.LocalDate.now())) {
            br.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getPastDate());
        }
        if (Objects.nonNull(br.getDate()) && Objects.nonNull(minimumDate) && br.getDate().toDate().before(MiscUtil.clearTime((Date)minimumDate))) {
            br.getValidationContext().getDateValidationMessages().add(SearchFlightsParametersValidationMessages.getUnavailableDate());
        }
        if (br.getDepartureTimeWindowStart() != null && br.getDepartureTimeWindowEnd() != null && br.getDepartureTimeWindowStart().isAfter(br.getDepartureTimeWindowEnd())) {
            br.getValidationContext().getDepartureTimeWindowStartValidationMessages().add(SearchFlightsParametersValidationMessages.getStartTimeAfterEndTime());
        }
        if (br.getFlightNumber() != null) {
            if (br.getAirline() == null) {
                br.getValidationContext().getAirlineValidationMessages().add(SearchFlightsParametersValidationMessages.getMissingAirlineInFlightNumber());
            }
            if (!br.getFlightNumber().matches("[0-9]{1,4}")) {
                br.getValidationContext().getFlightNumberValidationMessages().add(SearchFlightsParametersValidationMessages.getInvalidFlightNumber());
            }
        }
    }

    public static void validateChildAges(SearchFlightsParameters parameters, int children) {
        for (int i = 0; i < children; ++i) {
            if (i < parameters.getChildsAge().size() && !Objects.isNull(parameters.getChildsAge().get(i))) continue;
            parameters.getValidationContext().getChildsAgeListValidationMessages().put(i, Collections.singletonList(SearchFlightsParametersValidationMessages.getEmptyChildsAge()));
        }
    }

    public static void validateChildAges(CommonSearchParameters parameters, int children) {
        for (int i = 0; i < children; ++i) {
            if (i < parameters.getChildsAge().size() && !Objects.isNull(parameters.getChildsAge().get(i))) continue;
            parameters.getValidationContext().getChildsAgeListValidationMessages().put(i, Collections.singletonList(SearchFlightsParametersValidationMessages.getEmptyChildsAge()));
        }
    }

    public static boolean validatePassenger(Passenger passenger, CreateBookingParameters parameters, SalesContext salesContext) {
        boolean isValidateEmail;
        Flight gdsFlight;
        try {
            gdsFlight = parameters.getClass().equals(B2BCreateBookingParameters.class) ? AviaConverterHelper.convertRestToken2FlightDataWrapper(parameters.getFlightToken()).getGdsFlight() : AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken());
        }
        catch (Exception e) {
            return false;
        }
        EntityContainer site = EntityStorage.get().resolve(salesContext.getSite());
        AviaValidationHelper.isValidPassport(passenger.getPassport(), gdsFlight, (DictionaryReference<PassengerType>)passenger.getType(), (EntityContainer<SMSite>)site, salesContext);
        if (((SMSite)site.getEntity()).getSiteType().equals((Object)SMSiteType.B2B)) {
            AviaValidationHelper.isValidBirthDate(passenger, gdsFlight, (DictionaryReference<PassengerType>)passenger.getType(), (EntityContainer<SMSite>)site);
        }
        boolean bl = isValidateEmail = gdsFlight.getGds() == GdsName.SABRE && AviaHelper.hasEmail((DictionaryReference<PassengerType>)passenger.getType());
        if (isValidateEmail || !TextUtil.isBlank((String)passenger.getEmail())) {
            AviaValidationHelper.isValidEmail(passenger);
        }
        AviaValidationHelper.isValidPhone(passenger);
        boolean hasBonusCard = CommonValidationHelper.hasBonusCard(passenger.getBonusCard());
        if (hasBonusCard) {
            CommonValidationHelper.isValidBonusCard(passenger.getBonusCard(), gdsFlight);
        }
        if (passenger.getDocoInfo() != null) {
            CommonValidationHelper.validateDocoInfo(passenger.getDocoInfo());
        }
        if (passenger.getDocaInfo() != null) {
            CommonValidationHelper.validateDocaInfo(passenger.getDocaInfo());
        }
        return ValidationHelper.isValid((Validatable)passenger);
    }

    private static void isValidPassport(RestPassport passport, Flight gdsFlight, DictionaryReference<PassengerType> passengerType, EntityContainer<SMSite> site, SalesContext salesContext) {
        RestPassport.RestPassportValidationContext validationContext = passport.getValidationContext();
        PassportActionSet transliterationRules = PassportRuleHelper.getPassportRules(gdsFlight, passengerType, AviaConverterHelper.convertRest2PassportForRule(passport, gdsFlight), salesContext);
        TransliterationType nameTransliterationType = AviaHelper.verifyTransliteration(gdsFlight, transliterationRules.getTransliterationTypeFullName());
        if (passport.getGender() == null) {
            validationContext.getGenderValidationMessages().add(CreateBookingParametersValidationMessages.getMissingGender());
        }
        AviaValidationHelper.isValidFirstName(passport, nameTransliterationType);
        AviaValidationHelper.isValidSecondName(passport, nameTransliterationType);
        AviaValidationHelper.isValidLastName(passport, nameTransliterationType);
        if (((SMSite)site.getEntity()).getSiteType().equals((Object)SMSiteType.B2B)) {
            if (AviaConverterHelper.isMiddleNameRequired(gdsFlight) && !passport.isWithoutMiddleName()) {
                AviaValidationHelper.isValidMiddleName(passport, nameTransliterationType);
            }
        } else if (!AviaConverterHelper.isInternationalFlight(gdsFlight) && !passport.isWithoutMiddleName()) {
            AviaValidationHelper.isValidMiddleName(passport, nameTransliterationType);
        }
        if (((SMSite)site.getEntity()).getSiteType().equals((Object)SMSiteType.B2C)) {
            AviaValidationHelper.isValidBirthDate(passport, gdsFlight, passengerType, site);
        }
        if (passport.getCitizenship() == null) {
            validationContext.getCitizenshipValidationMessages().add(CreateBookingParametersValidationMessages.getMissingCitizenship());
        }
        if (passport.getOriginCountry() == null) {
            validationContext.getOriginCountryValidationMessages().add(CreateBookingParametersValidationMessages.getMissingOrigin());
        }
        if (passport.getType() == null) {
            validationContext.getTypeValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportType());
        }
        if (AviaValidationHelper.isValidateExpiredDate(passport) && !AviaHelper.isCalculateExpiredDate(passport, gdsFlight)) {
            AviaValidationHelper.isValidExpiredDate(passport, gdsFlight);
        }
        AviaValidationHelper.isValidPassportNumber(passport, gdsFlight);
        ValidationHelper.isValid((Validatable)passport);
    }

    private static boolean isValidateExpiredDate(RestPassport passport) {
        return passport.getType() != null && passport.getCitizenship() != null && passport.getOriginCountry() != null;
    }

    public static boolean isValidDKNumber(String number) {
        return ALPHA_NUMERIC_PATTERN.matcher(number).matches();
    }

    private static void isValidPhone(Passenger passenger) {
        if (passenger.getType().equals((Object)DictHelper.getInfantPassengerType())) {
            if (!CommonHelper.isEmpty(passenger.getPhone())) {
                CommonValidationHelper.isValidPhone(passenger.getPhone(), passenger.getValidationContext().getPhoneValidationMessages());
            }
        } else if (!DictHelper.isInfantPassengerTypeCategory((DictionaryReference)passenger.getType()) && !DictHelper.isChildPassengerTypeCategory((DictionaryReference)passenger.getType()) && CommonHelper.isEmpty(passenger.getPhone())) {
            passenger.getValidationContext().getPhoneValidationMessages().add(TravellerPhoneValidationMessages.getMissingTravellerPhone());
        }
    }

    private static void isValidEmail(Passenger passenger) {
        if (TextUtil.isBlank((String)passenger.getEmail())) {
            passenger.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getMissingEmail());
            return;
        }
        if (!CommonValidationHelper.isValidEmailFormat(passenger.getEmail())) {
            passenger.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalEmail());
        }
    }

    private static void isValidPassportNumber(RestPassport passport, Flight gdsFlight) {
        boolean isRuBirthdayNotification;
        if (TextUtil.isBlank((String)passport.getNumber())) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportNumber());
            return;
        }
        String number = passport.getNumber();
        boolean isSirenaBirthDateNotification = AviaHelper.isSirenaBirthDateNotification(gdsFlight.getGds(), passport.getType());
        DictionaryReference citizenship = passport.getCitizenship();
        boolean bl = isRuBirthdayNotification = CommonValidationHelper.isRu((DictionaryReference<Country>)citizenship) && passport.getType() == PassportType.BIRTHDAY_NOTIFICATION;
        if (!isSirenaBirthDateNotification && !isRuBirthdayNotification && AviaValidationHelper.isInvalidCharacterInPassportNumber(passport)) {
            passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalPassportNumber());
            return;
        }
        if (citizenship != null) {
            if (passport.getType() == PassportType.BIRTHDAY_NOTIFICATION) {
                if (CommonValidationHelper.isRu((DictionaryReference<Country>)citizenship)) {
                    boolean isValidRuBirthDateNotification;
                    boolean bl2 = isValidRuBirthDateNotification = isSirenaBirthDateNotification ? AviaValidationHelper.isValidSirenaBirthDateNotificationNumber(number) : AviaValidationHelper.isValidRussianBirthDateNotificationNumber(number);
                    if (!isValidRuBirthDateNotification) {
                        passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalBirthdayNotificationNumber());
                    }
                    return;
                }
                if (CommonValidationHelper.isKz((DictionaryReference<Country>)citizenship) && !CommonValidationHelper.isValidKzBirthDateNotificationNumber(number)) {
                    passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalKzBirthdayNotificationNumber());
                }
            }
            if (CommonValidationHelper.isRu((DictionaryReference<Country>)citizenship)) {
                if (!(passport.getType() != PassportType.INTERNAL || CommonValidationHelper.isNumber(number) && number.length() == 10)) {
                    passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalLengthPassportNumber((int)10));
                    return;
                }
                if (!(passport.getType() != PassportType.FOREIGN || CommonValidationHelper.isNumber(number) && number.length() == 9)) {
                    passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalLengthPassportNumber((int)9));
                    return;
                }
                if (!(passport.getType() != PassportType.SEAMANSID || CommonValidationHelper.isNumber(number) && number.length() == 7)) {
                    passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalLengthPassportNumber((int)7));
                    return;
                }
            }
            if (passport.getType() == PassportType.PASSPORT && CommonValidationHelper.isKz((DictionaryReference<Country>)citizenship) && !CommonValidationHelper.isKzPassport(number)) {
                passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIvalidValueFixedLettersAndNumbers((int)1, (int)8));
                return;
            }
            if (CommonValidationHelper.isUa((DictionaryReference<Country>)citizenship) && number.length() > 15) {
                passport.getValidationContext().getNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalInternalPassportNumberUA());
            }
        }
    }

    private static boolean isValidSirenaBirthDateNotificationNumber(String number) {
        return RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN.matcher(number.replaceAll(" ", "")).matches();
    }

    private static boolean isValidRussianBirthDateNotificationNumber(String number) {
        return RUSSIAN_BIRTHDAY_NOTIFICATION_PATTERN.matcher(number).matches();
    }

    private static void isValidExpiredDate(RestPassport passport, Flight gdsFlight) {
        if (Objects.isNull(passport.getExpiredDate())) {
            passport.getValidationContext().getExpiredDateValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPassportExpired());
            return;
        }
        if (Objects.requireNonNull(FlightHelper.getFirstDepartureTime((Flight)gdsFlight)).after(DateUtils.toJavaDate((LocalDate)passport.getExpiredDate()))) {
            passport.getValidationContext().getExpiredDateValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalPassportExpired());
        }
    }

    private static boolean isInvalidCharacterInPassportNumber(RestPassport passport) {
        return passport.getNumber().chars().anyMatch(c -> AviaValidationHelper.isInvalidCharacter(c, passport.getType() == PassportType.BIRTHDAY_NOTIFICATION, CommonValidationHelper.isUa((DictionaryReference<Country>)passport.getCitizenship())));
    }

    private static boolean isInvalidCharacter(int ch, boolean isBirthDateNotification, boolean isUAPassport) {
        if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || isBirthDateNotification && ch == 32) {
            return false;
        }
        if (isUAPassport) {
            switch (ch) {
                case 1030: 
                case 1040: 
                case 1042: 
                case 1045: 
                case 1048: 
                case 1050: 
                case 1052: 
                case 1053: 
                case 1054: 
                case 1056: 
                case 1057: 
                case 1058: 
                case 1059: 
                case 1061: 
                case 1072: 
                case 1074: 
                case 1077: 
                case 1080: 
                case 1082: 
                case 1084: 
                case 1085: 
                case 1086: 
                case 1088: 
                case 1089: 
                case 1090: 
                case 1091: 
                case 1093: 
                case 1110: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private static void isValidBirthDate(Passenger passenger, Flight gdsFlight, DictionaryReference<PassengerType> passengerType, EntityContainer<SMSite> site) {
        Collection validationMessages = passenger.getValidationContext().getBirthDateValidationMessages();
        if (Objects.isNull(passenger.getBirthDate())) {
            validationMessages.add(CreateBookingParametersValidationMessages.getMissingBirthDate());
            return;
        }
        org.joda.time.LocalDate departureDate = new org.joda.time.LocalDate((Object)FlightHelper.getFirstDepartureTime((Flight)gdsFlight));
        org.joda.time.Period period = new org.joda.time.Period((ReadablePartial)passenger.getBirthDate(), (ReadablePartial)departureDate);
        int age = period.getYears();
        int ageInMonths = period.getMonths() + age * 12;
        if (age < 0 || age > 150) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalBirthDate());
            return;
        }
        if (DictHelper.isAdultPassengerType(passengerType) && age < 12) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalAdultAge());
            return;
        }
        if (DictHelper.isInfantPassengerTypeCategory(passengerType) && ageInMonths >= 24) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalInfantAge());
            return;
        }
        if (DictHelper.isChildPassengerTypeCategory(passengerType) && age > AviaValidationHelper.getMaxChildAge(site)) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalChildAge());
            return;
        }
        if (DictHelper.isYouthPassengerType(passengerType) && (age <= 12 || age >= 25)) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalYouthAge());
            return;
        }
        if (DictHelper.isSeniorPassengerType(passengerType) && age < 65) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalSeniorAge());
        }
    }

    private static void isValidBirthDate(RestPassport passport, Flight gdsFlight, DictionaryReference<PassengerType> passengerType, EntityContainer<SMSite> site) {
        Collection validationMessages = passport.getValidationContext().getBirthDateValidationMessages();
        if (Objects.isNull(passport.getBirthDate())) {
            validationMessages.add(CreateBookingParametersValidationMessages.getMissingBirthDate());
            return;
        }
        LocalDate departureDate = DateUtils.toLocalDate((Date)FlightHelper.getFirstDepartureTime((Flight)gdsFlight));
        Period period = Period.between(passport.getBirthDate(), departureDate);
        int age = period.getYears();
        int ageInMonths = period.getMonths() + age * 12;
        if (age < 0 || age > 150) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalBirthDate());
            return;
        }
        if (DictHelper.isAdultPassengerType(passengerType) && age < 12) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalAdultAge());
            return;
        }
        if (DictHelper.isInfantPassengerTypeCategory(passengerType) && ageInMonths >= 24) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalInfantAge());
            return;
        }
        if (DictHelper.isChildPassengerTypeCategory(passengerType) && age > AviaValidationHelper.getMaxChildAge(site)) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalChildAge());
            return;
        }
        if (DictHelper.isYouthPassengerType(passengerType) && (age <= 12 || age >= 25)) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalYouthAge());
            return;
        }
        if (DictHelper.isSeniorPassengerType(passengerType) && age < 65) {
            validationMessages.add(CreateBookingParametersValidationMessages.getIllegalYouthAge());
        }
    }

    private static void isValidFirstName(RestPassport passport, TransliterationType transliterationType) {
        CommonValidationHelper.isValidName(passport.getFirstName(), true, transliterationType, false, false, true, passport.getValidationContext().getFirstNameValidationMessages());
    }

    private static void isValidSecondName(RestPassport passport, TransliterationType transliterationType) {
        CommonValidationHelper.isValidName(passport.getSecondName(), false, transliterationType, false, false, true, passport.getValidationContext().getSecondNameValidationMessages());
    }

    private static void isValidLastName(RestPassport passport, TransliterationType transliterationType) {
        CommonValidationHelper.isValidName(passport.getLastName(), true, transliterationType, false, false, true, passport.getValidationContext().getLastNameValidationMessages());
    }

    private static void isValidMiddleName(RestPassport passport, TransliterationType transliterationType) {
        CommonValidationHelper.isValidName(passport.getMiddleName(), true, transliterationType, false, false, true, passport.getValidationContext().getMiddleNameValidationMessages());
    }

    public static void addValidationMessage(SearchFlightsParameters parameters, Predicate<DictionaryReference<PassengerType>> passTypeCriterion, ValidationMessage message) {
        parameters.getPassengers().keySet().stream().filter(passTypeCriterion).forEach(type -> {
            Collection cfr_ignored_0 = parameters.getValidationContext().getPassengersListValidationMessages().put(type, Collections.singletonList(message));
        });
    }

    public static void addValidationMessage(CommonSearchParameters parameters, Predicate<DictionaryReference<PassengerType>> passTypeCriterion, ValidationMessage message) {
        parameters.getPassengersTypes().keySet().stream().filter(passTypeCriterion).forEach(type -> {
            Collection cfr_ignored_0 = parameters.getValidationContext().getPassengersTypesListValidationMessages().put(type, Collections.singletonList(message));
        });
    }

    private static int getMaxChildAge(EntityContainer<SMSite> site) {
        return Objects.requireNonNull(CommonHelper.getStep1Settings((EntityReference<SMSite>)site.toReference())).isDisplayExtraChildPassengerTypes() ? 13 : 11;
    }

    public static void validateFlightNumbers(CommonSearchParameters parameters) {
        int flightNumberInd = 0;
        for (String flightNumber : parameters.getFlightNumbers()) {
            if (TextUtil.nonBlank((String)flightNumber)) {
                ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
                AviaValidationHelper.validateFlightNumber(flightNumber, messages);
                if (!messages.isEmpty()) {
                    parameters.getValidationContext().getFlightNumbersListValidationMessages().put(flightNumberInd, messages);
                }
            }
            ++flightNumberInd;
        }
    }

    private static void validateFlightNumber(String flightNumber, Collection<ValidationMessage> messages) {
        if (!(flightNumber.length() <= 2 || Character.isDigit(flightNumber.charAt(0)) && Character.isDigit(flightNumber.charAt(1)))) {
            String airlineCode = flightNumber.substring(0, 2).toUpperCase();
            Airline airline = DictHelper.findAirlineByAnyCode((String)airlineCode);
            if (airline == null) {
                messages.add(SearchFlightsParametersValidationMessages.getInvalidAirlineInFlightNumber());
            }
            flightNumber = flightNumber.substring(2);
        }
        if (!flightNumber.matches("[0-9]{1,4}")) {
            messages.add(SearchFlightsParametersValidationMessages.getInvalidFlightNumber());
        }
    }
}

