/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AircraftSeatReservationParameters;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.createBooking.AbstractCreateBookingParametersProcessor;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestSeat;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibecorp.model.rest.avia.RestAircraftSeatToken;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class BaseCreateBookingParametersConverter<T extends CreateBookingParameters>
extends AbstractCreateBookingParametersProcessor<T> {
    public void process(MessageContext ctx) throws Exception {
        CreateBookingParameters parameters = (CreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight selectedFlight = this.getSelectedFlight(parameters.getFlightToken(), ctx);
        ArrayList<Traveller> travellers = new ArrayList<Traveller>(8);
        ArrayList<GdsTraveller> gdsTravellers = new ArrayList<GdsTraveller>(8);
        for (Passenger passenger : this.getPassengers(parameters)) {
            Traveller traveller = AviaConverterHelper.convertRest2Traveler(passenger, selectedFlight);
            GdsTraveller gdsTraveller = new GdsTraveller();
            gdsTraveller.setPassengerType(passenger.getType());
            gdsTraveller.setTravellerUid(traveller.getUid());
            passenger.getSeats().stream().map(this::buildAircraftSeatReservationParameters).forEach(gdsTraveller.getSeatsReservationParameters()::add);
            long distinctSeatsParams = gdsTraveller.getSeatsReservationParameters().stream().map(AircraftSeatReservationParameters::getSegmentId).distinct().count();
            if (distinctSeatsParams < (long)gdsTraveller.getSeatsReservationParameters().size()) {
                throw Xeption.forDeveloper((String)"seats has segment duplicates", (Object[])new Object[0]);
            }
            passenger.getAncillaryFees().stream().filter(RestAncillaryFee::isSelected).map(this::buildGdsAncillaryFee).forEach(gdsTraveller.getAncillaryFees()::add);
            travellers.add(traveller);
            gdsTravellers.add(gdsTraveller);
            this.fillAdditionalData(ctx, traveller, passenger);
        }
        Customer customer = CommonConverterHelper.convertRest2Customer(parameters.getCustomer());
        GdsReservationCreationParameters aviaParameters = new GdsReservationCreationParameters();
        aviaParameters.getGdsTravellers().addAll(gdsTravellers);
        aviaParameters.setFlight(selectedFlight);
        aviaParameters.setGdsAccount(selectedFlight.getGdsAccount());
        HashSet<GdsReservationCreationParameters> reservationCreationParameters = new HashSet<GdsReservationCreationParameters>();
        reservationCreationParameters.add(aviaParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, reservationCreationParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        ctx.putObject((Enum)IBusIbecorpContextKeys.DK_NUMBER, (Object)parameters.getDkNumber());
        ctx.putObject((Enum)IBusAuthorizationContextKeys.ACCEPT_PRODUCT_DUPLICATES_MESSAGE_ID, (Object)parameters.getAcceptProductDuplicatesMessageId());
    }

    private AircraftSeatReservationParameters buildAircraftSeatReservationParameters(RestSeat restSeat) {
        RestAircraftSeatToken seatToken = B2BRestHelper.decodeToken(RestAircraftSeatToken.class, restSeat.getToken());
        AircraftSeatReservationParameters reservationParameters = new AircraftSeatReservationParameters();
        reservationParameters.setSeatNumber(seatToken.getRowNumber() + restSeat.getNumber());
        reservationParameters.setSegmentId(seatToken.getSegmentId());
        reservationParameters.getCustomProperties().addAll(seatToken.getCustomProperties());
        return reservationParameters;
    }

    private AncillaryFeeReservationParameters buildGdsAncillaryFee(RestAncillaryFee restAncillaryFee) {
        AncillaryFeeReservationParameters ancillaryFeeReservationParameters = new AncillaryFeeReservationParameters();
        ancillaryFeeReservationParameters.setGdsId(restAncillaryFee.getGdsId());
        ancillaryFeeReservationParameters.setQuantity(restAncillaryFee.getQuantity());
        ancillaryFeeReservationParameters.setFreeText(restAncillaryFee.getFreeText());
        return ancillaryFeeReservationParameters;
    }

    protected void fillAdditionalData(MessageContext ctx, Traveller traveller, Passenger passenger) {
    }

    protected Flight getSelectedFlight(String flightToken, MessageContext ctx) {
        return AviaConverterHelper.convertRestToken2Flight(flightToken);
    }
}

