/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.createBooking.AbstractCreateBookingParametersProcessor;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public abstract class BaseCreateBookingParametersValidator<T extends CreateBookingParameters>
extends AbstractCreateBookingParametersProcessor<T> {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        CreateBookingParameters parameters = (CreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight selectedFlight = this.getSelectedFlight(parameters.getFlightToken(), ctx);
        if (this.getPassengers(parameters).isEmpty()) {
            this.getPassengersValidationMessages(parameters).add(CreateBookingParametersValidationMessages.getEmptyPassengers());
        }
        ArrayList validatedPassengers = new ArrayList(10);
        selectedFlight.getSeats().stream().flatMap(sp -> Stream.iterate(sp, UnaryOperator.identity()).map(SeatPreferences::getPassengerType).limit(sp.getCount())).forEach(t -> {
            Optional<Passenger> validPassenger = this.getPassengers(parameters).stream().filter(p -> !validatedPassengers.contains(p)).findFirst();
            if (validPassenger.isPresent()) {
                AviaValidationHelper.validatePassenger(validPassenger.get(), parameters, salesContext);
                validatedPassengers.add(validPassenger.get());
            } else {
                this.getPassengersValidationMessages(parameters).add(CreateBookingParametersValidationMessages.getMissingPassenger());
            }
        });
        if (validatedPassengers.size() != selectedFlight.getSeats().stream().mapToInt(SeatPreferences::getCount).sum() && !validatedPassengers.equals(this.getPassengers(parameters))) {
            this.getPassengersValidationMessages(parameters).add(CreateBookingParametersValidationMessages.getMissingPassenger());
        }
        CommonValidationHelper.validateCustomer(parameters.getCustomer(), selectedFlight.isLatinRegistration(), CommonHelper.getGeneralSettings((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE))));
        if (!TextUtil.isBlank((String)parameters.getDkNumber()) && !AviaValidationHelper.isValidDKNumber(parameters.getDkNumber())) {
            parameters.getValidationContext().getDkNumberValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalDKNumber());
        }
        SMStep3Settings step3Settings = CommonHelper.getStep3Settings((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)));
        boolean checkIataRules = step3Settings.isDisplayIataRulesBlock();
        if (!step3Settings.isDisablePersonalDataRules() && !parameters.isAcceptSecurityRules()) {
            parameters.getValidationContext().getAcceptSecurityRulesValidationMessages().add(CreateBookingParametersValidationMessages.getSecurityRulesNotAccepted());
        }
        if (step3Settings.isDisplayRulesInOneLine()) {
            if (!parameters.isAcceptAllRules()) {
                parameters.getValidationContext().getAcceptAllRulesValidationMessages().add(CreateBookingParametersValidationMessages.getRulesNotAccepted());
            }
        } else {
            if (!parameters.isAcceptBookingRules()) {
                parameters.getValidationContext().getAcceptBookingRulesValidationMessages().add(CreateBookingParametersValidationMessages.getBookingRulesNotAccepted());
            }
            if (!parameters.isAcceptFareRemarks()) {
                parameters.getValidationContext().getAcceptFareRemarksValidationMessages().add(CreateBookingParametersValidationMessages.getFareRemarksNotAccepted());
            }
            if (checkIataRules && !parameters.isAcceptIataRules()) {
                parameters.getValidationContext().getAcceptIataRulesValidationMessages().add(CreateBookingParametersValidationMessages.getIataRulesNotAccepted());
            }
        }
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            ValidationException va = new ValidationException();
            va.setMessage(ValidationHelper.getAllValidationMessagesText((Validatable)parameters));
            throw va;
        }
    }

    protected Flight getSelectedFlight(String flightToken, MessageContext ctx) {
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        if (flight != null) {
            return flight;
        }
        flight = this.getSelectedFlight(flightToken);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
        return flight;
    }

    protected Flight getSelectedFlight(String flightToken) {
        return AviaConverterHelper.convertRestToken2Flight(flightToken);
    }

    protected abstract Collection<ValidationMessage> getPassengersValidationMessages(T var1);
}

