/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.getAirlines;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep1Settings;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GetAirlinesParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GetAirlinesResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class GetAirlinesResponseConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference site = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMStep1Settings firstStepSettings = CommonHelper.getStep1Settings((EntityReference<SMSite>)site);
        Locale locale = firstStepSettings.isNoAirlineTranslation() ? LocaleHelper.EN_LOCALE : LocaleHelper.getCurrentLocale();
        Date now = new Date();
        Collection response = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.GET_AIRLINES_RESPONSE);
        if (response == null) {
            response = Collections.EMPTY_LIST;
        }
        GetAirlinesParameters request = (GetAirlinesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Collections.sort((List)response, new AirlineComparator(request.getPattern()));
        GetAirlinesResult result = new GetAirlinesResult();
        result.getAirlines().addAll(response.stream().filter(airline -> airline.getCloseDate() == null || now.before(airline.getCloseDate())).map(airline -> AviaConverterHelper.convertAirlineReference2Rest(airline, locale)).filter(airlineRef -> airlineRef.getAirportCaption() != null).collect(Collectors.toList()));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    class AirlineComparator
    implements Comparator<Airline> {
        private final String pattern;
        private final Locale locale = LocaleHelper.getCurrentLocale();

        public AirlineComparator(String pattern) {
            this.pattern = pattern.toLowerCase();
        }

        @Override
        public int compare(Airline a1, Airline a2) {
            Collator collator = Collator.getInstance();
            String a1Name = this.getLowerCaseTranslation(a1);
            String a2Name = this.getLowerCaseTranslation(a2);
            if (this.exactPattern(a1)) {
                if (!this.exactPattern(a2)) {
                    return -1;
                }
                return collator.compare(a1Name, a2Name);
            }
            if (this.exactPattern(a2)) {
                return 1;
            }
            return collator.compare(a1Name, a2Name);
        }

        private String getLowerCaseTranslation(Airline a) {
            return Optional.ofNullable(CommonConverterHelper.findByLocale(a.getTranslations(), this.locale)).orElse("").toLowerCase(this.locale);
        }

        private boolean exactPattern(Airline a) {
            if (a.getCodeVariants() != null && a.getCodeVariants().values().stream().anyMatch(code -> this.pattern.equalsIgnoreCase((String)code))) {
                return true;
            }
            return this.pattern.equalsIgnoreCase(this.getLowerCaseTranslation(a));
        }
    }
}

