/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.getFlightInfo;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Flight;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.FlightResult;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public abstract class FlightResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        com.gridnine.xtrip.common.gds.model.Flight gdsFlight = (com.gridnine.xtrip.common.gds.model.Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        boolean showGdsAccountName = siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_AVIA);
        FlightResult result = new FlightResult();
        Flight restFlight = AviaConverterHelper.convertFlight2Rest(gdsFlight, this.getPriceConverterParameters(ctx), generalSettings, true, showGdsAccountName);
        restFlight.setInternational(AviaConverterHelper.isInternationalFlight(gdsFlight));
        result.setFlight(restFlight);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected abstract PriceComponentsParameters getPriceConverterParameters(MessageContext var1);
}

