/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.getFlightRules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GetFlightRulesParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class GetFlightRulesParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileEntityContainer;
        GetFlightRulesParameters flightRulesParameters = (GetFlightRulesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (TextUtil.isBlank((String)flightRulesParameters.getRulesToken())) {
            throw Xeption.forDeveloper((String)"rulesToken is empty", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FARE_REMARKS_SEARCH_CONTEXT, (Object)flightRulesParameters.getRulesToken());
        if (flightRulesParameters.getToken() != null) {
            Flight flight = this.getFlightFromRestToken(flightRulesParameters.getToken());
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
            return;
        }
        if (flightRulesParameters.getBookingFile() != null && (bookingFileEntityContainer = EntityStorage.get().resolve(flightRulesParameters.getBookingFile())) != null) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, (Object)bookingFileEntityContainer);
            Reservation reservation = null;
            reservation = TextUtil.nonBlank((String)flightRulesParameters.getReservationUid()) ? BookingHelper.findReservationByUid((BookingFile)((BookingFile)bookingFileEntityContainer.getEntity()), (String)flightRulesParameters.getReservationUid()) : AirProductHelper.getAviaReservation((EntityContainer)bookingFileEntityContainer);
            if (reservation != null) {
                if (reservation.getStatus() == ReservationStatus.INTENTION) {
                    ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)reservation.getIntentionData().getAviaData().getFlight());
                } else {
                    ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
                }
            }
        }
    }

    protected Flight getFlightFromRestToken(String token) throws Exception {
        return AviaConverterHelper.convertRestToken2Flight(token);
    }
}

