/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.getFlightRules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CarrierRule;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GetFlightRulesResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;

public class GetFlightRulesResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection rules = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FARE_RULES);
        GetFlightRulesResult result = new GetFlightRulesResult();
        rules.forEach(fr -> {
            EntityContainer gdsAccountCtr;
            CarrierRule rule = new CarrierRule();
            rule.setNumber(fr.getNumber());
            rule.setTitle(fr.getTitle());
            rule.setText(fr.getContent());
            if (flight != null) {
                rule.setGdsName(flight.getGds().name());
            }
            if (reservation != null && (gdsAccountCtr = EntityStorage.get().resolve(reservation.getGdsNameInfo().getOnlineGdsAccount())) != null) {
                rule.setGdsName(((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds().name());
            }
            result.getRules().add(rule);
        });
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

