/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.getLocations;

import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.model.GetAviaLocationsRequest;
import com.gridnine.xtrip.common.gds.rules.Actions;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.profile.RulesHolderIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class GetAviaLocationsProcessor
extends BaseProcessor {
    private static final int LIMIT = 10;
    private static final List<Class<? extends BaseAirGdsAccount>> ACCOUNT_CLASSES_WITH_CRT = Arrays.asList(SirenaGdsAccount.class, MixvelGdsAccount.class);
    private static final String KEY_SEPARATOR = String.valueOf('\u001f');

    public void process(MessageContext ctx) throws Exception {
        int limit;
        GetAviaLocationsRequest request = (GetAviaLocationsRequest)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GET_AVIA_LOCATIONS_REQUEST);
        Locale locale = LocaleManager.get().getCurrentLocale();
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 1000) {
                throw Xeption.forDeveloper((String)"limit > 1000", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        } else {
            limit = 10;
            request.setLimit(Integer.valueOf(limit));
            ctx.addMessage(MessageHelper.createWarningMessage((String)"\u043b\u0438\u043c\u0438\u0442 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: '{0}'", (Object[])new Object[]{10}));
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        List<List<GeoLocation>> groupedResult = this.getGroupedResult(TextUtil.nonNullStr((String)request.getPattern()), locale, request.getSkipped(), messages);
        ctx.addMessages(messages);
        List rulesIndices = EntityStorage.get().search(RulesHolderIndex.class, new SearchQuery()).getData();
        boolean withCrt = rulesIndices.stream().map(rulesIndex -> (RulesHolder)EntityStorage.get().resolve(rulesIndex.getSource()).getEntity()).filter(Objects::nonNull).map(RulesHolder::getRuleSet).filter(Objects::nonNull).flatMap(ruleSet -> ruleSet.getRules().stream()).filter(rs -> rs.getTarget() != null).filter(rs -> rs.getTarget().getId().equals(Targets.GDS_PARAMETERS.getId())).flatMap(rs -> rs.getResults().stream()).filter(Objects::nonNull).filter(ruleResult -> ruleResult.getAction() == Actions.APPLICABLE_GDS_ACCOUNTS).map(RuleResult::getValue).filter(Objects::nonNull).map(ruleValue -> (Collection)ruleValue).flatMap(Collection::stream).filter(Objects::nonNull).anyMatch(gdsAccount -> ACCOUNT_CLASSES_WITH_CRT.contains(gdsAccount.getType()));
        List<GeoLocation> result = this.getResult(groupedResult, request.getPattern(), limit, withCrt, locale);
        ctx.putObject((Enum)IBusGdsContextKeys.GET_AVIA_LOCATIONS_RESPONSE, result);
    }

    protected List<List<GeoLocation>> getGroupedResult(String pattern, Locale locale, Set<String> skipped, List<Message> messages) {
        HashMap resultGroupedByCities = new HashMap();
        HashMap<String, GeoLocation> airports = new HashMap<String, GeoLocation>();
        HashMap<String, GeoLocation> cities = new HashMap<String, GeoLocation>();
        HashSet searchResult = new HashSet();
        searchResult.addAll(DictionaryCache.get().search(GeoLocation.class, pattern.toLowerCase(locale)));
        searchResult.addAll(DictionaryCache.get().lookup(GeoLocation.class, pattern, new String[0]));
        searchResult.addAll(DictionaryCache.get().lookup(GeoLocation.class, pattern.toUpperCase(locale), new String[0]));
        HashSet countrySearchResult = new HashSet();
        countrySearchResult.addAll(DictionaryCache.get().search(Country.class, pattern.toLowerCase(locale)));
        countrySearchResult.addAll(DictionaryCache.get().lookup(Country.class, pattern.toUpperCase(locale), new String[0]));
        Iterator iterator = countrySearchResult.iterator();
        while (iterator.hasNext()) {
            Country country = (Country)iterator.next();
            searchResult.addAll(DictionaryCache.get().search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.country.name(), (Object)country.toReference())));
        }
        for (GeoLocation location : searchResult) {
            if (!skipped.isEmpty() && skipped.containsAll(location.getCodeVariants().keySet())) continue;
            if (location.getType() == LocationType.AIRPORT) {
                airports.put(location.getCode(), location);
                continue;
            }
            if (location.getType() != LocationType.CITY) continue;
            cities.put(location.getCode(), location);
            DictionaryCache.get().search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.parent.name(), (Object)location.toReference())).stream().filter(child -> child.getType() == LocationType.AIRPORT).forEach(child -> airports.put(child.getCode(), (GeoLocation)child));
        }
        for (Map.Entry cityEntry : cities.entrySet()) {
            String cityCode = (String)cityEntry.getKey();
            if (!resultGroupedByCities.containsKey(cityCode)) {
                resultGroupedByCities.put(cityCode, new LinkedList());
            }
            ((List)resultGroupedByCities.get(cityCode)).add(cityEntry.getValue());
        }
        for (Map.Entry airportEntry : airports.entrySet()) {
            List airportGroup;
            DictionaryReference airportParentRef = ((GeoLocation)airportEntry.getValue()).getParent();
            if (airportParentRef == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0410\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c '{0}' \u0431\u044b\u043b \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0443 \u043d\u0435\u0433\u043e \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c", (Object[])new Object[]{airportEntry.getKey()}));
                continue;
            }
            GeoLocation airportParent = (GeoLocation)DictionaryCache.get().resolveReference(airportParentRef);
            if (airportParent == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0410\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c '{0}' \u0431\u044b\u043b \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0435\u0433\u043e \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", (Object[])new Object[]{airportEntry.getKey()}));
                continue;
            }
            if (resultGroupedByCities.containsKey(airportParent.getCode())) {
                airportGroup = (List)resultGroupedByCities.get(airportParent.getCode());
            } else {
                airportGroup = new ArrayList(1);
                resultGroupedByCities.put((String)airportEntry.getKey(), airportGroup);
            }
            airportGroup.add(airportEntry.getValue());
        }
        return new ArrayList<List<GeoLocation>>(resultGroupedByCities.values());
    }

    protected List<GeoLocation> getResult(List<List<GeoLocation>> groupedResult, String pattern, int limit, boolean withCrt, Locale locale) {
        ArrayList<GeoLocation> result = new ArrayList<GeoLocation>();
        TreeMap<String, List<GeoLocation>> groupedMap = new TreeMap<String, List<GeoLocation>>();
        for (List<GeoLocation> list : groupedResult) {
            groupedMap.put(this.calcGroupKey(list, pattern, locale), list);
        }
        block1: for (List<Object> list : groupedMap.values()) {
            list.removeIf(location -> location.getType() == LocationType.CITY && DictionaryCache.get().search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.parent.name(), (Object)location.toReference())).size() <= 1);
            TreeMap<String, GeoLocation> geoLocationMap = new TreeMap<String, GeoLocation>();
            for (GeoLocation geoLocation : list) {
                geoLocationMap.put(this.calcGeoLocationKey(geoLocation, pattern, locale, true), geoLocation);
            }
            for (GeoLocation geoLocation : geoLocationMap.values()) {
                if (!geoLocation.getCodeVariants().containsKey(CodeSystem.IATA.name()) && (!withCrt || !geoLocation.getCodeVariants().containsKey(CodeSystem.CRT.name()))) continue;
                result.add(geoLocation);
                if (result.size() != limit) continue;
                break block1;
            }
        }
        return result;
    }

    private String calcGroupKey(List<GeoLocation> group, String pattern, Locale locale) {
        GeoLocation leader = this.getLeader(group, pattern);
        return this.calcGeoLocationKey(leader, pattern, locale, false);
    }

    private String calcGeoLocationKey(GeoLocation gl, String pattern, Locale locale, boolean cityFirst) {
        StringBuilder sb = new StringBuilder();
        int patternPosition = GDSHelper.getPatternPosition((GeoLocation)gl, (String)pattern, (Locale)locale);
        String lowerPattern = pattern.toLowerCase(locale);
        boolean hasCodeAsPattern = gl.getCodeVariants().values().stream().filter(TextUtil::nonBlank).map(String::toLowerCase).anyMatch(code -> code.equals(lowerPattern));
        sb.append(hasCodeAsPattern ? "0" : "1");
        sb.append(KEY_SEPARATOR);
        sb.append(!cityFirst || gl.getType() == LocationType.CITY ? "0" : "1");
        sb.append(KEY_SEPARATOR);
        sb.append(String.format("%04d", patternPosition));
        sb.append(KEY_SEPARATOR);
        sb.append(Integer.MAX_VALUE - gl.getWeight());
        sb.append(KEY_SEPARATOR);
        String name = (String)MiscUtil.findByLocale((Map)gl.getTranslations(), (Locale)locale);
        if (name != null) {
            sb.append((String)MiscUtil.findByLocale((Map)gl.getTranslations(), (Locale)locale));
        }
        sb.append(KEY_SEPARATOR);
        sb.append(gl.getCode());
        return sb.toString();
    }

    private GeoLocation getLeader(List<GeoLocation> group, String pattern) {
        if (group.size() == 1) {
            return group.get(0);
        }
        for (GeoLocation member : group) {
            if (member.getType() != LocationType.CITY) continue;
            return member;
        }
        throw new IllegalStateException(String.format("location group had more than 1 member but no city, pattern=\"%s\", group=%s", pattern, group));
    }
}

