/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchDupes;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchDupes.SearchDupesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Iterator;

public class CheckStrictAndReplaceActualizedSegmentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation actualizedReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        this.log.info(String.format("Processing actualized bookings [%s], Checking valid segments and products match", ((BookingFile)bookingFile.getEntity()).getNumber()));
        if (AviaHelper.hasInvalidSegments(actualizedReservation) || !SearchDupesHelper.isSameProducts(AirProductHelper.getAirProductsList((Reservation)AirProductHelper.getAviaReservation((EntityContainer)bookingFile)), AirProductHelper.getAirProductsList((Reservation)actualizedReservation))) {
            this.log.info(String.format("Actualized booking [%s] is not valid. Skipping", ((BookingFile)bookingFile.getEntity()).getNumber()));
            return;
        }
        Iterator oldProductsIt = AirProductHelper.getAirProductsStream((Reservation)AirProductHelper.getAviaReservation((EntityContainer)bookingFile)).iterator();
        Iterator newProductIt = AirProductHelper.getAirProductsStream((Reservation)actualizedReservation).iterator();
        while (oldProductsIt.hasNext()) {
            Product oldProduct = (Product)oldProductsIt.next();
            oldProduct.getSegmentTariffs().clear();
            oldProduct.getSegmentTariffs().addAll(((Product)newProductIt.next()).getSegmentTariffs());
        }
        Customer customer = (Customer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        BookingHelper.copyCustomer((Customer)((BookingFile)bookingFile.getEntity()).getCustomer(), (Customer)customer);
        bookingFile.getVersionInfo().setDataSource("actualized segments");
        EntityStorage.get().save(bookingFile, true);
        this.log.info(String.format("Booking [%s] successfully actualized", ((BookingFile)bookingFile.getEntity()).getNumber()));
        ctx.putObject((Enum)IBusIbecorpContextKeys.STRICT_DUPE, (Object)bookingFile);
    }
}

