/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchDupes;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchDupes.SearchDupesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class FindOneDayDupeProcessor
extends BaseProcessor {
    private static boolean isOneDayDupe(Product product, Flight flight) {
        if (!flight.getCarrier().getCode().equals(product.getCarrier().getCode())) {
            return false;
        }
        GeoLocation departure = null;
        GeoLocation arrival = null;
        ArrayList<Pair> productLegsLocations = new ArrayList<Pair>();
        List productSegmentsList = AirProductHelper.getProductSegmentsList((Product)product);
        if (!productSegmentsList.isEmpty()) {
            for (Object s : productSegmentsList) {
                if (s.isStarting()) {
                    if (Objects.nonNull(departure)) {
                        productLegsLocations.add(new Pair((Object)departure, (Object)arrival));
                    }
                    departure = DictHelper.findCityByAirport((String)s.getDepartureLocation().getCode());
                }
                arrival = DictHelper.findCityByAirport((String)s.getArriveLocation().getCode());
            }
            productLegsLocations.add(new Pair(departure, arrival));
        }
        departure = null;
        arrival = null;
        ArrayList<Pair> flightLegsLocations = new ArrayList<Pair>();
        for (FlightSegment flightSegment : FlightHelper.getFlightSegmentsList((Flight)flight)) {
            if (flightSegment.isStarting()) {
                if (Objects.nonNull(departure)) {
                    flightLegsLocations.add(new Pair((Object)departure, (Object)arrival));
                }
                departure = DictHelper.findCityByAirport((String)flightSegment.getLocationBegin().getCode());
            }
            arrival = DictHelper.findCityByAirport((String)flightSegment.getLocationEnd().getCode());
        }
        flightLegsLocations.add(new Pair((Object)departure, (Object)arrival));
        if (productLegsLocations.size() != flightLegsLocations.size()) {
            return false;
        }
        Iterator productLegsLocationsIt = productLegsLocations.iterator();
        for (Pair flightLegLocations : flightLegsLocations) {
            Pair productLegLocations = (Pair)productLegsLocationsIt.next();
            if (((GeoLocation)flightLegLocations.getFirst()).getCode().equals(((GeoLocation)productLegLocations.getFirst()).getCode()) && ((GeoLocation)flightLegLocations.getLast()).getCode().equals(((GeoLocation)productLegLocations.getLast()).getCode())) continue;
            return false;
        }
        return FlightHelper.getFlightSegmentsStream((Flight)flight).filter(FlightSegment::isStarting).anyMatch(fs -> {
            LocalDate flightDepartureDate = new LocalDate((Object)fs.getDateBegin());
            LocalDate minusOneDay = flightDepartureDate.minusDays(1);
            LocalDate plusOneDay = flightDepartureDate.plusDays(1);
            return AirProductHelper.getProductSegmentsStream((Product)product).filter(Segment::isStarting).anyMatch(s -> {
                LocalDate productDepartureDate = new LocalDate((Object)s.getStartDate());
                return (productDepartureDate.isAfter((ReadablePartial)minusOneDay) || productDepartureDate.compareTo((ReadablePartial)minusOneDay) == 0) && productDepartureDate.isBefore((ReadablePartial)plusOneDay) || productDepartureDate.compareTo((ReadablePartial)plusOneDay) == 0;
            });
        });
    }

    public void process(MessageContext ctx) throws Exception {
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Collection reservationCreationParameters = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
        GdsReservationCreationParameters gdsReservationCreationParameters = AviaHelper.getReservationCreationParameters(reservationCreationParameters);
        Flight selectedFlight = gdsReservationCreationParameters.getFlight();
        List gdsTravellers = gdsReservationCreationParameters.getGdsTravellers();
        List possibleDupes = (List)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.POSSIBLE_DUPES);
        this.log.info(String.format("Starting search for possible one day dupe for flight [%s], site [%s], agency [%s], subagency [%s] and travellers [%s] in possible dupes [%d]", FlightHelper.buildFlightNumbersString((Flight)selectedFlight), siteRef, sc.getAgency(), sc.getSubagency(), CommonHelper.getElementsCaptionJoin(travellers, Traveller::getName), possibleDupes.size()));
        possibleDupes.stream().map(SearchDupesHelper::resolveBookingEntityOrSkip).filter(this.findValidBooking(travellers, selectedFlight, gdsTravellers)).findFirst().ifPresent(bf -> {
            this.log.info(String.format("Found one day dupe [%s] for selected flight [%s]. Actualizing", ((BookingFile)bf.getEntity()).getNumber(), FlightHelper.buildFlightNumbersString((Flight)selectedFlight)));
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, bf);
            ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_UID, (Object)AirProductHelper.getAviaReservation((EntityContainer)bf).getUid());
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)selectedFlight);
        });
    }

    public Predicate<EntityContainer<BookingFile>> findValidBooking(List<Traveller> travellers, Flight selectedFlight, List<GdsTraveller> gdsTravellers) {
        return bf -> {
            boolean productsMatchFlight;
            Reservation reservation = AirProductHelper.getAviaReservation((EntityContainer)bf);
            if (!SearchDupesHelper.isSameTravellers(travellers, ((BookingFile)bf.getEntity()).getTravellers())) {
                this.log.info(String.format("Mismatch travellers for booking [%s]. Skipping", ((BookingFile)bf.getEntity()).getNumber()));
                return false;
            }
            boolean isValidTravelersWithType = SearchDupesHelper.isAllTravellersMatchWithSameType(AirProductHelper.getAirProductsStream((Reservation)reservation).collect(Collectors.toList()), gdsTravellers, travellers);
            if (!isValidTravelersWithType) {
                this.log.info(String.format("Travellers doesnt matsh type for booking [%s]", ((BookingFile)bf.getEntity()).getNumber()));
            }
            if (!(productsMatchFlight = AirProductHelper.getAirProductsStream((Reservation)reservation).allMatch(p -> FindOneDayDupeProcessor.isOneDayDupe(p, selectedFlight)))) {
                this.log.info(String.format("Products of booking [%s] doesnt match selected flight", ((BookingFile)bf.getEntity()).getNumber()));
            }
            return isValidTravelersWithType && productsMatchFlight;
        };
    }
}

