/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchDupes;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchDupes.SearchDupesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FindStrictDupeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Collection reservationCreationParameters = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
        GdsReservationCreationParameters gdsReservationCreationParameters = AviaHelper.getReservationCreationParameters(reservationCreationParameters);
        Flight selectedFlight = gdsReservationCreationParameters.getFlight();
        List gdsTravellers = gdsReservationCreationParameters.getGdsTravellers();
        List possibleDupes = (List)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.POSSIBLE_DUPES);
        this.log.info(String.format("Starting search for possible strict for flight [%s], site [%s], agency [%s], subagency [%s] and travellers [%s] in possible dupes [%d]", FlightHelper.buildFlightNumbersString((Flight)selectedFlight), siteRef, sc.getAgency(), sc.getSubagency(), CommonHelper.getElementsCaptionJoin(travellers, Traveller::getName), possibleDupes.size()));
        possibleDupes.stream().map(SearchDupesHelper::resolveBookingEntityOrSkip).filter(this.findValidBookings(travellers, selectedFlight, gdsTravellers)).findFirst().ifPresent(bf -> {
            this.log.info(String.format("Found strict dupe [%s] for selected flight [%s]. Actualizing", ((BookingFile)bf.getEntity()).getNumber(), FlightHelper.buildFlightNumbersString((Flight)selectedFlight)));
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, bf);
            ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_UID, (Object)AirProductHelper.getAviaReservation((EntityContainer)bf).getUid());
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)selectedFlight);
        });
    }

    private Predicate<EntityContainer<BookingFile>> findValidBookings(List<Traveller> travellers, Flight selectedFlight, List<GdsTraveller> gdsTravellers) {
        return bf -> {
            boolean productsMatchFlight;
            if (!SearchDupesHelper.isSameTravellers(travellers, ((BookingFile)bf.getEntity()).getTravellers())) {
                this.log.info(String.format("Mismatch travellers for booking [%s]. Skipping", ((BookingFile)bf.getEntity()).getNumber()));
                return false;
            }
            Reservation reservation = AirProductHelper.getAviaReservation((EntityContainer)bf);
            boolean isValidTravelersWithType = SearchDupesHelper.isAllTravellersMatchWithSameType(AirProductHelper.getAirProductsStream((Reservation)reservation).collect(Collectors.toList()), gdsTravellers, travellers);
            if (!isValidTravelersWithType) {
                this.log.info(String.format("Travellers doesnt matsh type for booking [%s]", ((BookingFile)bf.getEntity()).getNumber()));
            }
            if (!(productsMatchFlight = AirProductHelper.getAirProductsStream((Reservation)reservation).allMatch(p -> SearchDupesHelper.isFlightMatchesProduct(selectedFlight, p)))) {
                this.log.info(String.format("Products of booking [%s] doesnt match selected flight [%s]", ((BookingFile)bf.getEntity()).getNumber(), FlightHelper.buildFlightNumbersString((Flight)selectedFlight)));
            }
            return isValidTravelersWithType && productsMatchFlight;
        };
    }
}

