/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchDupes;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchDupesHelper {
    private static Logger log = LoggerFactory.getLogger(SearchDupesHelper.class);

    private SearchDupesHelper() {
    }

    static boolean isSameTravellers(List<Traveller> travellers1, List<Traveller> travellers2) {
        if (travellers1.size() != travellers2.size()) {
            return false;
        }
        ArrayList matchedTravellers = new ArrayList(10);
        travellers1.stream().forEach(t1 -> travellers2.stream().filter(t2 -> SearchDupesHelper.isSameTraveller(t1, t2) && !matchedTravellers.contains(t2)).findFirst().ifPresent(matchedTravellers::add));
        return matchedTravellers.size() == travellers1.size();
    }

    public static boolean isSameTraveller(Traveller traveller1, Traveller traveller2) {
        Passport p1 = traveller1.getPassport();
        Passport p2 = traveller2.getPassport();
        return p1.getFirstName().equals(p2.getFirstName()) && p1.getLastName().equals(p2.getLastName()) && p1.getGender() == p2.getGender();
    }

    static boolean isFlightMatchesProduct(Flight flight, Product product) {
        if (!flight.getCarrier().getCode().equals(product.getCarrier().getCode())) {
            return false;
        }
        if (flight.getSegmentTariffs().size() != product.getSegmentTariffs().size()) {
            return false;
        }
        Iterator flightSegmenttariffs = flight.getSegmentTariffs().iterator();
        Iterator productSegmentTariffs = product.getSegmentTariffs().iterator();
        while (flightSegmenttariffs.hasNext()) {
            if (SearchDupesHelper.isFlightSTFitToProductST((FlightSegmentTariff)flightSegmenttariffs.next(), (SegmentTariff)productSegmentTariffs.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isFlightSTFitToProductST(FlightSegmentTariff flightSegmentTariff, SegmentTariff productSegmentTariffs) {
        if (flightSegmentTariff.getSegments().size() != productSegmentTariffs.getSegments().size()) {
            return false;
        }
        Iterator flightSegments = flightSegmentTariff.getSegments().iterator();
        Iterator productSegments = productSegmentTariffs.getSegments().iterator();
        while (flightSegments.hasNext()) {
            if (SearchDupesHelper.isFlightSegmentFitToProductSegment((FlightSegment)flightSegments.next(), (Segment)productSegments.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isFlightSegmentFitToProductSegment(FlightSegment fs, Segment s) {
        if (!fs.getAirline().getCode().equals(s.getAirline().getCode())) {
            return false;
        }
        if (!fs.getLocationBegin().getCode().equals(s.getDepartureLocation().getCode())) {
            return false;
        }
        if (!fs.getLocationEnd().getCode().equals(s.getArriveLocation().getCode())) {
            return false;
        }
        if (!fs.getFlightNumber().equals(s.getFlightNo())) {
            return false;
        }
        if (!fs.getDateBegin().equals(s.getStartDate())) {
            return false;
        }
        return fs.getDateEnd().equals(s.getEndDate());
    }

    static boolean isSameProducts(List<Product> products1, List<Product> products2) {
        if (products1.size() != products2.size()) {
            return false;
        }
        Iterator<Product> pI1 = products1.iterator();
        Iterator<Product> pI2 = products2.iterator();
        while (pI1.hasNext()) {
            if (SearchDupesHelper.isSameProduct(pI1.next(), pI2.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameProduct(Product product1, Product product2) {
        if (!product1.getCarrier().getCode().equals(product2.getCarrier().getCode())) {
            return false;
        }
        if (product1.getSegmentTariffs().size() != product2.getSegmentTariffs().size()) {
            return false;
        }
        Iterator segmentTariffs1 = product1.getSegmentTariffs().iterator();
        Iterator segmentTariffs2 = product2.getSegmentTariffs().iterator();
        while (segmentTariffs1.hasNext()) {
            if (SearchDupesHelper.isSameProductSegmentTariffs((SegmentTariff)segmentTariffs1.next(), (SegmentTariff)segmentTariffs2.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameProductSegmentTariffs(SegmentTariff segmentTariff1, SegmentTariff segmentTariff2) {
        if (segmentTariff1.getSegments().size() != segmentTariff2.getSegments().size()) {
            return false;
        }
        Iterator segments1 = segmentTariff1.getSegments().iterator();
        Iterator segments2 = segmentTariff2.getSegments().iterator();
        while (segments1.hasNext()) {
            if (AviaHelper.isSameProductSegment((Segment)segments1.next(), (Segment)segments2.next())) continue;
            return false;
        }
        return true;
    }

    static EntityContainer<BookingFile> resolveBookingEntityOrSkip(EntityReference<BookingFile> bookingFileRef) {
        try {
            return EntityStorage.get().resolve(bookingFileRef);
        }
        catch (Exception e) {
            log.error(String.format("Unable to load a booking [%s], skipping", bookingFileRef.getUid()));
            return null;
        }
    }

    static boolean isAllTravellersMatchWithSameType(List<Product> products, List<GdsTraveller> gdsTravellers, List<Traveller> travellers) {
        ArrayList matchedTravellers = new ArrayList(10);
        products.stream().forEach(e -> travellers.stream().filter(t -> SearchDupesHelper.isSameTraveller(e.getTraveller(), t) && SearchDupesHelper.hasSameTravellerType(gdsTravellers, (DictionaryReference<PassengerType>)e.getPassengerType(), t) && !matchedTravellers.contains(t)).findFirst().ifPresent(matchedTravellers::add));
        return matchedTravellers.size() == travellers.size();
    }

    private static boolean hasSameTravellerType(List<GdsTraveller> gdsTravellers, DictionaryReference<PassengerType> e, Traveller t) {
        return gdsTravellers.stream().filter(gt -> gt.getTravellerUid().equals(t.getUid())).findFirst().get().getPassengerType().equals(e);
    }
}

