/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchDupes;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SearchPossibleDupesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Collection reservationCreationParameters = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
        GdsReservationCreationParameters gdsReservationCreationParameters = AviaHelper.getReservationCreationParameters(reservationCreationParameters);
        ctx.putObject((Enum)IBusIbecorpContextKeys.POSSIBLE_DUPES, Collections.emptyList());
        Flight selectedFlight = gdsReservationCreationParameters.getFlight();
        this.log.info(String.format("Starting search for possible actual bookings for flight [%s], site [%s], agency [%s], subagency [%s] and travellers", FlightHelper.buildFlightNumbersString((Flight)selectedFlight), siteRef, sc.getAgency(), sc.getSubagency(), CommonHelper.getElementsCaptionJoin(travellers, Traveller::getName)));
        long legsCount = FlightHelper.getFlightSegmentsStream((Flight)selectedFlight).filter(FlightSegment::isStarting).count();
        if (legsCount > 2L) {
            this.log.info(String.format("Flight [%s] has multistop route. Skipping", FlightHelper.buildFlightNumbersString((Flight)selectedFlight)));
            return;
        }
        SearchResult<BookingFileIndex> searchResult = this.buildQuery(sc, travellers, (EntityReference<SMSite>)siteRef);
        List possibleDupes = searchResult.getData().stream().map(bfi -> bfi.getSource()).collect(Collectors.toList());
        ctx.putObject((Enum)IBusIbecorpContextKeys.POSSIBLE_DUPES, possibleDupes);
        this.log.info(String.format("Found possible dupes [%d]", possibleDupes.size()));
    }

    private SearchResult<BookingFileIndex> buildQuery(SalesContext sc, List<Traveller> travellers, EntityReference<SMSite> siteRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.site.name(), siteRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), (Object)sc.getAgency()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.subagency.name(), (Object)sc.getSubagency()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.firstTraveller.name(), (Object)travellers.get(0).getName()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.in((String)BookingFileIndex.Property.workflowStatus.name(), (Object[])new Object[]{WorkflowStatus.BOOKING, WorkflowStatus.TO_BE_PAYED}), SearchCriterion.contains((String)BookingFileIndex.Property.reservationStatuses.name(), (Object)ReservationStatus.BOOKING)}));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BookingFileIndex.Property.productStatuses.name(), (Object)ProductStatus.BOOKING));
        SearchResult searchResult = EntityStorage.get().search(BookingFileIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        return searchResult;
    }
}

