/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchFlights;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsResult;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class SearchFlightsResultConverter
extends BaseProcessor {
    private static final DateTimeFormatter TF = DateTimeFormatter.ofPattern("HH:mm");

    public void process(MessageContext ctx) throws Exception {
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Collection gdsFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PriceDisplayStyle displayStyle = CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef).getPriceDisplayStyle();
        SearchFlightsResult result = new SearchFlightsResult();
        PriceComponentsParameters componentsParameters = this.getPriceConverterParameters(ctx);
        Map<String, ExchangeRateData> currencyExchangeRateDataMap = CommonConverterHelper.getCurrencyExchangeRateDataMap(gdsFlights, salesContext);
        gdsFlights.stream().filter(flight -> flight.getCarrier() != null).forEach(flight -> {
            try {
                AviaConverterHelper.addFlightToBestPrices(flight, result.getBestPrices(), AviaPriceComponents.builder(flight, componentsParameters).build(), currencyExchangeRateDataMap);
            }
            catch (Exception e) {
                IncidentsHelper.addStackTraceElement((Throwable)e, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"GdsAccount", (String)flight.getGds().toString()), IncidentsHelper.getContextStackTraceElement((String)"Flight", (String)FlightHelper.toIdentifiableString((Flight)flight))});
                throw e;
            }
        });
        result.getBestPrices().forEach((key, value) -> value.getBestFlights().sort((bf1, bf2) -> CommonConverterHelper.MONEY_COMPARATOR.compare(bf1.getSortedPrice(), bf2.getSortedPrice())));
        this.convertGdsFlights(ctx, gdsFlights, componentsParameters, displayStyle, result, currencyExchangeRateDataMap);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected void convertGdsFlights(MessageContext ctx, Collection<Flight> gdsFlights, PriceComponentsParameters componentsParameters, PriceDisplayStyle displayStyle, SearchFlightsResult result, Map<String, ExchangeRateData> currencyExchangeRateDataMap) throws Exception {
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        boolean showGdsAccountName = siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_AVIA);
        SMStep2Settings step2Settings = CommonHelper.getStep2Settings((EntityReference<SMSite>)componentsParameters.getSalesContext().getSite());
        for (Flight flight : gdsFlights) {
            if (flight.getCarrier() != null) {
                result.getFlights().add(AviaConverterHelper.convertFlightSearchItem2Rest(flight, componentsParameters, displayStyle, false, showGdsAccountName, step2Settings, currencyExchangeRateDataMap));
                continue;
            }
            this.log.warn(this.noValidatingCarrierWarning(flight));
        }
    }

    protected abstract PriceComponentsParameters getPriceConverterParameters(MessageContext var1);

    protected String noValidatingCarrierWarning(Flight flight) {
        StringBuilder builder = new StringBuilder("No validating carrier for the flight:");
        List segments = FlightHelper.getSegments((Flight)flight);
        int segmentNumber = 0;
        for (FlightSegment segment : segments) {
            builder.append("\n").append("segment").append(++segmentNumber).append("(").append(segment.getLocationBegin().getCode()).append("->").append(segment.getLocationEnd().getCode()).append(")  departureTime: ").append(TF.format(MiscUtil.toLocalTime((Date)segment.getDateBegin()))).append(" arrivalTime: ").append(TF.format(MiscUtil.toLocalTime((Date)segment.getDateEnd()))).append(" flightNumber: ").append(segment.getFlightNumber());
        }
        return builder.toString();
    }
}

