/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.searchMatrixFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.MatrixDepartures;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.MatrixFlightWithGap;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchMatrixFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchMatrixFlightsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SearchMatrixFlightsResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchMatrixFlightsParameters parameters = (SearchMatrixFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchMatrixFlightsResult result = new SearchMatrixFlightsResult();
        Collection gdsFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        HashMap<String, Map<String, MatrixFlightWithGap>> matrix = new HashMap<String, Map<String, MatrixFlightWithGap>>();
        gdsFlights.stream().filter(flight -> flight.getCarrier() != null).forEach(flight -> AviaConverterHelper.addFlightToMatrix(flight, matrix, AviaPriceComponents.builder(flight, PriceComponentsParameters.getBriefInfoParameters(salesContext)).build(), AviaConverterHelper.getRequestedMatrixDates(parameters), CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef).getPriceDisplayStyle()));
        byte cheapestItemsNumber = parameters.getRouteType() == RouteType.ROUNDTRIP ? (byte)5 : 2;
        AviaConverterHelper.setCheapestFlight(matrix, cheapestItemsNumber);
        matrix.entrySet().forEach(toDate -> {
            MatrixDepartures departuresFrom = new MatrixDepartures();
            ((Map)toDate.getValue()).entrySet().forEach(fromDate -> departuresFrom.getFrom().put(fromDate.getKey(), fromDate.getValue()));
            result.getTo().put(toDate.getKey(), departuresFrom);
        });
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

