/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.avia.selectFlight;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.FlightParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SelectFlightResult;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Iterator;
import java.util.List;

public abstract class SelectFlightResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightParameters parameters = (FlightParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight oldFlight = AviaConverterHelper.convertRestToken2Flight(parameters.getFlightToken());
        Flight selectedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        SelectFlightResult result = new SelectFlightResult();
        boolean showGdsAccountName = siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_AVIA);
        com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Flight restFlight = AviaConverterHelper.convertFlight2Rest(selectedFlight, this.getPriceConverterParameters(ctx), generalSettings, true, showGdsAccountName);
        restFlight.setInternational(AviaConverterHelper.isInternationalFlight(selectedFlight));
        result.setFlight(restFlight);
        result.setFlightToken(B2BRestHelper.encodeToken((XSSerializable)selectedFlight));
        result.setSegmentsChanged(this.isSegmentsChanged(oldFlight, selectedFlight));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected boolean isSegmentsChanged(Flight oldFlight, Flight selectedFlight) {
        if (oldFlight == null) {
            return false;
        }
        List oldSegments = FlightHelper.getFlightSegmentsList((Flight)oldFlight);
        List newSegments = FlightHelper.getFlightSegmentsList((Flight)selectedFlight);
        if (oldSegments.size() != newSegments.size()) {
            return true;
        }
        Iterator oldIterator = oldSegments.iterator();
        for (FlightSegment newSegment : newSegments) {
            FlightSegment oldSegment = (FlightSegment)oldIterator.next();
            if (oldSegment.getDateBegin().compareTo(newSegment.getDateBegin()) == 0) continue;
            return true;
        }
        return false;
    }

    protected abstract PriceComponentsParameters getPriceConverterParameters(MessageContext var1);
}

