/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2c.B2CInitiatePaymentHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.TextPatternHelperEngine;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.BookingPaymentHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Money;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.BookingInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.InitiatePaymentInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.PaymentTypeInfo;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class BookingConverterHelper {
    public static BookingInfo convertBookingInfo2rest(ReservationStatus status, String message, String uid) {
        BookingInfo result = new BookingInfo();
        result.setStatus(status);
        result.setMessage(message);
        result.setBookingUid(uid);
        return result;
    }

    public static PaymentTypeInfo convertPaymentTypeInfo2Rest(Map.Entry<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> paymentTypeInfo, BigDecimal totalPrice, String currency, Set<CardVendor> splitCardsSupportedVendors, Set<CardVendor> supportedCardVendors) {
        PaymentTypeInfo result = new PaymentTypeInfo();
        result.setPrice(CommonConverterHelper.convertMoney2Rest((BigDecimal)paymentTypeInfo.getValue().getSecond(), currency));
        result.setPgName((PgName)paymentTypeInfo.getValue().getFirst());
        BigDecimal commission = ((BigDecimal)paymentTypeInfo.getValue().getSecond()).subtract(totalPrice);
        result.setCommission(CommonConverterHelper.convertMoney2Rest(commission, currency));
        result.setSplitPaymentType(BookingPaymentHelper.isSplitPaymentType(paymentTypeInfo.getKey()));
        if (result.isSplitPaymentType()) {
            result.getSupportedSplitVendors().addAll(splitCardsSupportedVendors);
        }
        if (PaymentType.CREDIT_CARD_UNITELLER.equals((Object)paymentTypeInfo.getKey())) {
            result.getSupportedVendors().addAll(supportedCardVendors);
        }
        return result;
    }

    public static InitiatePaymentInfo convertBookingToInitiatePaymntInfo(EntityContainer<BookingFile> bookingFileEntityContainer, Money money, String text, SalesContext salesContext) {
        Reservation reservation = B2CInitiatePaymentHelper.getFirstReservation(bookingFileEntityContainer);
        InitiatePaymentInfo result = new InitiatePaymentInfo();
        result.setPnr(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        result.setTotal(money);
        result.setText(new TextPatternHelperEngine(salesContext, reservation).replacePatterns(text));
        return result;
    }

    public static EntityReference<BookingFile> getBookingFileByPnr(String pnr) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr, (boolean)true));
        return EntityStorage.get().search(BookingFileIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData().stream().min(Comparator.comparing(BookingFileIndex::getCreateDate)).map(BookingFileIndex::getSource).get();
    }
}

