/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.handlers.PaymentFeeHandler;
import com.gridnine.xtrip.server.pg.handlers.PgHandlersRegistry;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BookingPaymentHelper {
    public static final String PAYMENT_PARAMETER_KEY = "paymentUid";
    public static final String PAYMENTID_PARAMETER_KEY = "paymentId";
    public static final String PAYMENT_GATE_PARAMETER_KEY = "pg";
    private static final String BOOKING_PARAMETER_KEY = "bookingUid";
    private static Logger LOG = LoggerFactory.getLogger(BookingPaymentHelper.class);

    private BookingPaymentHelper() {
    }

    public static PaymentInitiationParameters createPaymentInitiationParameters(String comebackURL, EntityContainer<BookingFile> bookingFile, SalesContext salesContext, ContractType contractType) {
        PaymentInitiationParameters result = null;
        try {
            Payment payment;
            try {
                payment = PaymentHelper.createPayment(bookingFile, (ContractType)contractType);
                if (payment != null && payment.getCustomerInfo() != null) {
                    payment.getCustomerInfo().setPreferredLocale(LocaleHelper.getCurrentLocale());
                }
            }
            catch (Throwable t) {
                LOG.error("failed creating payment", t);
                throw t;
            }
            result = new PaymentInitiationParameters();
            result.setPayment(payment);
            result.setReturnUrl(comebackURL);
            result.setSalesContext(salesContext);
        }
        catch (Throwable t) {
            LOG.error("createPaymentInitiationParameters failed", t);
        }
        return result;
    }

    public static PaymentInitiationParameters createPaymentInitiationParameters(String comebackURL, EntityContainer<BookingFile> bookingFile, Collection<Reservation> reservations, SalesContext salesContext, ContractType contractType) {
        PaymentInitiationParameters result = null;
        try {
            Payment payment;
            try {
                payment = PaymentHelper.createPayment(bookingFile, reservations, (ContractType)contractType);
                if (payment != null && payment.getCustomerInfo() != null) {
                    payment.getCustomerInfo().setPreferredLocale(LocaleHelper.getCurrentLocale());
                }
            }
            catch (Throwable t) {
                LOG.error("failed creating payment", t);
                throw t;
            }
            result = new PaymentInitiationParameters();
            result.setPayment(payment);
            result.setReturnUrl(comebackURL);
            result.setSalesContext(salesContext);
        }
        catch (Throwable t) {
            LOG.error("createPaymentInitiationParameters failed", t);
        }
        return result;
    }

    public static String getComebackURL(MessageContext ctx) {
        EntityReference smSiteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        EntityContainer smSite = EntityStorageHelper.resolve((EntityReference)smSiteRef);
        StringJoiner comeBackUrl = new StringJoiner("/");
        RestContext restContext = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        HttpServletRequest request = restContext.getRequest();
        String scheme = request.getHeader("X-Forwarded-Proto") != null ? request.getHeader("X-Forwarded-Proto") : request.getScheme();
        scheme = scheme != null && scheme.indexOf("https") > -1 ? "https" : "http";
        comeBackUrl.add(scheme + "://" + ((SMSite)smSite.getEntity()).getDomain());
        comeBackUrl.add(LocaleHelper.getCurrentLocale().getLanguage());
        comeBackUrl.add("step6.html");
        return comeBackUrl.toString();
    }

    public static String appendBookingPayment(MessageContext ctx, PaymentInitiationParameters parameters) {
        StringBuilder builder = new StringBuilder(parameters.getReturnUrl());
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        builder.append("&").append(BOOKING_PARAMETER_KEY).append("=").append(bookingFile.getUid());
        builder.append("&").append(PAYMENT_PARAMETER_KEY).append("=").append(parameters.getPayment().getUid());
        builder.append("&").append(PAYMENTID_PARAMETER_KEY).append("=").append(parameters.getPayment().getPaymentId());
        return builder.toString();
    }

    public static Map<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> getPaymentTypesMap(PaymentInitiationParameters pip, EntityContainer<BookingFile> bookingFileReference, ContractType contractType) throws Exception {
        Map totalPrices = PaymentHelper.getTotalPrices(bookingFileReference, (ContractType)contractType);
        return BookingPaymentHelper.getPaymentTypesMap(pip, totalPrices);
    }

    public static Map<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> getPaymentTypesMap(PaymentInitiationParameters pip, EntityContainer<BookingFile> bookingFileCtr, Collection<Reservation> reservations, ContractType contractType) throws Exception {
        Map totalPrices = PaymentHelper.getTotalPrices(bookingFileCtr, reservations, (ContractType)contractType);
        return BookingPaymentHelper.getPaymentTypesMap(pip, totalPrices);
    }

    public static Map<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> getPaymentTypesMap(PaymentInitiationParameters pip, Map<PaymentType, BigDecimal> totalPrices) throws Exception {
        HashMap<PaymentType, MiscUtil.Pair<PgName, BigDecimal>> result = new HashMap<PaymentType, MiscUtil.Pair<PgName, BigDecimal>>();
        Collection<PgName> applicablePgs = BookingPaymentHelper.getApplicablePG(pip);
        ArrayList<MiscUtil.Pair> applicablePts = new ArrayList<MiscUtil.Pair>();
        for (PGConnectorInfo info : PaymentHelper.getConnectorsInfo()) {
            if (!applicablePgs.contains(info.getPg())) continue;
            applicablePts.addAll(info.getSupportedPaymentTypes().stream().map(paymentType -> new MiscUtil.Pair(paymentType, (Object)info.getPg())).collect(Collectors.toList()));
        }
        block1: for (PaymentType pt : PaymentType.values()) {
            for (MiscUtil.Pair applicablePt : applicablePts) {
                if (applicablePt.getFirst() != pt) continue;
                continue block1;
            }
            applicablePts.add(new MiscUtil.Pair((Object)pt, null));
        }
        for (MiscUtil.Pair applicablePt : applicablePts) {
            if (!totalPrices.containsKey(applicablePt.getFirst())) continue;
            result.put((PaymentType)applicablePt.getFirst(), (MiscUtil.Pair<PgName, BigDecimal>)new MiscUtil.Pair(applicablePt.getSecond(), (Object)totalPrices.get(applicablePt.getFirst())));
        }
        return result;
    }

    private static Collection<PgName> getApplicablePG(PaymentInitiationParameters parameters) throws Exception {
        PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)parameters.getPayment());
        if (pgParameters.getApplicablePG().isEmpty()) {
            LOG.warn("no applicable PG selected from rules in sales point");
        }
        return pgParameters.getApplicablePG();
    }

    public static PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters, MessageContext ctx) {
        PaymentInitiationResult result = null;
        try {
            parameters.getCustomParameters().add(NamedValueHelper.namedValue((String)"user.ip", (String)((RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT)).getRequest().getRemoteAddr()));
            PaymentFeeHandler paymentFeeHandler = ((PgHandlersRegistry)Environment.getPublished(PgHandlersRegistry.class)).getPaymentFeeHandler();
            if (paymentFeeHandler != null) {
                paymentFeeHandler.addPaymentFees(parameters.getPayment());
                LOG.debug("added payment fees");
            } else {
                LOG.warn("no payment fee handler registered");
            }
            result = ((PGConnectorRegistry)Environment.getPublished(PGConnectorRegistry.class)).get(parameters.getPg()).initiatePayment(parameters);
            LOG.debug(String.format("initiatePayment() END, pg=%s, paymentId=%s", parameters.getPg(), result.getPayment() == null ? "" : result.getPayment().getPaymentId()));
        }
        catch (Throwable t) {
            LOG.error("initiatePayment failed", t);
        }
        return result;
    }

    public static Set<AirlineCard> getAcceptedCards(EntityContainer<BookingFile> bookingFileEntityContainer) throws ServiceException {
        try {
            return PaymentHelper.getAcceptedCards((BookingFile)((BookingFile)bookingFileEntityContainer.getEntity()));
        }
        catch (Throwable t) {
            LOG.error("failed getAcceptedCards", t);
            throw new ServiceException("getting getAcceptedCards failed", t);
        }
    }

    public static Collection<AirlineCard> getAcceptedCards(Collection<Reservation> reservations) throws ServiceException {
        try {
            return reservations.stream().allMatch(r -> ReservationGdsNameInfoHelper.hasOnlineGdsAccountOfClass((Reservation)r, SabreGdsAccount.class)) ? PaymentHelper.getAcceptedCards(reservations) : Collections.emptySet();
        }
        catch (Throwable t) {
            LOG.error("failed getAcceptedCards", t);
            throw new ServiceException("getting getAcceptedCards failed", t);
        }
    }

    public static Set<CardVendor> getSupportedCardVendors() {
        return EnumSet.of(CardVendor.VISA, CardVendor.MASTERCARD, CardVendor.JCB, CardVendor.DINERS_CLUB);
    }

    public static Collection<CardVendor> getSabreSupportedCardVendors(Collection<AirlineCard> sabreAcceptedCards) {
        return sabreAcceptedCards.stream().map(AirlineCard::getVendor).collect(Collectors.toSet());
    }

    public static boolean isSplitPaymentType(PaymentType paymentType) {
        return PaymentType.CREDIT_CARD_SPLIT_UNITELLER.equals((Object)paymentType) || PaymentType.GATELINE_CREDIT_CARD_SPLIT.equals((Object)paymentType) || PaymentType.CREDIT_CARD_SPLIT_PAYONLINE.equals((Object)paymentType);
    }
}

