/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.BookingReservationProductParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;

public class BookingReservationProductResolver
extends BaseProcessor {
    public void process(MessageContext ctx) {
        BookingReservationProductParameters parameters = (BookingReservationProductParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingCtr = EntityStorage.get().resolve(parameters.getCurrentBooking());
        if (bookingCtr == null) {
            throw Xeption.forDeveloper((String)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043a\u0430\u0437 {0}", (Object[])new Object[]{parameters.getCurrentBooking()});
        }
        BookingFile booking = (BookingFile)bookingCtr.getEntity();
        Reservation reservation = BookingHelper.findReservationByUid((BookingFile)booking, (String)parameters.getReservationUid());
        if (reservation == null) {
            throw Xeption.forDeveloper((String)"\u0412 \u0437\u0430\u043a\u0430\u0437\u0435 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {1}", (Object[])new Object[]{booking.getNumber(), parameters.getReservationUid()});
        }
        BaseProduct product = BookingHelper.findProduct((Reservation)reservation, (String)parameters.getProductUid());
        if (product == null) {
            throw Xeption.forDeveloper((String)"\u0412 \u0437\u0430\u043a\u0430\u0437\u0435 {0}, \u0432 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 {1} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {2}", (Object[])new Object[]{booking.getNumber(), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), parameters.getProductUid()});
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, (Object)bookingCtr);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS, Collections.singletonList(reservation));
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCT, (Object)product);
    }
}

