/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking.cancelBooking;

import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CancelBookingHelper {
    private static final Set<ReservationStatus> ALLOWED_STATUSES = Stream.of(ReservationStatus.BOOKING, ReservationStatus.INTENTION, ReservationStatus.PROPOSAL, ReservationStatus.AUTHORIZATION).collect(Collectors.toSet());

    public static boolean isCancelBookingAllowed(Reservation reservation) {
        TravelSubject travelSubject = BookingHelper.getTravelSubject((Reservation)reservation);
        if (travelSubject == TravelSubject.HOTEL_RESERVATION) {
            if (reservation.getStatus() == ReservationStatus.REQUEST && HotelsReservationHelper.getProductsStream((Reservation)reservation).allMatch(product -> product.getProvider() == HotelProvider.BRONEVIK)) {
                return true;
            }
            if (reservation.getStatus() == ReservationStatus.REQUEST && HotelsReservationHelper.getProductsStream((Reservation)reservation).allMatch(product -> product.getSubProvider() != null && MiscUtil.equals((Object)"HOTELBOOK_HBPro", (Object)product.getSubProvider().getCode()))) {
                return true;
            }
        }
        return ALLOWED_STATUSES.contains(CommonIbecorpHelper.getReservationStatus((Reservation)reservation));
    }
}

