/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking.checkBooking;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.CheckBookingParameters;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonBookingPaymentHelper {
    public static final String RSB_TRANS_ID_PARAMETER = "trans_id";
    public static final String MILLIKART_REFERENCE_PARAMETER = "reference";
    private static Logger LOG = LoggerFactory.getLogger(CommonBookingPaymentHelper.class);

    public static MiscUtil.Pair<Boolean, String> isPaymentSuccessful(CheckBookingParameters restParameters, SalesContext salesContext, MessageContext ctx) {
        Map parameters = restParameters.getParameters();
        if (!parameters.containsKey("pg")) {
            return new MiscUtil.Pair(null, (Object)CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_MISSING_PG_PARAMETER, new Object[0]));
        }
        String pgName = (String)parameters.get("pg");
        if (pgName == null) {
            return new MiscUtil.Pair(null, (Object)CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_INVALID_PG_PARAMETER, new Object[0]));
        }
        PgName pg = PgName.valueOf((String)pgName);
        PGConnector pgConnector = ((PGConnectorRegistry)Environment.getPublished(PGConnectorRegistry.class)).get(pg);
        try {
            Payment initiatedPayment = pgConnector.getFromQueue((String)parameters.get("paymentId"));
            switch (pg) {
                case CHRONOPAY: {
                    return CommonBookingPaymentHelper.isChronopayPaymentSuccessful(parameters);
                }
                case UNITELLER: {
                    return CommonBookingPaymentHelper.isUnitellerPaymentSuccessful(parameters);
                }
                case PAYONLINE: {
                    return CommonBookingPaymentHelper.isPayonlinePaymentSuccessful(parameters);
                }
                case CREDIT_EUROPE_BANK: {
                    return CommonBookingPaymentHelper.isCreditEuropeBankPaymentSuccessful(parameters, pgConnector, salesContext, initiatedPayment);
                }
                case PLATRON: 
                case PLATRON2: {
                    return CommonBookingPaymentHelper.isPlatronPaymentSuccessful(parameters);
                }
                case RAIFFEISEN: {
                    return CommonBookingPaymentHelper.isRaiffeisenPaymentSuccessful(initiatedPayment.getPaymentId());
                }
                case RBS_V2: {
                    return CommonBookingPaymentHelper.isRbsV2PaymentSuccessful(pgConnector, initiatedPayment, salesContext);
                }
                case SIRENA: 
                case SIRENA_V2: {
                    return CommonBookingPaymentHelper.isSirenaPaymentSuccessful(parameters);
                }
                case RURU: {
                    return CommonBookingPaymentHelper.isRuruPaymentSuccessful(parameters);
                }
                case GATELINE: {
                    return CommonBookingPaymentHelper.isGatelinePaymentSuccessful(pgConnector, parameters, pg);
                }
                case RAPIDA: {
                    break;
                }
                case WAYFORPAY: {
                    return CommonBookingPaymentHelper.isWayForPayPaymentSuccessful(pgConnector, parameters, initiatedPayment, salesContext);
                }
                case MILLIKART: {
                    return CommonBookingPaymentHelper.isMilliKartPaymentSuccessful(pgConnector, parameters, salesContext, initiatedPayment);
                }
                case PAYBOX: {
                    return CommonBookingPaymentHelper.isPayboxPaymentSuccessful(parameters, pgConnector, salesContext, initiatedPayment, ctx);
                }
            }
        }
        catch (Throwable t) {
            LOG.error("isPaymentSuccessful failed", t);
            return new MiscUtil.Pair(null, (Object)t.getMessage());
        }
        return new MiscUtil.Pair(null, (Object)CommonHelper.getLocalizedString(Messages.PAYMENT_HELPER_UNKNOWN_GATEWAY, new Object[0]));
    }

    private static MiscUtil.Pair<Boolean, String> isRaiffeisenPaymentSuccessful(String paymentId) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)"RAIFFEISENpaymentStatusTO"));
        for (TemporalObject obj : AssetsStorage.get().search(TemporalObject.class, query).getData()) {
            if (!obj.getUid().equals(paymentId)) continue;
            return new MiscUtil.Pair((Object)(PaymentStatus.valueOf((String)new String(obj.getData())) == PaymentStatus.SUCCEEDED ? 1 : 0), null);
        }
        return new MiscUtil.Pair((Object)Boolean.FALSE, null);
    }

    public static MiscUtil.Pair<Boolean, String> isChronopayPaymentSuccessful(Map<String, String> parameters) {
        if (!parameters.containsKey("status")) {
            return new MiscUtil.Pair(null, (Object)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'status'");
        }
        return new MiscUtil.Pair((Object)"1".equals(parameters.get("status")), null);
    }

    public static MiscUtil.Pair<Boolean, String> isUnitellerPaymentSuccessful(Map<String, String> parameters) {
        if (!parameters.containsKey("status")) {
            return new MiscUtil.Pair(null, (Object)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'status'");
        }
        return new MiscUtil.Pair((Object)"1".equals(parameters.get("status")), null);
    }

    public static MiscUtil.Pair<Boolean, String> isPayonlinePaymentSuccessful(Map<String, String> parameters) {
        if (!parameters.containsKey("status")) {
            return new MiscUtil.Pair(null, (Object)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'status'");
        }
        return new MiscUtil.Pair((Object)"1".equals(parameters.get("status")), null);
    }

    public static MiscUtil.Pair<Boolean, String> isCreditEuropeBankPaymentSuccessful(Map<String, String> parameters, PGConnector pgConnector, SalesContext salesContext, Payment payment) throws Exception {
        String paymentId = parameters.get("oid");
        String response = parameters.get("Response");
        if (!"Approved".equalsIgnoreCase(response)) {
            throw new Exception("response isn't approved");
        }
        PaymentCheckParameters pcp = new PaymentCheckParameters();
        CommonBookingPaymentHelper.saveRequestParameters(pcp, parameters);
        pcp.setPayment(payment);
        pcp.setPg(payment.getPg());
        pcp.setSalesContext(salesContext);
        pcp.getPayment().setPgPaymentId(paymentId);
        PaymentCheckResult pcr = pgConnector.checkPayment(pcp);
        if (pcr.getPaymentStatus() != null) {
            return new MiscUtil.Pair((Object)(pcr.getPaymentStatus() == PaymentStatus.SUCCEEDED ? 1 : 0), (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
        }
        return new MiscUtil.Pair((Object)Boolean.FALSE, null);
    }

    private static void saveRequestParameters(PaymentCheckParameters pcp, Map<String, String> parameters) {
        int i = 0;
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            pcp.getCustomParameters().add(NamedValueHelper.namedValue((String)("request.parameter." + i++), (String)(parameter.getKey() + "=" + parameter.getValue())));
        }
    }

    public static MiscUtil.Pair<Boolean, String> isPlatronPaymentSuccessful(Map<String, String> parameters) {
        if (!parameters.containsKey("status")) {
            return new MiscUtil.Pair(null, (Object)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'status'");
        }
        return new MiscUtil.Pair((Object)"1".equals(parameters.get("status")), null);
    }

    public static MiscUtil.Pair<Boolean, String> isRbsV2PaymentSuccessful(PGConnector pgConnector, Payment payment, SalesContext salesCtx) throws Exception {
        PaymentCheckParameters pcp = new PaymentCheckParameters();
        pcp.setPayment(payment);
        pcp.setPg(payment.getPg());
        pcp.setSalesContext(salesCtx);
        PaymentCheckResult pcr = pgConnector.checkPayment(pcp);
        if (pcr.getPaymentStatus() != null) {
            return new MiscUtil.Pair((Object)(pcr.getPaymentStatus() == PaymentStatus.SUCCEEDED || pcr.getPaymentStatus() == PaymentStatus.IN_PROGRESS ? 1 : 0), (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
        }
        return new MiscUtil.Pair((Object)Boolean.FALSE, null);
    }

    public static MiscUtil.Pair<Boolean, String> isSirenaPaymentSuccessful(Map<String, String> parameters) {
        if (!parameters.containsKey("status")) {
            return new MiscUtil.Pair(null, (Object)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'status'");
        }
        return new MiscUtil.Pair((Object)"Ok".equals(parameters.get("status")), null);
    }

    public static MiscUtil.Pair<Boolean, String> isRuruPaymentSuccessful(Map<String, String> parameters) {
        if (!parameters.containsKey("status")) {
            return new MiscUtil.Pair(null, (Object)"\u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'status'");
        }
        return new MiscUtil.Pair((Object)parameters.get("status").equalsIgnoreCase("1"), null);
    }

    public static MiscUtil.Pair<Boolean, String> isGatelinePaymentSuccessful(PGConnector pgConnector, Map<String, String> parameters, PgName pg) throws Exception {
        String paymentId = parameters.get("merchant_order_id");
        String pgPaymentId = parameters.get("order_id");
        PaymentCheckParameters pcp = new PaymentCheckParameters();
        pcp.setPayment(new Payment());
        pcp.getPayment().setPaymentId(paymentId);
        pcp.getPayment().setPgPaymentId(pgPaymentId);
        pcp.setPg(pg);
        CommonBookingPaymentHelper.saveRequestParameters(pcp, parameters);
        PaymentCheckResult pcr = pgConnector.checkPayment(pcp);
        if (pcr.getPaymentStatus() != null) {
            boolean isSuccess = pcr.getPaymentStatus() == PaymentStatus.SUCCEEDED && pcr.isSuccess();
            return new MiscUtil.Pair((Object)isSuccess, (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
        }
        return new MiscUtil.Pair((Object)Boolean.FALSE, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MiscUtil.Pair<Boolean, String> isWayForPayPaymentSuccessful(PGConnector pgConnector, Map<String, String> parameters, Payment payment, SalesContext salesContext) throws ServiceException {
        PaymentCheckParameters pcp = new PaymentCheckParameters();
        CommonBookingPaymentHelper.saveRequestParameters(pcp, parameters);
        pcp.setPayment(payment);
        pcp.setPg(payment.getPg());
        pcp.setSalesContext(salesContext);
        pcp.getPayment().setPgPaymentId(parameters.get("result"));
        PaymentCheckResult pcr = pgConnector.checkPayment(pcp);
        if (pcr == null) return null;
        if (!pcr.isTwoStageMode()) {
            if (pcr.getPaymentStatus() == null) return new MiscUtil.Pair(null, (Object)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
            return new MiscUtil.Pair((Object)(pcr.getPaymentStatus() == PaymentStatus.SUCCEEDED ? 1 : 0), (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
        }
        if (pcr.getPaymentStatus() == null) return null;
        switch (pcr.getPaymentStatus()) {
            case IN_PROGRESS: 
            case INITIATED: {
                return null;
            }
            case SUCCEEDED: {
                return new MiscUtil.Pair((Object)Boolean.TRUE, (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
            }
            case FAILED: {
                return new MiscUtil.Pair((Object)Boolean.FALSE, (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
            }
            case ERROR: {
                return new MiscUtil.Pair(null, (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
            }
        }
        return null;
    }

    public static MiscUtil.Pair<Boolean, String> isMilliKartPaymentSuccessful(PGConnector pgConnector, Map<String, String> parameters, SalesContext salesContext, Payment payment) throws Exception {
        String paymentId = parameters.get("paymentId");
        PaymentCheckParameters pcp = new PaymentCheckParameters();
        CommonBookingPaymentHelper.saveRequestParameters(pcp, parameters);
        pcp.setPayment(payment);
        pcp.setPg(payment.getPg());
        pcp.setSalesContext(salesContext);
        pcp.getPayment().setPgPaymentId(paymentId);
        PaymentCheckResult pcr = pgConnector.checkPayment(pcp);
        if (pcr.getPaymentStatus() != null) {
            return new MiscUtil.Pair((Object)(pcr.getPaymentStatus() == PaymentStatus.SUCCEEDED ? 1 : 0), (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
        }
        return new MiscUtil.Pair((Object)Boolean.FALSE, null);
    }

    public static MiscUtil.Pair<Boolean, String> isPayboxPaymentSuccessful(Map<String, String> parameters, PGConnector pgConnector, SalesContext salesContext, Payment payment, MessageContext ctx) throws Exception {
        PaymentCheckResult pcr;
        if (payment == null) {
            payment = pgConnector.getFromQueue(parameters.get("paymentId"));
        }
        if (payment == null) {
            return new MiscUtil.Pair(null, (Object)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435\u0442 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        }
        PaymentCheckParameters pcp = new PaymentCheckParameters();
        CommonBookingPaymentHelper.saveRequestParameters(pcp, parameters);
        pcp.setPayment(payment);
        pcp.setPg(payment.getPg());
        pcp.setSalesContext(salesContext);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (ctx.hasObject((Enum)IBusIbecorpContextKeys.SITE)) {
            data.put(IBusIbecorpContextKeys.SITE.name(), ctx.getObject((Enum)IBusIbecorpContextKeys.SITE));
        }
        if ((pcr = pgConnector.checkPayment(pcp, data)).getPaymentStatus() != null) {
            return new MiscUtil.Pair((Object)(pcr.getPaymentStatus() == PaymentStatus.SUCCEEDED ? 1 : 0), (Object)MessageHelper.toHtmlString((Collection)pcr.getMessages()));
        }
        return new MiscUtil.Pair((Object)Boolean.FALSE, null);
    }
}

