/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;

public class SendReservationCreatedNotificationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String scheme;
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservations = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS_PERFORMED);
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        NotificationParameters parameters = new NotificationParameters((EntityReference<Organization>)sc.getSubagency(), (EntityReference<Organization>)sc.getClient(), (EntityReference<SMSite>)((BookingFile)bookingFile.getEntity()).getSite(), ((BookingFile)bookingFile.getEntity()).getCustomer().getPreferredLocale(), bookingFile.toReference(), sc);
        Boolean isAutoTicketing = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_TICKETING_AFTER_AUTHORIZATION_APPROVAL);
        if (BooleanUtils.isTrue((Boolean)isAutoTicketing)) {
            EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
            SMSite smSite = (SMSite)EntityStorage.get().resolve(siteRef).getEntity();
            scheme = smSite.isHttp() ? "http" : "https";
        } else {
            RestContext restContext = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
            HttpServletRequest request = restContext.getRequest();
            scheme = request.getHeader("X-Forwarded-Proto") != null ? request.getHeader("X-Forwarded-Proto") : request.getScheme();
            scheme = scheme != null && scheme.indexOf("https") > -1 ? "https" : "http";
        }
        parameters.setUrlScheme(scheme);
        for (Reservation reservation : NotificationHelper.getReservations((EntityContainer<BookingFile>)bookingFile, reservations)) {
            NotificationHelper.sendReservationCreatedNotification(parameters, reservation);
        }
    }
}

