/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking.initiatePayment;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.BaseInitiatePaymentParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.InitiatePaymentValidationMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Objects;

public abstract class BaseInitiatePaymentParametersValidatorProcessor<T extends BaseInitiatePaymentParameters>
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BaseInitiatePaymentParameters parameters = (BaseInitiatePaymentParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        PaymentType paymentType = parameters.getPaymentType();
        if (Objects.isNull(paymentType)) {
            parameters.getValidationContext().getPaymentTypeValidationMessages().add(InitiatePaymentValidationMessages.getMissingPaymentType());
        }
        this.validatePaymentType(ctx, paymentType, parameters);
        this.validateCashParameters(ctx, paymentType, parameters);
        SMStep3Settings step3Settings = CommonHelper.getStep3Settings((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)));
        boolean checkIataRules = step3Settings.isDisplayIataRulesBlock();
        if (step3Settings.isDisplayRulesInOneLine()) {
            if (!parameters.isAcceptAllRules()) {
                parameters.getValidationContext().getAcceptAllRulesValidationMessages().add(CreateBookingParametersValidationMessages.getRulesNotAccepted());
            }
        } else {
            if (!parameters.isAcceptBookingRules()) {
                parameters.getValidationContext().getAcceptBookingRulesValidationMessages().add(CreateBookingParametersValidationMessages.getBookingRulesNotAccepted());
            }
            if (!parameters.isAcceptFareRemarks()) {
                parameters.getValidationContext().getAcceptFareRemarksValidationMessages().add(CreateBookingParametersValidationMessages.getFareRemarksNotAccepted());
            }
            if (checkIataRules && !parameters.isAcceptIataRules()) {
                parameters.getValidationContext().getAcceptIataRulesValidationMessages().add(CreateBookingParametersValidationMessages.getIataRulesNotAccepted());
            }
        }
        this.validate(ctx, parameters);
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
    }

    protected abstract void validate(MessageContext var1, T var2);

    protected abstract void validatePaymentType(MessageContext var1, PaymentType var2, T var3);

    protected abstract void validateCashParameters(MessageContext var1, PaymentType var2, T var3);
}

