/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking.initiatePayment;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.RedirectForm;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.InitiatePaymentResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RepriceBookingResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.pg.ibus.common.PgPriceChangedException;
import java.util.Collection;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;

public abstract class BaseInitiatePaymentResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PaymentInitiationResult pir = (PaymentInitiationResult)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INIT_PAYMENT_RESULT);
        List issueExceptions = (List)ctx.getObject((Enum)IBusPgContextKeys.ISSUE_EXCEPTIONS);
        PaymentType paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        InitiatePaymentResult result = new InitiatePaymentResult();
        if (pir.getPayment() != null) {
            result.setPaymentId(pir.getPayment().getUid());
        }
        RedirectForm redirectForm = pir.getRedirectForm();
        result.setUrl(redirectForm.getUrl());
        if (!TextUtil.isBlank((String)redirectForm.getMethod())) {
            result.setMethod(redirectForm.getMethod());
        }
        if (!redirectForm.getParameters().isEmpty()) {
            result.getParameters().putAll(CommonHelper.convertCollectionToMap(redirectForm.getParameters(), NamedValue::getName, NamedValue::getValue));
        }
        if (!redirectForm.getParameters().isEmpty() && (redirectForm.getMethod() == null || "get".equals(redirectForm.getMethod().toLowerCase()))) {
            URIBuilder b = new URIBuilder(redirectForm.getUrl());
            for (NamedValue p : redirectForm.getParameters()) {
                b.setParameter(p.getName(), p.getValue());
            }
            result.setUrl(b.toString());
        }
        if (paymentType == PaymentType.CASH || paymentType == PaymentType.CASH_DELIVERY || paymentType == PaymentType.INVOICE) {
            this.convertCashOrInvoiceParameters(ctx, result, paymentType);
        }
        if (CollectionUtil.isNotEmpty((Collection)issueExceptions)) {
            issueExceptions.stream().filter(e -> e instanceof PgPriceChangedException).map(e -> (PgPriceChangedException)e).forEach(e -> {
                String currency = PriceComponentsParameters.getBriefInfoParameters(salesContext).getCurrency();
                RepriceBookingResult repriceResult = new RepriceBookingResult();
                repriceResult.setPriceChanged(true);
                repriceResult.setOldPrice(CommonConverterHelper.convertMoney2Rest(e.getOldPrice(), currency));
                repriceResult.setNewPrice(CommonConverterHelper.convertMoney2Rest(e.getNewPrice(), currency));
                result.getPriceChangeInfo().put(e.getReservation().getUid(), repriceResult);
            });
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected abstract void convertCashOrInvoiceParameters(MessageContext var1, InitiatePaymentResult var2, PaymentType var3) throws Exception;
}

