/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking.initiatePayment;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.CommonCardPaymentHelper;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.booking.BookingPaymentHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;

public abstract class InitiatePGPaymentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PaymentInitiationParameters paymentInitiationParameters;
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection reservations = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        if (reservations != null) {
            paymentInitiationParameters = BookingPaymentHelper.createPaymentInitiationParameters(BookingPaymentHelper.getComebackURL(ctx), (EntityContainer<BookingFile>)bookingFile, reservations, salesContext, ContractType.CLIENT);
            paymentInitiationParameters = CommonCardPaymentHelper.selectPaymentType((PaymentInitiationParameters)paymentInitiationParameters, (PaymentType)((PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE)), BookingPaymentHelper.getPaymentTypesMap(paymentInitiationParameters, (EntityContainer<BookingFile>)bookingFile, reservations, ContractType.CLIENT));
        } else {
            paymentInitiationParameters = BookingPaymentHelper.createPaymentInitiationParameters(BookingPaymentHelper.getComebackURL(ctx), (EntityContainer<BookingFile>)bookingFile, salesContext, ContractType.CLIENT);
            paymentInitiationParameters = CommonCardPaymentHelper.selectPaymentType((PaymentInitiationParameters)paymentInitiationParameters, (PaymentType)((PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE)), BookingPaymentHelper.getPaymentTypesMap(paymentInitiationParameters, (EntityContainer<BookingFile>)bookingFile, ContractType.CLIENT));
        }
        paymentInitiationParameters.setReturnUrl(BookingPaymentHelper.appendBookingPayment(ctx, paymentInitiationParameters));
        this.checkTicketingPermission(salesContext, paymentInitiationParameters.getPayment().getAmount());
        PaymentInitiationResult paymentInitiationResult = BookingPaymentHelper.initiatePayment(paymentInitiationParameters, ctx);
        paymentInitiationParameters.setPayment(paymentInitiationResult.getPayment());
        ctx.putObject((Enum)IBusPgContextKeys.INIT_PAYMENT_RESULT, (Object)paymentInitiationResult);
    }

    protected abstract void checkTicketingPermission(SalesContext var1, BigDecimal var2);
}

