/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.booking.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.PaymentRefundNotification;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SendPaymentRefundNotificationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Collection reservations = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        List refundedProducts = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        EntityReference bookingRef = bookingFile.toReference();
        NotificationParameters parameters = new NotificationParameters((EntityReference<Organization>)sc.getSubagency(), (EntityReference<Organization>)sc.getClient(), (EntityReference<SMSite>)((BookingFile)bookingFile.getEntity()).getSite(), ((BookingFile)bookingFile.getEntity()).getCustomer().getPreferredLocale(), bookingRef, sc);
        RestContext restContext = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        HttpServletRequest request = restContext.getRequest();
        String scheme = request.getHeader("X-Forwarded-Proto") != null ? request.getHeader("X-Forwarded-Proto") : request.getScheme();
        scheme = scheme != null && scheme.contains("https") ? "https" : "http";
        parameters.setUrlScheme(scheme);
        for (Reservation reservation : NotificationHelper.getReservations((EntityContainer<BookingFile>)bookingFile, reservations)) {
            NotificationHelper.sendNotification(() -> new PaymentRefundNotification(parameters, reservation, refundedProducts), bookingRef, true);
        }
    }
}

