/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.cabinet.deletePaymentCard;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.DeletePaymentCardRequestParams;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class DeletePersonPaymentCardProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Card card;
        DeletePaymentCardRequestParams params = (DeletePaymentCardRequestParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer orgCtr = EntityStorage.get().resolve((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION));
        List errors = (List)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_MESSAGES);
        this.checkParams(params);
        EntityContainer personCtr = EntityStorage.get().load(Person.class, params.getPersonContainerUID());
        if (personCtr == null) {
            throw Xeption.forDeveloper((String)("Person container with UID " + params.getPersonContainerUID() + " not resolved"), (Object[])new Object[0]);
        }
        Person person = (Person)personCtr.getEntity();
        PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
        String agencyToken = CirHelper.agencyToken((PCIDSSServerExchangeSettings)settings, (EntityReference)orgCtr.toReference());
        if (StringUtils.isBlank((String)agencyToken)) {
            errors.add(new InformationMessage(){

                public InformationMessage.Severity getSeverity() {
                    return InformationMessage.Severity.ERROR;
                }

                public String getCode() {
                    return null;
                }

                public String getText() {
                    return L10nResourcesManager.getStr((String)Messages.cirAgencyTokenNotFound, (Locale)LocaleManager.get().getCurrentLocale(), (Object[])new Object[0]);
                }
            });
        }
        if ((card = (Card)CollectionUtil.find((Iterable)person.getCards(), (String)params.getCardUID())) == null) {
            errors.add(new InformationMessage(){

                public InformationMessage.Severity getSeverity() {
                    return InformationMessage.Severity.ERROR;
                }

                public String getCode() {
                    return null;
                }

                public String getText() {
                    return L10nResourcesManager.getStr((String)"IBE_CABINET_PAYMENT_CARD_MISSING", (Locale)LocaleManager.get().getCurrentLocale(), (Object[])new Object[0]);
                }
            });
        }
        if (!errors.isEmpty()) {
            return;
        }
        CirHelper.deleteCard((Card)card, (PCIDSSServerExchangeSettings)settings, (String)agencyToken);
        person.getCards().remove(card);
        personCtr.getVersionInfo().setDataSource("Delete CIR card");
        EntityStorage.get().save(personCtr, true);
    }

    private void checkParams(DeletePaymentCardRequestParams params) {
        if (params == null) {
            throw Xeption.forDeveloper((String)"Missing request parameters in context!", (Object[])new Object[0]);
        }
        if (params.getPersonContainerUID() == null) {
            throw Xeption.forDeveloper((String)"Missing personUID parameter in request", (Object[])new Object[0]);
        }
        if (params.getCardUID() == null) {
            throw Xeption.forDeveloper((String)"Missing cardUid parameter in request", (Object[])new Object[0]);
        }
    }
}

