/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionAppenderProcessor
extends BaseProcessor {
    protected static Logger log = LoggerFactory.getLogger(CollectionAppenderProcessor.class);
    private String collectionKey;
    private String valueKey;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.collectionKey = parameters.get("collection");
        this.valueKey = parameters.get("value");
    }

    public void process(MessageContext ctx) throws Exception {
        Collection collection = (Collection)ctx.getMandatoryObject(this.collectionKey);
        Object value = ctx.getObject(this.valueKey);
        if (value == null) {
            log.info(String.format("%s didn't add value [%s] to collection [%s] as it is absent or null.", CollectionAppenderProcessor.class, this.valueKey, this.collectionKey));
        } else {
            collection.add(value);
        }
    }
}

