/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestTrainToken;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttribute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttributeEx;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RailService;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TrainName;
import com.gridnine.xtrip.common.model.dict.TrainType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.railway.dict.RailwayServiceClass;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Carriage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarriageInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailInformationMessages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailwayServiceClassReference;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.RestRailCarriagesHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.ComponentsHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.LocalizationHandler;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.GdsAccount;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.Gender;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.SeatInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.SubcategoryInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainSegment;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonRailRestHelper {
    private static final Map<CompartmentType, Gender> genderMap = new HashMap<CompartmentType, Gender>();
    private static final Map<String, String> carriageTypeTranslate = new HashMap<String, String>();
    private static final Logger log = LoggerFactory.getLogger(CommonRailRestHelper.class);
    public static final String NotRouteAvailableProvider = "P2";
    private static final Map<String, Gender> string2GenderMap;

    public static void fillCommonSeatsRequest(Train train, SalesContext salesContext, Date date, RestTrainToken restTrainToken, RzdGetTrainSeatsParameters rzdGetTrainSeatsParameters, RzdTrain rzdTrain) throws StorageException {
        rzdGetTrainSeatsParameters.setGdsAccount(rzdTrain.getGdsAccount());
        rzdGetTrainSeatsParameters.setDeparture(((TrainSegment)train.getSegments().get(0)).getDepartureLocation());
        rzdGetTrainSeatsParameters.setArrival(((TrainSegment)train.getSegments().get(0)).getArrivalLocation());
        rzdGetTrainSeatsParameters.setDepartureDate(date);
        rzdGetTrainSeatsParameters.setTrainNumber(restTrainToken.getTrainNumber());
        rzdGetTrainSeatsParameters.getPassengersTypes().putAll(restTrainToken.getPassengersTypes());
        salesContext.setClient(restTrainToken.getClient());
        rzdGetTrainSeatsParameters.setTrainProvider(restTrainToken.getTrainProvider());
    }

    public static int getDuration(Date beginDate, Date endDate, int type) {
        if (beginDate == null || endDate == null) {
            return 0;
        }
        long diff = endDate.getTime() - beginDate.getTime();
        switch (type) {
            case 5: {
                return (int)(diff / 1000L / 60L / 60L / 24L);
            }
            case 10: 
            case 11: {
                return (int)(diff / 1000L / 60L / 60L);
            }
            case 12: {
                return (int)(diff / 1000L / 60L);
            }
            case 13: {
                return (int)(diff / 1000L);
            }
            case 14: {
                return (int)diff;
            }
        }
        return 0;
    }

    public static Gender getGender(CompartmentType compartmentType) {
        return genderMap.get(compartmentType);
    }

    public static CompartmentType getCompartmentType(Gender gender) {
        return (CompartmentType)CollectionUtil.getKeyByValue(genderMap, (Object)gender);
    }

    public static SubcategoryInfo getSubcategoryInfo(String subcategory, boolean mealOption) {
        SubcategoryInfo subcategoryInfo = new SubcategoryInfo();
        subcategoryInfo.setWithEat(mealOption);
        CommonRailRestHelper.composeSubcategoryInfo(subcategoryInfo, subcategory);
        return subcategoryInfo;
    }

    private static void composeSubcategoryInfo(SubcategoryInfo subcategoryInfo, String subcategory) {
        subcategoryInfo.setSource(subcategory);
        if (TextUtil.isBlank((String)subcategory)) {
            return;
        }
        Set collection = CarriageAttributeEx.parseCarriageAttributes((String)subcategory);
        if (!CollectionUtil.isEmpty((Collection)collection)) {
            for (CarriageAttributeEx attributeEx : collection) {
                String mealCount;
                if (attributeEx.getAttribute() == CarriageAttribute.MF) {
                    subcategoryInfo.setGenderSelection(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.B) {
                    subcategoryInfo.setBusinessClass(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.E) {
                    subcategoryInfo.setEconomyClass(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.NF) {
                    subcategoryInfo.setUnbranded(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.BN) {
                    subcategoryInfo.setNoPlaces(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.I) {
                    subcategoryInfo.setPlacesForInvalides(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.PETS) {
                    subcategoryInfo.setWithPets(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.EXISTS_PETS) {
                    subcategoryInfo.setExistsPets(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.CHILD) {
                    subcategoryInfo.setWithChild(true);
                }
                if (attributeEx.getAttribute() == CarriageAttribute.EXISTS_CHILD) {
                    subcategoryInfo.setExistsChild(true);
                }
                if (attributeEx.getAttribute() != CarriageAttribute.U || TextUtil.isBlank((String)(mealCount = attributeEx.getValueEx()))) continue;
                subcategoryInfo.setMealCount(mealCount);
                if (subcategoryInfo.isWithEat() || "0".equals(mealCount)) continue;
                subcategoryInfo.setWithEat(true);
            }
        }
        if (!TextUtil.isBlank((String)subcategoryInfo.getMealCount())) {
            StringBuilder builder = new StringBuilder();
            builder.append("\u0423").append(subcategoryInfo.getMealCount());
            if (subcategoryInfo.isBusinessClass()) {
                builder.append("\u0411");
            }
            if (subcategoryInfo.isEconomyClass()) {
                builder.append("\u042d");
            }
            subcategoryInfo.setServiceMarker(builder.toString());
        }
    }

    public static void convertRzdTrainToRest(RzdTrainWithCategories midoffTrainWithCategories, Train restTrain, EntityReference<Organization> scClientRef, List<EntityReference<Person>> passengers, Map<DictionaryReference<PassengerType>, Integer> passengersTypes, TripParameters tripParams, RzdSearchTrainsParameters gdsParams, SMSiteType siteType, SMGeneralSettings generalSettings) throws Exception {
        TrainName name;
        boolean isPriceUnknown = false;
        RzdTrain rzdTrain = midoffTrainWithCategories.getTrain();
        boolean groupedByServiceClass = rzdTrain.isGroupedByServiceClass();
        LazyValueHolder filteringGenderSupplier = new LazyValueHolder(() -> RestRailCarriagesHelper.getFilteringGender(passengers));
        for (RzdCategory rzdCategory : midoffTrainWithCategories.getCategories()) {
            if (CommonConverterHelper.shouldExcludeFromSearchResults((TravelPolicyApplicable)rzdCategory)) continue;
            SubcategoryInfo subcategoryInfo = CommonRailRestHelper.getSubcategoryInfo(rzdCategory.getSubcategory(), rzdCategory.isMealOptionPossible());
            if (subcategoryInfo.isGenderSelection() && CollectionUtil.isNotEmpty(passengers) && rzdCategory.isGenderSeatsCountSupported() && filteringGenderSupplier.get() != null) {
                Integer excludeSeatsCount = filteringGenderSupplier.get() == com.gridnine.xtrip.common.model.dict.Gender.MALE ? rzdCategory.getFemaleSeatsCount() : rzdCategory.getMaleSeatsCount();
                int availableSeatsCount = MiscUtil.guarded((Integer)rzdCategory.getSeatsCount()) - MiscUtil.guarded((Integer)excludeSeatsCount);
                if (passengers.size() > availableSeatsCount) continue;
                rzdCategory.setSeatsCount(Integer.valueOf(availableSeatsCount));
            }
            CarriageInfo carriageInfo = new CarriageInfo();
            if (RzdCommonHelper.isPriceUnknown((RzdCategory)rzdCategory)) {
                isPriceUnknown = true;
            } else {
                carriageInfo.setPrice(rzdCategory.getPriceFullMin());
                carriageInfo.setPriceOriginal(rzdCategory.getPriceOriginalMin());
                carriageInfo.getRates().addAll(CommonConverterHelper.convertRatesToRest(ComponentsHelper.getCurrencyRates("RUB", rzdCategory.getPriceFullMin(), generalSettings.getDisplayCurrencies())));
            }
            carriageInfo.setPrepaidMeal(rzdCategory.isPrepaidMeal());
            carriageInfo.setSeatsAmount(rzdCategory.getSeatsCount().intValue());
            carriageInfo.setType(rzdCategory.getCarriageType());
            carriageInfo.setUid(rzdCategory.getUid());
            if (groupedByServiceClass) {
                if (!rzdCategory.getServiceClasses().isEmpty()) {
                    RailwayServiceClass railwayServiceClass = CommonRailRestHelper.getRailwayServiceClass((ServiceClass)rzdCategory.getServiceClasses().get(0), (DictionaryReference<RailwayCarrier>)rzdCategory.getCarrier(), rzdCategory.getTrainNumber());
                    carriageInfo.setServiceClass(CommonRailRestHelper.convertRailwayServiceClassToRest(railwayServiceClass));
                } else {
                    IncidentsLog.reportStackTrace((String)String.format("%s returned train number %s from %s to %s with carriage type %s", rzdTrain.getGdsAccount(), rzdTrain.getNumber(), rzdTrain.getDeparture(), rzdTrain.getArrival(), rzdCategory.getCarriageType()));
                }
            }
            carriageInfo.setWithDiscount(rzdCategory.isWithDiscount());
            carriageInfo.setSubcategory(subcategoryInfo);
            if (rzdCategory.isWithDiscount()) {
                restTrain.setWithDiscount(true);
            }
            if (rzdCategory.isHasRoundTripDiscount()) {
                restTrain.setWithRoundTripDiscount(true);
            }
            CommonConverterHelper.addTravelPolicyInfo(rzdCategory.getTravelPolicyImpositionResult(), (HasTravelPolicyCompliance)carriageInfo);
            restTrain.getCarriageInfos().add(carriageInfo);
        }
        if (isPriceUnknown || midoffTrainWithCategories.getCategories().isEmpty()) {
            restTrain.getMessages().add(RailInformationMessages.getTrailerCarUnknownPriceWarning());
        }
        restTrain.setERegister(rzdTrain.isERegEnabled());
        restTrain.setGds(rzdTrain.getGds());
        if (rzdTrain.getGdsAccount() != null) {
            EntityActualizer.newInstance().actualize((Object)rzdTrain.getGdsAccount());
            restTrain.setShowGdsAccountName(siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_RAILWAY));
            restTrain.setGdsAccountName(rzdTrain.getGdsAccount().getCaption());
            restTrain.setGdsAccount(CommonRailRestHelper.convertGdsAccountToRest((EntityReference<? extends BaseGdsAccount>)rzdTrain.getGdsAccount()));
        }
        if ((name = DictHelper.findTrainName((String)rzdTrain.getBrand())) == null) {
            log.error("Train name not found in dictionary with code {}", (Object)rzdTrain.getBrand());
        } else {
            String brand = DictHelper.getTranslation((BaseDictionary)name, (Locale)LocaleManager.get().getCurrentLocale(), (boolean)true);
            if (TextUtil.isBlank((String)brand)) {
                log.error("Translation in locale {} for the train name with code {} not found in dictionary", (Object)rzdTrain.getBrand(), (Object)LocaleManager.get().getCurrentLocale());
                restTrain.setBrand(rzdTrain.getBrand());
            } else {
                restTrain.setBrand(brand);
            }
        }
        restTrain.setCategory(rzdTrain.getCategory());
        TrainType type = DictHelper.findTrainType((String)rzdTrain.getCategory());
        if (type == null) {
            log.error("Train type not found in dictionary with code {}", (Object)rzdTrain.getCategory());
        } else {
            String description = DictHelper.getTranslation((BaseDictionary)type, (Locale)LocaleManager.get().getCurrentLocale(), (boolean)true);
            if (TextUtil.isBlank((String)description)) {
                log.error("Translation in locale {} for the train type with code {} not found in dictionary", (Object)rzdTrain.getBrand(), (Object)LocaleManager.get().getCurrentLocale());
            } else {
                restTrain.setCategoryDescription(description);
            }
        }
        restTrain.setGroupByServiceClass(rzdTrain.isGroupedByServiceClass());
        restTrain.setNumber(rzdTrain.getDisplayNumber());
        restTrain.getSegments().add(CommonRailRestHelper.createTrainRestSegment(rzdTrain));
        restTrain.getServices().addAll(CommonRailRestHelper.collectTrainServices(midoffTrainWithCategories));
        restTrain.setDisabled(rzdTrain.isDisabled());
        if (rzdTrain.getDisableReason() != null) {
            restTrain.setDisableReason(rzdTrain.getDisableReason().toString());
        }
        restTrain.setToken(CommonRailRestHelper.buildRestTrainToken(midoffTrainWithCategories, scClientRef, passengers, tripParams, passengersTypes, gdsParams));
        restTrain.setInternalRU(Boolean.valueOf(RzdCommonHelper.isInternalRU((DictionaryReference)rzdTrain.getPassengerFrom(), (DictionaryReference)rzdTrain.getPassengerTo())));
        restTrain.setRouteAvailable(!NotRouteAvailableProvider.equals(rzdTrain.getTrainProvider()));
    }

    private static Collection<RailService> collectTrainServices(RzdTrainWithCategories midoffTrainWithCategories) {
        Set<RailService> services = midoffTrainWithCategories.getCategories().stream().flatMap(category -> category.getServiceClasses().stream().map(sc -> CommonRailRestHelper.getRailwayServiceClass(sc, (DictionaryReference<RailwayCarrier>)category.getCarrier(), category.getTrainNumber()))).filter(Objects::nonNull).flatMap(rsc -> rsc.getServices().stream()).filter(Objects::nonNull).filter(railService -> !railService.name().startsWith("NO") && !railService.name().contains("FORBIDDEN")).collect(Collectors.toSet());
        if (services.isEmpty()) {
            services.addAll(midoffTrainWithCategories.getTrain().getServiceList());
        }
        return services;
    }

    public static RzdTrain convertRestToRzdTrain(Train train, RestTrainToken restTrainToken) {
        RzdTrain result = new RzdTrain();
        TrainSegment firstSegment = (TrainSegment)train.getSegments().get(0);
        result.setGds(train.getGds());
        result.setGdsAccount(restTrainToken.getGdsAccount());
        result.setNumber(restTrainToken.getTrainNumber());
        result.setDisplayNumber(restTrainToken.getTrainDisplayNumber());
        result.setCategory(train.getCategory());
        result.setBrand(train.getBrand());
        result.setDeparture(firstSegment.getTrainDepartureLocation());
        result.setArrival(firstSegment.getTrainArrivalLocation());
        result.setPassengerFrom(firstSegment.getDepartureLocation());
        result.setPassengerTo(firstSegment.getArrivalLocation());
        result.setDepartureDatetime(DateUtils.toJavaDate((LocalDateTime)firstSegment.getDepartureDate()));
        result.setArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)firstSegment.getArrivalDate()));
        result.setLocalDepartureDatetime(DateUtils.toJavaDate((LocalDateTime)firstSegment.getLocalDepartureDate()));
        result.setLocalArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)firstSegment.getLocalArrivalDate()));
        if (firstSegment.getDurationInMinutes() != null) {
            result.setWayTime(firstSegment.getDurationInMinutes());
        }
        result.setERegEnabled(train.isERegister());
        result.setTrainDepartureDate(restTrainToken.getTrainDepartureDate());
        result.setTrainProvider(restTrainToken.getTrainProvider());
        return result;
    }

    public static RzdTrain convertRestToRzdTrain(Train train) {
        return CommonRailRestHelper.convertRestToRzdTrain(train, CommonRestHelper.decodeToken(train.getToken(), RestTrainToken.class));
    }

    public static RzdTrainWithCategories convertRestToRzdTrainWithCategories(Train train) {
        RzdTrainWithCategories result = new RzdTrainWithCategories();
        result.setTrain(CommonRailRestHelper.convertRestToRzdTrain(train));
        RestTrainToken restTrainToken = CommonRestHelper.decodeToken(train.getToken(), RestTrainToken.class);
        result.getCategories().addAll(restTrainToken.getCategories());
        return result;
    }

    public static String calcCarriageTypeTitle(RzdPrice rzdPrice) {
        return CommonRailRestHelper.calcCarriageTypeTitle(rzdPrice.getCategory(), rzdPrice.getCategoryTitle());
    }

    private static TrainSegment createTrainRestSegment(RzdTrain rzdTrain) {
        TrainSegment trainSegment = new TrainSegment();
        trainSegment.setTrainArrivalLocation(rzdTrain.getArrival());
        trainSegment.setTrainDepartureLocation(rzdTrain.getDeparture());
        trainSegment.setDurationInMinutes(rzdTrain.getWayTime());
        trainSegment.setDepartureLocation(rzdTrain.getPassengerFrom());
        trainSegment.setArrivalLocation(rzdTrain.getPassengerTo());
        trainSegment.setDepartureMoscowTimeZone(RzdCommonHelper.isRussiaStation((DictionaryReference)rzdTrain.getPassengerFrom()));
        trainSegment.setArrivalMoscowTimeZone(RzdCommonHelper.isRussiaStation((DictionaryReference)rzdTrain.getPassengerTo()));
        trainSegment.setDepartureDate(DateUtils.toLocalDateTime((Date)rzdTrain.getDepartureDatetime()));
        trainSegment.setArrivalDate(DateUtils.toLocalDateTime((Date)rzdTrain.getArrivalDatetime()));
        trainSegment.setLocalDepartureDate(DateUtils.toLocalDateTime((Date)rzdTrain.getLocalDepartureDatetime()));
        trainSegment.setLocalArrivalDate(DateUtils.toLocalDateTime((Date)rzdTrain.getLocalArrivalDatetime()));
        trainSegment.setCarWithOtherArrivalTimeExists(rzdTrain.isCarWithOtherArrivalTimeExists());
        return trainSegment;
    }

    private static String buildRestTrainToken(RzdTrainWithCategories rzdTrainWithCategories, EntityReference<Organization> scClientRef, List<EntityReference<Person>> passengers, TripParameters tripParams, Map<DictionaryReference<PassengerType>, Integer> passengersTypes, RzdSearchTrainsParameters gdsParams) throws Exception {
        RzdTrain rzdTrain = rzdTrainWithCategories.getTrain();
        RestTrainToken restTrainToken = new RestTrainToken();
        restTrainToken.setGdsAccount(rzdTrain.getGdsAccount());
        restTrainToken.setClient(scClientRef);
        restTrainToken.setTrainDepartureDate(rzdTrain.getTrainDepartureDate());
        restTrainToken.setTrainNumber(rzdTrain.getNumber());
        restTrainToken.setTrainDisplayNumber(rzdTrain.getDisplayNumber());
        restTrainToken.setTrainProvider(rzdTrain.getTrainProvider());
        restTrainToken.getSelectedPassengers().addAll(passengers);
        restTrainToken.getPassengersTypes().putAll(passengersTypes);
        restTrainToken.setPassengerFrom(rzdTrain.getPassengerFrom());
        restTrainToken.setPassengerTo(rzdTrain.getPassengerTo());
        if (tripParams != null) {
            restTrainToken.setBookingFile(tripParams.getBookingFileRef());
        }
        if (rzdTrainWithCategories != null) {
            for (RzdCategory rzdCategory : rzdTrainWithCategories.getCategories()) {
                restTrainToken.getCarriageInfos().put(rzdCategory.getUid(), TextUtil.nonNullStr((String)rzdCategory.getTrainNumber()));
            }
            restTrainToken.getCategories().addAll(rzdTrainWithCategories.getCategories());
        }
        restTrainToken.setTrainBack(rzdTrain.isTrainBack());
        restTrainToken.setDepartureDate(gdsParams.getDepartureDate());
        restTrainToken.setDepartureDateBack(gdsParams.getDepartureDateBack());
        return CommonRestHelper.encodeToken((BaseEntity)restTrainToken);
    }

    private static String calcCarriageTypeTitle(CarriageType category, String categoryTitle) {
        String categoryTitleTranslated = Optional.ofNullable(carriageTypeTranslate.get(categoryTitle)).map(x$0 -> L10nResourcesManager.getStr((String)x$0, (Object[])new Object[0])).orElse(categoryTitle);
        String categoryCaption = LocalizationHandler.toString(category);
        if (TextUtil.isBlank((String)categoryTitleTranslated)) {
            return categoryCaption;
        }
        if (categoryCaption.matches(".*\\(.*\\).*")) {
            return categoryTitleTranslated + ' ' + categoryCaption.substring(categoryCaption.indexOf(40), categoryCaption.indexOf(41) + 1);
        }
        return categoryTitleTranslated;
    }

    public static void fillCarriage(Carriage carriage, RzdPrice rzdPrice, RzdCar rzdCar) {
        carriage.setCarrierRoute(rzdPrice.getRoute());
        carriage.setSeatsGroupSize(rzdPrice.getSeatsIncluded());
        if (rzdPrice.getCarrier() != null) {
            carriage.setCarrier(rzdPrice.getCarrier().getCode());
        }
        carriage.setGdsServiceClass(rzdPrice.getServiceClass());
        RailwayServiceClass railwayServiceClass = CommonRailRestHelper.getRailwayServiceClass(rzdPrice.getServiceClass(), (DictionaryReference<RailwayCarrier>)rzdPrice.getCarrier(), rzdCar.getTrainNumber());
        carriage.getServices().addAll(CommonRailRestHelper.collectRailServices(railwayServiceClass, rzdPrice.getSubcategory(), rzdPrice.getServicesList()));
        if (railwayServiceClass != null) {
            carriage.setServiceClass(CommonRailRestHelper.convertRailwayServiceClassToRest(railwayServiceClass));
        } else {
            carriage.setServiceClass(CommonRailRestHelper.createServiceClassReferenceFromProviderData(rzdPrice.getServiceClassCode(), rzdPrice.getServiceDescription()));
        }
        carriage.getAvailableAncillaryFees().addAll(rzdCar.getAvailableAncillaryFees());
        carriage.setType(rzdPrice.getCategory());
        carriage.setTypeTitle(CommonRailRestHelper.calcCarriageTypeTitle(rzdPrice));
        carriage.setNumber(rzdCar.getNumber());
        carriage.setPlaceQuantity(rzdCar.getTotalPlaceCount());
        carriage.setBeddingEnabled(rzdCar.isBeddingEnabled());
        carriage.setERegister(rzdCar.isERegEnabled());
        carriage.setSchema(rzdCar.getSchema());
        carriage.setCarriageCardId(RailwayHelper.findCarriageCardId(rzdPrice, rzdCar).name());
        carriage.setProviderCarSchemeId(rzdCar.getProviderCarSchemeId());
        carriage.setTwoStoreyed(rzdCar.isTwoStoreyed());
        carriage.setArrivalDate(DateUtils.toLocalDateTime((Date)rzdCar.getArrivalDatetime()));
        carriage.setLocalArrivalDate(DateUtils.toLocalDateTime((Date)rzdCar.getLocalArrivalDatetime()));
        carriage.setPrepaidMeal(rzdCar.isPrepaidMeal());
    }

    public static List<RailService> collectRailServices(RailwayServiceClass railwayServiceClass, String subcategory, List<RailService> providerServices) {
        if (railwayServiceClass == null) {
            return providerServices;
        }
        ArrayList<RailService> result = new ArrayList<RailService>(railwayServiceClass.getServices());
        Set carriageAttributesEx = CarriageAttributeEx.parseCarriageAttributes((String)subcategory);
        carriageAttributesEx.stream().filter(attr -> attr.getAttribute() == CarriageAttribute.U && "0".equals(attr.getValueEx())).findFirst().ifPresent(att -> {
            boolean noMeal = result.remove(RailService.MEAL);
            if (noMeal && providerServices.contains(RailService.RESTAURANT_CAR) && !result.contains(RailService.RESTAURANT_CAR)) {
                result.add(RailService.RESTAURANT_CAR);
            }
        });
        return result;
    }

    private static String formatTextForSite(String text) {
        if (TextUtil.isBlank((String)text)) {
            return text;
        }
        return text.replaceAll("\n\\s*", " ");
    }

    public static GdsAccount convertGdsAccountToRest(EntityReference<? extends BaseGdsAccount> gdsAccountRef) {
        if (gdsAccountRef == null) {
            return null;
        }
        GdsAccount result = new GdsAccount();
        result.setRefUid(gdsAccountRef.getUid());
        result.setRefClassName(gdsAccountRef.getType().getName());
        return result;
    }

    public static Traveller convertTravellerFromRest(RestTraveller restTraveller, Date arriveDate) {
        Traveller traveller = CommonConverterHelper.convertTravellerFromRest(restTraveller, arriveDate);
        if (TextUtil.nonBlank((String)restTraveller.getUid())) {
            traveller.setPassenger(new EntityReference(restTraveller.getUid(), Person.class, null));
        }
        return traveller;
    }

    public static void fillSeatInfo(String seat, SeatInfo seatInfo) {
        String[] strings = RailwayHelper.GENDER_PATTERN.split(seat);
        seatInfo.setNumber(strings[0]);
        seatInfo.setGender(CommonRailRestHelper.getGender(strings));
    }

    private static Gender getGender(String[] strings) {
        return strings.length > 1 ? string2GenderMap.get(strings[1]) : null;
    }

    public static String genderToString(Gender gender) {
        return (String)CollectionUtil.getKeyByValue(string2GenderMap, (Object)gender);
    }

    public static RailwayServiceClass getRailwayServiceClass(ServiceClass serviceClass, DictionaryReference<RailwayCarrier> carrier, String trainNumber) {
        return CommonRailRestHelper.getRailwayServiceClass(serviceClass, carrier, trainNumber, "");
    }

    public static RailwayServiceClass getRailwayServiceClass(ServiceClass serviceClass, DictionaryReference<RailwayCarrier> carrier, String trainNumber, String logInfo) {
        List<RailwayServiceClass> railwayServiceClasses = DictionaryCache.get().getAll(RailwayServiceClass.class).values().stream().filter(sc -> sc.getServiceClass() == serviceClass).filter(CommonRailRestHelper.filterRailwayServiceClassByCarrier(carrier)).collect(Collectors.toList());
        if (railwayServiceClasses.isEmpty()) {
            String message = String.format("\u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \"\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0416\u0414\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0438\u0441 \u043a\u043b\u0430\u0441\u0441\u0430 \"%1$s\", \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430 \"%2$s\". \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f: \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0435\u0437\u0434\u0430 \"%3$s\"%4$s", serviceClass, carrier, trainNumber, logInfo);
            if (serviceClass != null && carrier != null) {
                IncidentsLog.reportAdminStackTrace((String)message);
            } else {
                IncidentsLog.reportStackTrace((String)message);
            }
            return null;
        }
        return CommonRailRestHelper.selectRailwayServiceClassByTrainNumber(railwayServiceClasses, trainNumber);
    }

    private static Predicate<RailwayServiceClass> filterRailwayServiceClassByCarrier(DictionaryReference<RailwayCarrier> carrier) {
        String regex = "^\u0424\u041f\u041a.*$";
        return serviceClass -> {
            if (carrier != null && serviceClass.getCarrier() != null) {
                return carrier.getCode().matches(regex) && serviceClass.getCarrier().getCode().matches(regex) || serviceClass.getCarrier().equals((Object)carrier);
            }
            return false;
        };
    }

    private static RailwayServiceClass selectRailwayServiceClassByTrainNumber(List<RailwayServiceClass> serviceClasses, String trainNumber) {
        ArrayList<RailwayServiceClass> specialTrainClass = new ArrayList<RailwayServiceClass>();
        ArrayList<RailwayServiceClass> simpleTrainClass = new ArrayList<RailwayServiceClass>();
        for (RailwayServiceClass serviceClass : serviceClasses) {
            if (serviceClass.getAvailableTrainsNumbers().contains(trainNumber)) {
                specialTrainClass.add(serviceClass);
            }
            if (!serviceClass.getAvailableTrainsNumbers().isEmpty()) continue;
            simpleTrainClass.add(serviceClass);
        }
        if (simpleTrainClass.size() > 1 || specialTrainClass.size() > 1) {
            IncidentsLog.reportStackTrace((String)("More than one railway service classes was found for train " + trainNumber));
            return null;
        }
        if (specialTrainClass.isEmpty()) {
            if (simpleTrainClass.isEmpty()) {
                IncidentsLog.reportStackTrace((String)String.format("Missing railway service class for train %s. Received classes: %s", trainNumber, serviceClasses.stream().map(sc -> sc.getServiceClass().toString()).collect(Collectors.joining(", "))));
                return null;
            }
            return (RailwayServiceClass)simpleTrainClass.get(0);
        }
        return (RailwayServiceClass)specialTrainClass.get(0);
    }

    public static RailwayServiceClassReference convertRailwayServiceClassToRest(RailwayServiceClass rsc) {
        if (rsc == null || rsc.getServiceClass() == null) {
            return null;
        }
        RailwayServiceClassReference result = new RailwayServiceClassReference();
        result.setUid(rsc.getServiceClass().name());
        result.setCaption(rsc.getServiceClass().toString());
        if (!rsc.getTranslations().isEmpty()) {
            result.setDescription(rsc.toString());
        }
        return result;
    }

    public static RailwayServiceClassReference createServiceClassReferenceFromProviderData(String providerServiceClass, String providerServiceDescription) {
        RailwayServiceClassReference result = new RailwayServiceClassReference();
        result.setUid(providerServiceClass);
        result.setCaption(providerServiceClass);
        result.setDescription(providerServiceDescription);
        return result;
    }

    static {
        genderMap.put(CompartmentType.MEN, Gender.MALE);
        genderMap.put(CompartmentType.WOMEN, Gender.FEMALE);
        genderMap.put(CompartmentType.COMMON, Gender.MIX);
        carriageTypeTranslate.put("\u041e\u0431\u0449\u0438\u0439", "IBE_RAIL_CAR_TYPE_OBSHHIJ");
        carriageTypeTranslate.put("\u0421\u0438\u0434\u044f\u0447\u0438\u0439", "IBE_RAIL_CAR_TYPE_SIDJACHIJ");
        carriageTypeTranslate.put("\u041f\u043b\u0430\u0446\u043a\u0430\u0440\u0442\u043d\u044b\u0439", "IBE_RAIL_CAR_TYPE_PLACKARTNYJ");
        carriageTypeTranslate.put("\u041a\u0443\u043f\u0435", "IBE_RAIL_CAR_TYPE_KUPE");
        carriageTypeTranslate.put("\u041c\u044f\u0433\u043a\u0438\u0439", "IBE_RAIL_CAR_TYPE_MJAGKIJ");
        carriageTypeTranslate.put("\u041b\u044e\u043a\u0441", "IBE_RAIL_CAR_TYPE_LJUKS");
        carriageTypeTranslate.put("\u0421\u0412", "IBE_RAIL_CAR_TYPE_SV");
        string2GenderMap = new HashMap<String, Gender>();
        string2GenderMap.put("\u041c", Gender.MALE);
        string2GenderMap.put("\u0416", Gender.FEMALE);
        string2GenderMap.put("\u0421", Gender.MIX);
        string2GenderMap.put("\u0426", Gender.NOT_SELECTED);
    }
}

