/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.ConverterHelper;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ContextMessagesToRestAdvice
extends BaseAdvice {
    private MessageType messageType = null;

    public void configure(Map<String, String> params) throws Exception {
        String messageTypeStr = IbusConfigurationHelper.getOptionalParameter(params, (String)"messageType");
        if (!TextUtil.isBlank((String)messageTypeStr)) {
            this.messageType = MessageType.valueOf((String)messageTypeStr);
        }
    }

    public void after(MessageContext ctx) throws Exception {
        Collection messages = ctx.getMessagesReadOnly();
        if (CollectionUtil.isEmpty((Collection)messages)) {
            return;
        }
        ArrayList<InformationMessage> restMessages = (ArrayList<InformationMessage>)ctx.getObject((Enum)IBusRestContextKeys.REST_MESSAGES);
        if (restMessages == null) {
            restMessages = new ArrayList<InformationMessage>();
            ctx.putObject((Enum)IBusRestContextKeys.REST_MESSAGES, restMessages);
        }
        for (Message message : messages) {
            if (this.messageType != null && message.getType() != this.messageType) continue;
            restMessages.add(ConverterHelper.convertSystemMessageToRest(message));
        }
    }
}

