/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.MarkItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailBonusCard;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailStandardAutocompleteItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.StationAutocompleteItem;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ConverterHelper {
    public static Date toDate(LocalDate value) {
        return value != null ? value.toDate() : null;
    }

    public static Date toDate(LocalDateTime value) {
        return value != null ? value.toDate() : null;
    }

    public static RailBonusCard convertRailwayBonusCardToRest(RailwayBonusCard source) {
        if (source == null || TextUtil.isBlank((String)source.getNumber())) {
            return null;
        }
        RailBonusCard result = new RailBonusCard();
        result.setUid(source.getUid());
        result.setNumber(source.getNumber());
        result.setCarrierCode(source.getRailwayCarrierCode());
        return result;
    }

    public static InformationMessage convertSystemMessageToRest(final Message sysMessage) {
        return new InformationMessage(){
            private static final long serialVersionUID = -8371527698624941293L;

            public InformationMessage.Severity getSeverity() {
                switch (sysMessage.getType()) {
                    case ERROR: {
                        return InformationMessage.Severity.ERROR;
                    }
                    case WARNING: {
                        return InformationMessage.Severity.WARNING;
                    }
                    case FOR_USER: 
                    case MESSAGE: {
                        return InformationMessage.Severity.INFO;
                    }
                }
                return null;
            }

            public String getCode() {
                L10nMessage message = sysMessage.getMessage();
                if (message != null && message.getKey() != null) {
                    return sysMessage.getClass().getCanonicalName() + "." + message.getKey();
                }
                return null;
            }

            public String getText() {
                if (sysMessage.getMessage() != null) {
                    return sysMessage.getMessage().toString();
                }
                return sysMessage.toString();
            }
        };
    }

    public static String cleanEmail(String email) {
        StringBuilder stringBuilder = new StringBuilder(email);
        stringBuilder.trimToSize();
        boolean isClose = true;
        int i = 0;
        while (i < stringBuilder.length()) {
            char c = stringBuilder.charAt(i);
            if (c == '<') {
                isClose = false;
                stringBuilder.deleteCharAt(i);
                continue;
            }
            if (c == '>' && !isClose) {
                isClose = true;
                stringBuilder.deleteCharAt(i);
                continue;
            }
            if (!isClose) {
                stringBuilder.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public static StationAutocompleteItem createStationAutocompleteItem(RailwayStation station, Locale locale, String term) {
        StationAutocompleteItem result = new StationAutocompleteItem();
        ConverterHelper.fillAutocompleteItem((RailStandardAutocompleteItem)result, (BaseDictionary)station, locale, term);
        return result;
    }

    private static void fillAutocompleteItem(RailStandardAutocompleteItem result, BaseDictionary dict, Locale locale, String term) {
        result.setUid(dict.getCode());
        Map translations = dict.getTranslations();
        if (translations.get(locale) != null) {
            result.setCaption((String)MiscUtil.findByLocale((Map)dict.getTranslations(), (Locale)locale));
        } else {
            String en = "en";
            String ru = "ru";
            if (locale.getLanguage().equalsIgnoreCase(en) && translations.get(new Locale(en)) != null) {
                result.setCaption((String)translations.get(Locale.ENGLISH));
            } else if (locale.getLanguage().equalsIgnoreCase(ru) && translations.get(new Locale(ru)) != null) {
                result.setCaption((String)translations.get(new Locale(ru)));
            } else if (!translations.keySet().isEmpty()) {
                result.setCaption((String)translations.get(translations.keySet().iterator().next()));
            }
        }
        ConverterHelper.fillMarks(result.getMarksCaption(), result.getCaption(), term);
    }

    public static void fillMarks(List<MarkItem> marks, String text, String term) {
        if (TextUtil.isBlank((String)text) || TextUtil.isBlank((String)term)) {
            return;
        }
        String textLC = text.toLowerCase();
        String termLC = term.toLowerCase();
        int index = 0;
        while (-1 != (index = textLC.indexOf(termLC, index))) {
            MarkItem item = new MarkItem();
            item.setStart(index);
            item.setEnd(index + termLC.length() - 1);
            marks.add(item);
            index += termLC.length();
        }
    }
}

