/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDocument;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DownloadableDocumentBuilder
extends BaseProcessor {
    private String documentStr;
    private String outStr;
    private String zip;

    public void configure(Map<String, String> params) {
        super.configure(params);
        this.documentStr = IbusConfigurationHelper.getMandatoryParameter(params, (String)"document");
        this.outStr = IbusConfigurationHelper.getMandatoryParameter(params, (String)"out");
        this.zip = IbusConfigurationHelper.getOptionalParameter(params, (String)"zip");
    }

    public void process(MessageContext ctx) throws Exception {
        DocumentInfo info;
        Object source = ctx.getMandatoryObject(this.documentStr);
        Collection target = new ArrayList<BaseEntity>();
        if (!Collection.class.isAssignableFrom(source.getClass())) {
            target.add((BaseEntity)source);
        } else {
            Collection collection = (Collection)source;
            target = collection;
        }
        if (target.size() > 1 || target.size() == 1 && this.isForceZip(ctx)) {
            HashSet<String> fileNames = new HashSet<String>();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(bos);
            for (BaseEntity entity : target) {
                DocumentInfo toZip = this.getDocumentInfo(entity);
                String fileName = this.buildFileName(toZip.getFileName(), fileNames);
                fileNames.add(fileName);
                ZipEntry entry = new ZipEntry(fileName);
                zos.putNextEntry(entry);
                zos.write(toZip.getContent());
                zos.closeEntry();
            }
            zos.close();
            info = new DocumentInfo(L10nResourcesManager.getStr((String)"ZIP_ARCHIVE_FILE_NAME", (Object[])new Object[0]), bos.toByteArray(), ContentType.BINARY);
        } else if (target.size() == 1) {
            info = this.getDocumentInfo((BaseEntity)target.iterator().next());
        } else {
            throw Xeption.forDeveloper((String)"Unable to download documents as document collection is empty.", (Object[])new Object[0]);
        }
        DownloadableData result = new DownloadableData();
        result.setFileName(info.getFileName());
        BinaryData binaryData = new BinaryData();
        binaryData.setContentType(info.getContentType());
        binaryData.setData(info.getContent());
        result.setContent(binaryData);
        ctx.putObject(this.outStr, (Object)result);
    }

    private String buildFileName(String originalFileName, Set<String> fileNames) {
        String fileName;
        String string = fileName = originalFileName == null ? "blank" : originalFileName;
        if (!fileNames.contains(fileName)) {
            return fileName;
        }
        int idx = 1;
        int index = fileName.lastIndexOf(46);
        String name = fileName;
        String extension = null;
        if (index != -1 && idx < fileName.length() - 1) {
            name = fileName.substring(0, index);
            extension = fileName.substring(index + 1);
        }
        while (true) {
            String newName = String.format("%s(%s)", name, Integer.toString(idx));
            if (extension != null) {
                newName = newName + "." + extension;
            }
            if (!fileNames.contains(newName)) {
                return newName;
            }
            ++idx;
        }
    }

    private boolean isForceZip(MessageContext ctx) {
        return Boolean.TRUE.equals(ctx.getObject(this.zip));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DocumentInfo getDocumentInfo(BaseEntity source) {
        if (source instanceof EntityContainer) {
            EntityContainer ctr = (EntityContainer)source;
            if (ctr.getEntityType().isAssignableFrom(BaseFileDocument.class)) {
                BaseFileDocument doc = (BaseFileDocument)ctr.getEntity();
                return new DocumentInfo(doc.getName(), doc.getContent(), doc.getContentType());
            }
            if (ctr.getEntityType().isAssignableFrom(BaseSingleFileReportDocument.class)) {
                BaseSingleFileReportDocument doc = (BaseSingleFileReportDocument)ctr.getEntity();
                return new DocumentInfo(doc.getFile().getName(), doc.getFile().getContent(), doc.getFile().getContentType());
            }
            if (BaseSingleFileTemplateReportDocument.class.isAssignableFrom(ctr.getEntityType())) {
                BaseSingleFileTemplateReportDocument doc = (BaseSingleFileTemplateReportDocument)ctr.getEntity();
                return new DocumentInfo(doc.getFile().getName(), doc.getFile().getContent(), doc.getFile().getContentType());
            }
            if (!ctr.getEntityType().isAssignableFrom(Document.class)) throw Xeption.forDeveloper((String)String.format("Downloading documents of type %s is not supported.", ctr.getEntityType().getName()), (Object[])new Object[0]);
            Document doc = (Document)ctr.getEntity();
            return new DocumentInfo(doc.getName(), doc.getContent(), doc.getContentType());
        }
        if (!(source instanceof FilledTemplateDocument)) throw Xeption.forDeveloper((String)String.format("Downloading documents of type %s is not supported.", source.getClass().getName()), (Object[])new Object[0]);
        FilledTemplateDocument doc = (FilledTemplateDocument)source;
        return new DocumentInfo(doc.getName(), doc.getContent(), doc.getContentType());
    }

    private class DocumentInfo {
        private final String fileName;
        private final byte[] content;
        private final ContentType contentType;

        public DocumentInfo(String fileName, byte[] content, ContentType contentType) {
            this.fileName = fileName;
            this.content = content;
            this.contentType = contentType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getContent() {
            return this.content;
        }

        public ContentType getContentType() {
            return this.contentType;
        }
    }
}

