/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.Objects;

public class EntityFinder
extends BaseProcessor {
    private Class<?> type;
    private String paramsKey;
    private String resultKey;

    public void configure(Map<String, String> parameters) {
        this.paramsKey = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"parameters");
        this.resultKey = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"result");
        String typeStr = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"type");
        try {
            this.type = Class.forName(typeStr);
        }
        catch (ClassNotFoundException e) {
            throw Xeption.forDeveloper((String)"Unable to perform find operation. Class {0} not found.", (Object[])new Object[]{typeStr});
        }
    }

    public void process(MessageContext ctx) throws Exception {
        Object uidParameter = ctx.getObject(this.paramsKey);
        if (Objects.isNull(uidParameter)) {
            return;
        }
        if (EntityReference.class.isInstance(uidParameter)) {
            EntityContainer ctr = B2BRestHelper.findCtr((EntityReference)uidParameter);
            ctx.putObject(this.resultKey, ctr);
            return;
        }
        if (EntityIndex.class.isInstance(uidParameter)) {
            EntityContainer ctr = B2BRestHelper.findCtr(((EntityIndex)uidParameter).getSource());
            ctx.putObject(this.resultKey, ctr);
            return;
        }
        String uid = this.parseSingleUid(uidParameter);
        ctx.putObject(this.resultKey, B2BRestHelper.findCtr(uid, this.type));
    }

    private String parseSingleUid(Object uidParameter) throws Xeption {
        if (String.class.isInstance(uidParameter)) {
            return (String)uidParameter;
        }
        throw Xeption.forDeveloper((String)("Single entity finder doesn't support parameters of type " + uidParameter.getClass().getName()), (Object[])new Object[0]);
    }
}

