/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class EntitySaver
extends BaseProcessor {
    private boolean withCheckPoint = false;
    private boolean updateIndexes = true;
    private String paramsKey;
    private String dataSource;
    private String verionNotes;

    public void configure(Map<String, String> parameters) {
        this.paramsKey = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"param");
        this.withCheckPoint = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, (String)"check-point"));
        this.updateIndexes = (Boolean)MiscUtil.orElse((Object)BooleanUtils.toBooleanObject((String)IbusConfigurationHelper.getOptionalParameter(parameters, (String)"update-indexes")), (Object)true);
        this.dataSource = (String)MiscUtil.orElse((Object)IbusConfigurationHelper.getOptionalParameter(parameters, (String)"data-source"), (Object)"b2b-rest");
        this.verionNotes = (String)MiscUtil.orElse((Object)IbusConfigurationHelper.getOptionalParameter(parameters, (String)"verion-notes"), (Object)"");
    }

    public void process(MessageContext ctx) throws Exception {
        EntityContainer container = (EntityContainer)ctx.getMandatoryObject(this.paramsKey);
        container.getVersionInfo().setDataSource(this.dataSource);
        container.getVersionInfo().setVersionNotes(String.format("%s routeId=[%s]", this.verionNotes, ctx.getRouteId()));
        EntityStorageSaveParameters parameters = new EntityStorageSaveParameters();
        parameters.dontTouchTheIndexes(!this.updateIndexes);
        parameters.context(IBusStandardContextKeys.MESSAGE_CONTEXT.name(), (Object)ctx);
        EntityStorageHelper.save((EntityContainer)container, (boolean)this.withCheckPoint, (EntityStorageSaveParameters)parameters);
    }
}

