/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDocument;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.DocumentData;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TextDocumentData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;

public class PrintableDocumentBuilder
extends BaseProcessor {
    private String contentTypeStr;
    private String contentStr;
    private String documentStr;
    private String outStr;

    public void configure(Map<String, String> params) {
        super.configure(params);
        this.contentStr = params.get("content");
        this.contentTypeStr = params.get("contentType");
        this.documentStr = params.get("document");
        this.outStr = params.get("out");
        if (StringUtils.isBlank((String)this.outStr)) {
            throw Xeption.forDeveloper((String)"Incorrect {0} configuration. Output object key is required.", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if ((StringUtils.isBlank((String)this.contentStr) || StringUtils.isBlank((String)this.contentTypeStr)) && StringUtils.isBlank((String)this.documentStr)) {
            throw Xeption.forDeveloper((String)"Incorrect {0} configuration. Document's content and content type or document itself is required.", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (StringUtils.isNotBlank((String)this.contentStr) && StringUtils.isNotBlank((String)this.contentTypeStr) && StringUtils.isNotBlank((String)this.documentStr) || StringUtils.isNotBlank((String)this.contentStr) && StringUtils.isNotBlank((String)this.documentStr) || StringUtils.isNotBlank((String)this.contentTypeStr) && StringUtils.isNotBlank((String)this.documentStr)) {
            throw Xeption.forDeveloper((String)"Ambiguous {0} configuration. Specify either document's content and content type or document itself.", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageContext ctx) throws Exception {
        TextDocumentData result;
        DocumentInfo info;
        if (StringUtils.isNotBlank((String)this.contentStr) && StringUtils.isNotBlank((String)this.contentTypeStr)) {
            info = new DocumentInfo((byte[])ctx.getMandatoryObject(this.contentStr), ContentType.valueOf((String)this.contentTypeStr));
        } else {
            if (!StringUtils.isNotBlank((String)this.documentStr)) throw Xeption.forDeveloper((String)"Incorrect {0} configuration.", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()});
            Object input = ctx.getMandatoryObject(this.documentStr);
            if (EntityContainer.class.isAssignableFrom(input.getClass())) {
                info = this.getDocumentInfo((BaseEntity)input);
            } else {
                if (!Collection.class.isAssignableFrom(input.getClass())) throw Xeption.forDeveloper((String)"Printing documents of type {0} is not supported.", (Object[])new Object[]{input.getClass().getName()});
                Collection documents = (Collection)input;
                if (documents.size() < 1) {
                    throw Xeption.forDeveloper((String)"Empty document collection supplied for printing.", (Object[])new Object[0]);
                }
                if (documents.size() == 1) {
                    info = this.getDocumentInfo((BaseEntity)documents.iterator().next());
                } else {
                    PDFMergerUtility mergerUtility = new PDFMergerUtility();
                    ArrayList<ByteArrayInputStream> toBeClosed = new ArrayList<ByteArrayInputStream>();
                    for (EntityContainer document : documents) {
                        if (((BaseFileDocument)document.getEntity()).getContentType() != ContentType.PDF) {
                            throw Xeption.forDeveloper((String)"Document [{0}] is in unsupported format [{1}] for merging.", (Object[])new Object[]{((BaseFileDocument)document.getEntity()).getUid(), ((BaseFileDocument)document.getEntity()).getContentType().name()});
                        }
                        ByteArrayInputStream in = new ByteArrayInputStream(((BaseFileDocument)document.getEntity()).getContent());
                        toBeClosed.add(in);
                        mergerUtility.addSource((InputStream)in);
                    }
                    toBeClosed.forEach(IOUtils::closeQuietly);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    mergerUtility.setDestinationStream((OutputStream)out);
                    mergerUtility.mergeDocuments();
                    info = new DocumentInfo(out.toByteArray(), ContentType.PDF);
                }
            }
        }
        if (info.contentType == ContentType.HTML) {
            result = new TextDocumentData();
            result.setContentType(info.contentType);
            result.setContent(new String(info.content, StandardCharsets.UTF_8));
            ctx.putObject(this.outStr, (Object)result);
            return;
        } else {
            result = new DocumentData();
            result.setContentType(info.contentType);
            result.setContent(info.content);
            ctx.putObject(this.outStr, (Object)result);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DocumentInfo getDocumentInfo(BaseEntity input) {
        if (!(input instanceof EntityContainer)) throw Xeption.forDeveloper((String)"Printing documents of type {0} is not supported.", (Object[])new Object[]{input.getClass().getName()});
        EntityContainer ctr = (EntityContainer)input;
        if (BaseFileDocument.class.isAssignableFrom(ctr.getEntityType())) {
            BaseFileDocument doc = (BaseFileDocument)ctr.getEntity();
            return new DocumentInfo(doc.getContent(), doc.getContentType());
        }
        if (ctr.getEntityType().isAssignableFrom(BaseSingleFileReportDocument.class)) {
            BaseSingleFileReportDocument doc = (BaseSingleFileReportDocument)ctr.getEntity();
            return new DocumentInfo(doc.getFile().getContent(), doc.getFile().getContentType());
        }
        if (!ctr.getEntityType().isAssignableFrom(BaseSingleFileTemplateReportDocument.class)) throw Xeption.forDeveloper((String)"Printing documents of type {0} is not supported.", (Object[])new Object[]{ctr.getEntityType().getName()});
        BaseSingleFileTemplateReportDocument doc = (BaseSingleFileTemplateReportDocument)ctr.getEntity();
        return new DocumentInfo(doc.getFile().getContent(), doc.getFile().getContentType());
    }

    private class DocumentInfo {
        private final byte[] content;
        private final ContentType contentType;

        public DocumentInfo(byte[] content, ContentType contentType) {
            this.content = content;
            this.contentType = contentType;
        }

        public byte[] getContent() {
            return this.content;
        }

        public ContentType getContentType() {
            return this.contentType;
        }
    }
}

