/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Map;

public class PropertySetterProcessor
extends BaseProcessor {
    private String inputKey;
    private String valueKey;
    private String property;

    public void configure(Map<String, String> parameters) {
        this.inputKey = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"input");
        this.valueKey = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"value");
        this.property = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"property");
    }

    public void process(MessageContext ctx) throws Exception {
        Object target = ctx.getObject(this.inputKey);
        Object value = ctx.getObject(this.valueKey);
        if (EntityContainer.class.isAssignableFrom(target.getClass())) {
            target = ((EntityContainer)target).getEntity();
        }
        if (Introspectable.class.isAssignableFrom(target.getClass())) {
            Introspectable i = (Introspectable)target;
            if (Collection.class.isAssignableFrom(value.getClass())) {
                Collection targetCollection = (Collection)i.getValue(this.property);
                targetCollection.addAll((Collection)value);
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                Map targetMap = (Map)i.getValue(this.property);
                targetMap.putAll((Map)value);
            } else {
                i.setValue(this.property, value);
            }
        } else {
            throw Xeption.forDeveloper((String)"Field setting is not available for {0}.", (Object[])new Object[]{target.getClass()});
        }
    }
}

