/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Phone;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.ConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.ValidationMessages;
import java.util.ArrayList;
import java.util.Collection;

public class RailRestValidationHelper {
    public static boolean isBlank(Phone phone) {
        return CommonHelper.isEmpty(phone);
    }

    public static boolean validateEmail(String email) {
        return RailRestValidationHelper.validateEmail(email, false);
    }

    public static boolean validateEmail(String email, boolean onlyOne) {
        String[] emails = ConverterHelper.cleanEmail(email).split(",");
        if (onlyOne && emails.length != 1) {
            return false;
        }
        for (String string : emails) {
            if (CommonValidationHelper.isValidEmailFormat(string.trim())) continue;
            return false;
        }
        return true;
    }

    public static Collection<ValidationMessage> validateContactPhone(Phone phone) {
        ArrayList<ValidationMessage> collection = new ArrayList<ValidationMessage>();
        if (CommonHelper.isEmpty(phone)) {
            collection.add(ValidationMessages.getMissingRequiredField());
        } else if (!CommonValidationHelper.buildPhone2String(phone).matches("[0-9]*")) {
            collection.add(ValidationMessages.getOnlyNumbers());
        }
        return collection;
    }

    public static boolean isValidateContactPhone(Phone phone, Collection<ValidationMessage> messages) {
        if (phone == null) {
            messages.add(ValidationMessages.getMissingRequiredField());
            return false;
        }
        Collection<ValidationMessage> validationMessages = RailRestValidationHelper.validateContactPhone(phone);
        if (!CollectionUtil.isEmpty(validationMessages)) {
            messages.addAll(validationMessages);
            return false;
        }
        return true;
    }
}

