/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest.rail;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rest.BaseRestEntity;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RestEntityPropertyExtractorProcessor
extends BaseProcessor {
    public static final String SOURCE_KEY = "source_key";
    public static final String PROPERTY_NAME = "property_name";
    public static final String TARGET_KEY = "target_key";
    public static final String VALUE_TO_STRING_KEY = "to_string";
    private String sourceKey;
    private List<String> propertyNames;
    private String targetKey;
    private boolean valueToString;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.sourceKey = parameters.get(SOURCE_KEY);
        this.propertyNames = Arrays.asList(parameters.get(PROPERTY_NAME).split("\\."));
        this.targetKey = parameters.get(TARGET_KEY);
        this.valueToString = parameters.containsKey(VALUE_TO_STRING_KEY) ? Boolean.valueOf(parameters.get(VALUE_TO_STRING_KEY)) : false;
    }

    public void process(MessageContext ctx) throws Exception {
        Object source;
        Object value = source = ctx.getMandatoryObject(this.sourceKey);
        for (String propertyName : this.propertyNames) {
            value = this.extractProperty(value, propertyName);
        }
        if (this.valueToString) {
            value = value != null ? value.toString() : "null";
        }
        ctx.putObject(this.targetKey, value);
    }

    private Object extractProperty(Object source, String propertyName) {
        if (source instanceof BaseRestEntity) {
            return ((BaseRestEntity)source).getValue(propertyName);
        }
        if (source instanceof BaseEntity) {
            if (source instanceof EntityContainer && propertyName.equals("entity")) {
                return ((EntityContainer)source).getEntity();
            }
            return ((BaseEntity)source).getValue(propertyName);
        }
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            if (propertyName.equals("size")) {
                return collection.size();
            }
            if (collection instanceof List) {
                List list = (List)collection;
                return list.get(Integer.parseInt(propertyName));
            }
        }
        throw Xeption.forDeveloper((String)("invalid property parameter. source: " + source + ". propertyName: " + propertyName), (Object[])new Object[0]);
    }
}

